/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.typesystem.xsd.type;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.internal.xtend.type.baseimpl.OperationImpl;
import org.eclipse.internal.xtend.type.baseimpl.StaticPropertyImpl;
import org.eclipse.internal.xtend.util.StringHelper;
import org.eclipse.xtend.typesystem.Feature;
import org.eclipse.xtend.typesystem.Operation;
import org.eclipse.xtend.typesystem.Type;
import org.eclipse.xtend.typesystem.emf.EClassType;
import org.eclipse.xtend.typesystem.emf.EmfRegistryMetaModel;
import org.eclipse.xtend.typesystem.xsd.XSDMetaModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLEClassType
extends EClassType {
    private static final Log log = LogFactory.getLog(XMLEClassType.class);
    private EClass clazz;
    private XSDMetaModel model;

    public XMLEClassType(XSDMetaModel model, String name, EClass class1) {
        super((EmfRegistryMetaModel)model, name, class1);
        this.clazz = class1;
        this.model = model;
    }

    public Feature[] getContributedFeatures() {
        ArrayList<Feature> r = new ArrayList<Feature>(Arrays.asList(super.getContributedFeatures()));
        for (final EStructuralFeature f : this.clazz.getEStructuralFeatures()) {
            Type t;
            EDataType dt;
            if (!f.isChangeable() || f.isMany() || !(f.getEType() instanceof EDataType) || ExtendedMetaData.INSTANCE.getMemberTypes(dt = (EDataType)f.getEType()).size() == 0 || (t = this.model.getTypeForETypedElement((ETypedElement)f)) == null) continue;
            this.replaceOperation(r, (Operation)new CompositeTypeAwareSetter(f, t));
        }
        for (final EStructuralFeature f : this.clazz.getEStructuralFeatures()) {
            r.add((Feature)new StaticPropertyImpl((Type)this, f.getName(), (Type)this.model.getEFeatureType()){

                public Object get() {
                    return f;
                }
            });
        }
        return r.toArray(new Feature[r.size()]);
    }

    private String getTypeName(EClassifier type) {
        if (type == null) {
            return "null";
        }
        return type.getName();
    }

    private void replaceOperation(ArrayList<Feature> list, Operation op) {
        int i = 0;
        while (i < list.size()) {
            Feature f = list.get(i);
            if (f instanceof Operation && f.getName().equals(op.getName()) && ((Operation)f).getParameterTypes().equals(op.getParameterTypes())) {
                list.set(i, (Feature)op);
                return;
            }
            ++i;
        }
    }

    private class CompositeTypeAwareSetter
    extends OperationImpl {
        private EStructuralFeature feature;
        private HashMap<Type, EDataType> members;

        public CompositeTypeAwareSetter(EStructuralFeature feature, Type type) {
            super((Type)XMLEClassType.this, "set" + StringHelper.firstUpper((String)feature.getName()), (Type)XMLEClassType.this, new Type[]{type});
            this.members = new HashMap();
            this.feature = feature;
            ExtendedMetaData em = ExtendedMetaData.INSTANCE;
            this.collectMemberTypes(em, (EDataType)feature.getEType());
        }

        private void collectMemberTypes(ExtendedMetaData em, EDataType type) {
            for (EDataType v : em.getMemberTypes(type)) {
                if (!(v instanceof EEnum)) {
                    Type k = XMLEClassType.this.model.getTypeForEClassifier((EClassifier)v);
                    if (k != null) {
                        this.members.put(k, v);
                    } else {
                        log.warn((Object)("Couldn't resolve type for " + XMLEClassType.this.getTypeName((EClassifier)v)));
                    }
                }
                this.collectMemberTypes(em, v);
            }
        }

        protected Object evaluateInternal(Object target, Object[] params) {
            try {
                Object newValue = params[0];
                if (newValue != null) {
                    for (Type t : this.members.keySet()) {
                        if (!t.isInstance(newValue)) continue;
                        newValue = t.convert(newValue, this.members.get(t).getInstanceClass());
                    }
                }
                ((EObject)target).eSet(this.feature, newValue);
                return target;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }
}

