/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpand.ui.editor.outline;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.internal.xpand2.ast.AbstractDefinition;
import org.eclipse.internal.xpand2.ast.Advice;
import org.eclipse.internal.xpand2.ast.ImportDeclaration;
import org.eclipse.internal.xpand2.ast.Template;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.xpand.ui.core.IXpandResource;
import org.eclipse.xtend.shared.ui.editor.AbstractXtendXpandEditor;
import org.eclipse.xtend.shared.ui.editor.outlineview.AbstractExtXptContentOutlinePage;
import org.eclipse.xtend.shared.ui.editor.outlineview.OutlineElement;
import org.eclipse.xtend.shared.ui.expression.editor.EditorImages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XpandContentOutlinePage
extends AbstractExtXptContentOutlinePage {
    public static final int TEMPLATE = 3;
    public static final int AROUND = 4;

    public XpandContentOutlinePage(AbstractXtendXpandEditor editor) {
        super((TextEditor)editor);
    }

    protected OutlineElement[] getChildren(Object parentElement) {
        if (parentElement instanceof IXpandResource) {
            Template tpl = (Template)((IXpandResource)parentElement).getExtXptResource();
            if (tpl == null) {
                return new OutlineElement[0];
            }
            ArrayList<OutlineElement> result = new ArrayList<OutlineElement>();
            result.addAll(this.toOutlineElementsForNamespaceImports(tpl.getImports()));
            result.addAll(this.toOutlineElementsForExtensionImports((ImportDeclaration[])tpl.getExtensions()));
            result.addAll(this.toOutlineElements(tpl.getAllDefinitions()));
            return result.toArray(new OutlineElement[result.size()]);
        }
        return new OutlineElement[0];
    }

    private List<OutlineElement> toOutlineElementsForNamespaceImports(ImportDeclaration[] declarations) {
        ArrayList<OutlineElement> l = new ArrayList<OutlineElement>();
        ImportDeclaration[] importDeclarationArray = declarations;
        int n = declarations.length;
        int n2 = 0;
        while (n2 < n) {
            ImportDeclaration s = importDeclarationArray[n2];
            l.add(new OutlineElement(s.getImportString().toString(), s.getStart(), s.getEnd() - s.getStart(), EditorImages.getImage((String)"import_ns.gif"), 1));
            ++n2;
        }
        return l;
    }

    private List<OutlineElement> toOutlineElementsForExtensionImports(ImportDeclaration[] declarations) {
        ArrayList<OutlineElement> l = new ArrayList<OutlineElement>();
        ImportDeclaration[] importDeclarationArray = declarations;
        int n = declarations.length;
        int n2 = 0;
        while (n2 < n) {
            ImportDeclaration s = importDeclarationArray[n2];
            l.add(new OutlineElement(s.getImportString().toString(), s.getStart(), s.getEnd() - s.getStart(), EditorImages.getImage((String)"import_ext.gif"), 2));
            ++n2;
        }
        return l;
    }

    private List<OutlineElement> toOutlineElements(AbstractDefinition[] definitions) {
        ArrayList<OutlineElement> l = new ArrayList<OutlineElement>();
        AbstractDefinition[] abstractDefinitionArray = definitions;
        int n = definitions.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractDefinition def = abstractDefinitionArray[n2];
            Image img = EditorImages.getImage((String)"xpand_template.gif");
            int type = 3;
            if (def instanceof Advice) {
                img = EditorImages.getImage((String)"xpand_around.gif");
                type = 4;
            }
            l.add(new OutlineElement(def.toString(), def.getStart(), def.getEnd() - def.getStart(), img, type));
            ++n2;
        }
        return l;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.registerToolbarActions(this.getSite().getActionBars());
    }

    private void registerToolbarActions(IActionBars actionBars) {
        actionBars.getToolBarManager().add((IAction)new AbstractExtXptContentOutlinePage.LexicalSortingAction((AbstractExtXptContentOutlinePage)this));
    }
}

