/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.middleend.xpand;

import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.internal.xpand2.ast.Advice;
import org.eclipse.internal.xpand2.ast.Template;
import org.eclipse.internal.xpand2.model.XpandDefinition;
import org.eclipse.xpand2.XpandExecutionContext;
import org.eclipse.xtend.backend.common.BackendTypesystem;
import org.eclipse.xtend.backend.common.NamedFunction;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.expression.Resource;
import org.eclipse.xtend.middleend.MiddleEnd;
import org.eclipse.xtend.middleend.plugins.ImportedResource;
import org.eclipse.xtend.middleend.plugins.LanguageSpecificMiddleEnd;
import org.eclipse.xtend.middleend.plugins.ParsedResource;
import org.eclipse.xtend.middleend.xpand.internal.OldDefinitionConverter;
import org.eclipse.xtend.middleend.xpand.internal.xpandlib.XpandLibContributor;
import org.eclipse.xtend.middleend.xpand.plugin.XpandDefinitionName;
import org.eclipse.xtend.middleend.xtend.OldHelper;
import org.eclipse.xtend.middleend.xtend.internal.TypeToBackendType;
import org.eclipse.xtend.middleend.xtend.internal.xtendlib.XtendLibContributor;

public final class OldXpandRegistry
implements LanguageSpecificMiddleEnd {
    private static final Log _log = LogFactory.getLog(OldXpandRegistry.class);
    private final XpandExecutionContext _ctx;
    private BackendTypesystem _ts;
    private MiddleEnd _middleEnd;

    public OldXpandRegistry(Object specificData) {
        if (specificData == null) {
            throw new IllegalArgumentException(String.valueOf(this.getName()) + " middle end is not initialized - will not contribute");
        }
        this._ctx = (XpandExecutionContext)specificData;
    }

    public void setMiddleEnd(MiddleEnd middleEnd) {
        this._middleEnd = middleEnd;
        this._ts = middleEnd.getTypesystem();
    }

    public boolean canHandle(String xpandFile) {
        xpandFile = OldHelper.normalizeXpandResourceName((String)xpandFile);
        String xpandResourceName = OldHelper.xpandFileAsOldResourceName((String)xpandFile);
        try {
            Template file = (Template)this._ctx.getResourceManager().loadResource(xpandResourceName, "xpt");
            return file != null;
        }
        catch (Exception exc) {
            _log.debug((Object)("Xpand middleend can not handle file " + xpandFile), (Throwable)exc);
            return false;
        }
    }

    public boolean mayHandle(String resourceName) {
        return resourceName.endsWith("xpt");
    }

    public String getName() {
        return "Xpand";
    }

    public ParsedResource parseResource(String xpandFile) {
        ParsedResource result = new ParsedResource();
        xpandFile = OldHelper.normalizeXpandResourceName((String)xpandFile);
        String xpandResourceName = OldHelper.xpandFileAsOldResourceName((String)xpandFile);
        Template file = (Template)this._ctx.getResourceManager().loadResource(xpandResourceName, "xpt");
        if (file == null) {
            throw new IllegalArgumentException("could not find Xpand file '" + xpandResourceName + "'");
        }
        XpandExecutionContext ctx = (XpandExecutionContext)this._ctx.cloneWithResource((Resource)file);
        TypeToBackendType typeConverter = new TypeToBackendType(this._ts, (ExecutionContext)ctx);
        OldDefinitionConverter definitionFactory = new OldDefinitionConverter(ctx, typeConverter);
        this.registerLibs(result);
        HashSet<XpandDefinitionName> referenced = new HashSet<XpandDefinitionName>();
        Object[] objectArray = file.getDefinitions();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            XpandDefinition ext = objectArray[n2];
            result.getPublicFunctions().add(definitionFactory.createUnregistered(ext, referenced));
            ++n2;
        }
        objectArray = file.getAdvices();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            XpandDefinition a = objectArray[n2];
            result.getAdvice().add(definitionFactory.create((Advice)a, referenced));
            ++n2;
        }
        objectArray = file.getImportedExtensions();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            XpandDefinition imported = objectArray[n2];
            result.getImports().add(new ImportedResource((String)imported, false));
            ++n2;
        }
        HashSet<String> xpandFileNames = new HashSet<String>();
        for (XpandDefinitionName n3 : referenced) {
            xpandFileNames.add(n3.getCanonicalTemplateFileName());
        }
        for (String importedXpand : xpandFileNames) {
            result.getImports().add(new ImportedResource(importedXpand, false));
        }
        return result;
    }

    private void registerLibs(ParsedResource result) {
        XtendLibContributor xtendLibContrib = new XtendLibContributor(this._middleEnd);
        for (String contrib : xtendLibContrib.getContributingResources()) {
            result.getImports().add(new ImportedResource(contrib, false));
        }
        for (NamedFunction f : xtendLibContrib.getContributedFunctions()) {
            result.getPrivateFunctions().add(f);
        }
        XpandLibContributor xpandLibContrib = new XpandLibContributor(this._middleEnd);
        for (String contrib : xpandLibContrib.getContributingResources()) {
            result.getImports().add(new ImportedResource(contrib, false));
        }
        for (NamedFunction f : new XpandLibContributor(this._middleEnd).getContributedFunctions()) {
            result.getPrivateFunctions().add(f);
        }
    }
}

