/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.backend.expr;

import java.util.Collection;
import org.eclipse.xtend.backend.common.ExecutionContext;
import org.eclipse.xtend.backend.common.ExpressionBase;
import org.eclipse.xtend.backend.common.SourcePos;
import org.eclipse.xtend.backend.syslib.CollectionOperations;

public final class PropertyOnCollectionExpression
extends ExpressionBase {
    private final ExpressionBase _inner;
    private final String _propertyName;

    public PropertyOnCollectionExpression(ExpressionBase inner, String propertyName, SourcePos sourcePos) {
        super(sourcePos);
        this._inner = inner;
        this._propertyName = propertyName;
    }

    public ExpressionBase getInnerExpression() {
        return this._inner;
    }

    public String getPropertyName() {
        return this._propertyName;
    }

    protected Object evaluateInternal(ExecutionContext ctx) {
        Collection coll = (Collection)this._inner.evaluate(ctx);
        if (coll == null) {
            ctx.logNullDeRef(this.getPos());
            return null;
        }
        Collection<Object> result = CollectionOperations.createMatchingCollection(coll);
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("evaluating property " + this._propertyName + " on collection " + coll));
        }
        for (Object o : coll) {
            CollectionOperations.addFlattened(result, ctx.getTypesystem().findType(o).getProperty(ctx, o, this._propertyName));
        }
        return result;
    }
}

