/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.backend.types.java;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.xtend.backend.common.BackendType;
import org.eclipse.xtend.backend.common.BackendTypesystem;
import org.eclipse.xtend.backend.common.QualifiedName;
import org.eclipse.xtend.backend.functions.java.internal.JavaBuiltinConverterFactory;
import org.eclipse.xtend.backend.types.AbstractType;
import org.eclipse.xtend.backend.types.java.JavaBeansStaticProperty;
import org.eclipse.xtend.backend.types.java.JavaOperation;
import org.eclipse.xtend.backend.util.ErrorHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaBeansType
extends AbstractType {
    private final Class<?> _javaClass;

    public JavaBeansType(Class<?> javaCls, BackendTypesystem ts) {
        super(javaCls.getName().replace(".", "::"), "{javabean}" + javaCls.getName(), JavaBeansType.superTypes(javaCls, ts));
        this._javaClass = javaCls;
    }

    private static BackendType[] superTypes(Class<?> javaCls, BackendTypesystem ts) {
        ArrayList resultRaw = new ArrayList(Arrays.asList(javaCls.getInterfaces()));
        Class<?> superClass = javaCls.getSuperclass();
        if (superClass != null) {
            resultRaw.add(superClass);
        }
        ArrayList<BackendType> result = new ArrayList<BackendType>();
        for (Class clazz : resultRaw) {
            result.add(ts.getRootTypesystem().findType(clazz));
        }
        return result.toArray(new BackendType[result.size()]);
    }

    void init(BackendTypesystem ts) {
        AccessibleObject[] accessibleObjectArray = this._javaClass.getMethods();
        int n = accessibleObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method mtd = accessibleObjectArray[n2];
            if (mtd.getDeclaringClass() != Object.class) {
                ArrayList<BackendType> paramTypes = new ArrayList<BackendType>();
                paramTypes.add(this);
                Class<?>[] classArray = mtd.getParameterTypes();
                int n3 = classArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Class<?> cls = classArray[n4];
                    paramTypes.add(ts.getRootTypesystem().findType(cls));
                    ++n4;
                }
                this.register(new QualifiedName(mtd.getName()), new JavaOperation(mtd, paramTypes, ts.findType(mtd.getReturnType()), null));
            }
            ++n2;
        }
        accessibleObjectArray = this._javaClass.getFields();
        n = accessibleObjectArray.length;
        n2 = 0;
        while (n2 < n) {
            AccessibleObject field = accessibleObjectArray[n2];
            int mod = ((Field)field).getModifiers();
            if (Modifier.isPublic(mod) && Modifier.isStatic(mod) && Modifier.isFinal(mod)) {
                try {
                    this.register(new JavaBeansStaticProperty((Field)field, (BackendType)this, ts.getRootTypesystem().findType(((Field)field).getType()), JavaBuiltinConverterFactory.getConverter(((Field)field).getType())));
                }
                catch (Exception e) {
                    ErrorHandler.handle(e);
                }
            }
            ++n2;
        }
        ?[] enumValues = this._javaClass.getEnumConstants();
        if (enumValues != null) {
            ?[] objArray = enumValues;
            int n5 = enumValues.length;
            n = 0;
            while (n < n5) {
                Object o = objArray[n];
                Enum curEnum = (Enum)o;
                this.register(new JavaBeansStaticProperty(this, ts.getRootTypesystem().findType(curEnum), curEnum.name(), curEnum));
                ++n;
            }
        }
    }

    @Override
    public Object create() {
        try {
            return this._javaClass.newInstance();
        }
        catch (Exception e) {
            ErrorHandler.handle(e);
            return null;
        }
    }

    @Override
    public String toString() {
        return "JavaBeansType[" + this._javaClass.getName() + "]";
    }

    @Override
    public boolean equals(Object other) {
        if (other == null || !(other instanceof JavaBeansType)) {
            return false;
        }
        return ((JavaBeansType)other)._javaClass.equals(this._javaClass);
    }
}

