/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpand.ui.core.internal;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IStorage;
import org.eclipse.internal.xpand2.model.XpandAdvice;
import org.eclipse.internal.xpand2.model.XpandDefinition;
import org.eclipse.internal.xpand2.model.XpandResource;
import org.eclipse.xpand.ui.core.IXpandResource;
import org.eclipse.xpand.ui.core.internal.builder.XpandResourceParser;
import org.eclipse.xpand2.XpandExecutionContext;
import org.eclipse.xtend.expression.AnalysationIssue;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.expression.Resource;
import org.eclipse.xtend.shared.ui.core.AbstractResource;
import org.eclipse.xtend.shared.ui.core.internal.BuildState;
import org.eclipse.xtend.shared.ui.core.internal.ResourceID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XpandResourceImpl
extends AbstractResource
implements IXpandResource {
    private XpandResourceParser parser;

    public XpandResourceImpl(XpandResource tpl, IStorage source, XpandResourceParser parser) {
        super(source);
        this.setExtXptResource((Resource)tpl);
        this.parser = parser;
    }

    private XpandResource resource() {
        return (XpandResource)this.getExtXptResource();
    }

    public void analyze(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        HashSet issuesFromThisResource = new HashSet();
        try {
            BuildState buildState = BuildState.get((ExecutionContext)ctx);
            if (buildState != null) {
                ResourceID id = new ResourceID(this.resource().getFullyQualifiedName(), this.getFileExtension());
                HashSet internalIssues = (HashSet)buildState.getIssuesPerResource().get(id);
                if (internalIssues == null) {
                    internalIssues = new HashSet();
                    this.resource().analyze((XpandExecutionContext)ctx, internalIssues);
                    buildState.getIssuesPerResource().put(id, internalIssues);
                }
                issuesFromThisResource.addAll(internalIssues);
            } else {
                this.resource().analyze((XpandExecutionContext)ctx, issuesFromThisResource);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        issues.addAll(issuesFromThisResource);
    }

    public void analyze(XpandExecutionContext ctx, Set<AnalysationIssue> issues) {
        HashSet issuesFromThisResource = new HashSet();
        try {
            BuildState buildState = BuildState.get((ExecutionContext)ctx);
            if (buildState != null) {
                ResourceID id = new ResourceID(this.resource().getFullyQualifiedName(), this.getFileExtension());
                HashSet internalIssues = (HashSet)buildState.getIssuesPerResource().get(id);
                if (internalIssues == null) {
                    internalIssues = new HashSet();
                    this.resource().analyze(ctx, internalIssues);
                    issuesFromThisResource.addAll(internalIssues);
                    buildState.getIssuesPerResource().put(id, internalIssues);
                }
            } else {
                this.resource().analyze(ctx, issuesFromThisResource);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        issues.addAll(issuesFromThisResource);
    }

    public XpandDefinition[] getDefinitions() {
        return this.resource().getDefinitions();
    }

    public XpandDefinition[] getDefinitionsByName(String name) {
        return this.resource().getDefinitionsByName(name);
    }

    public XpandAdvice[] getAdvices() {
        return this.resource().getAdvices();
    }

    public String getFileExtension() {
        return this.parser.getFileExtension();
    }

    public boolean internalRefresh() {
        Resource r = this.parser.parse(this.getUnderlyingStorage(), this.getFullyQualifiedName());
        if (r == null) {
            return false;
        }
        this.setExtXptResource(r);
        return true;
    }
}

