/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.middleend.xtend.internal.xtend;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.internal.xtend.expression.ast.DeclaredParameter;
import org.eclipse.internal.xtend.expression.ast.Expression;
import org.eclipse.internal.xtend.expression.ast.SyntaxElement;
import org.eclipse.internal.xtend.xtend.ast.Around;
import org.eclipse.internal.xtend.xtend.ast.CreateExtensionStatement;
import org.eclipse.internal.xtend.xtend.ast.ExpressionExtensionStatement;
import org.eclipse.internal.xtend.xtend.ast.Extension;
import org.eclipse.internal.xtend.xtend.ast.JavaExtensionStatement;
import org.eclipse.xtend.backend.aop.AroundAdvice;
import org.eclipse.xtend.backend.common.BackendType;
import org.eclipse.xtend.backend.common.ExpressionBase;
import org.eclipse.xtend.backend.common.Function;
import org.eclipse.xtend.backend.common.NamedFunction;
import org.eclipse.xtend.backend.common.QualifiedName;
import org.eclipse.xtend.backend.expr.CreateCachedExpression;
import org.eclipse.xtend.backend.expr.CreateUncachedExpression;
import org.eclipse.xtend.backend.expr.LocalVarEvalExpression;
import org.eclipse.xtend.backend.expr.NewLocalVarDefExpression;
import org.eclipse.xtend.backend.expr.SequenceExpression;
import org.eclipse.xtend.backend.functions.SourceDefinedFunction;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.expression.TypeSystem;
import org.eclipse.xtend.expression.Variable;
import org.eclipse.xtend.middleend.xtend.internal.OldExpressionConverter;
import org.eclipse.xtend.middleend.xtend.internal.TypeToBackendType;
import org.eclipse.xtend.middleend.xtend.internal.xtend.JavaExtensionFunction;
import org.eclipse.xtend.typesystem.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OldExtensionConverter {
    private final ExecutionContext _ctx;
    private final TypeToBackendType _typeConverter;

    public OldExtensionConverter(ExecutionContext ctx, TypeToBackendType typeConverter) {
        this._ctx = ctx;
        this._typeConverter = typeConverter;
    }

    public AroundAdvice create(Around around) {
        OldExpressionConverter exprConv = new OldExpressionConverter(this._ctx, this._typeConverter, "<around>");
        List parameters = around.getParams();
        ArrayList<String> localVarNames = new ArrayList<String>();
        localVarNames.addAll(exprConv.getAdviceLocalVarNames());
        ArrayList<Type> localVarTypes = new ArrayList<Type>();
        localVarTypes.addAll(exprConv.getAdviceLocalVarTypes((TypeSystem)this._ctx));
        for (DeclaredParameter declaredParameter : parameters) {
            localVarNames.add(declaredParameter.getName().getValue());
            localVarTypes.add(this._ctx.getTypeForName(declaredParameter.getType().getValue()));
        }
        ExpressionBase body = this.convertExpression(around.getExpression(), localVarNames, localVarTypes, "<around>");
        return exprConv.convertAdvice(body, around.getPointCut().getValue(), around.getParams(), around.isWildparams());
    }

    public NamedFunction createUnregistered(Extension extension) {
        if (extension instanceof JavaExtensionStatement) {
            return new NamedFunction(new QualifiedName(extension.getQualifiedName().replaceAll("/", "::")), this.createJavaExtension((JavaExtensionStatement)extension));
        }
        if (extension instanceof ExpressionExtensionStatement) {
            return new NamedFunction(new QualifiedName(extension.getQualifiedName().replaceAll("/", "::")), this.createExpressionExtension((ExpressionExtensionStatement)extension));
        }
        if (extension instanceof CreateExtensionStatement) {
            return new NamedFunction(new QualifiedName(extension.getQualifiedName().replaceAll("/", "::")), this.createCreateExtension((CreateExtensionStatement)extension));
        }
        throw new IllegalArgumentException("unsupported extension type " + extension.getClass().getName());
    }

    private List<BackendType> getParameterTypes(Extension extension) {
        List unconvertedParamTypes = extension.getParameterTypes();
        ArrayList<BackendType> result = new ArrayList<BackendType>();
        for (Type t : unconvertedParamTypes) {
            result.add(this._typeConverter.convertToBackendType(t));
        }
        return result;
    }

    private ExpressionBase convertExpression(Expression expr, List<String> localVarNames, List<Type> localVarTypes, String extensionName) {
        ExecutionContext ctx = this._ctx.cloneWithoutVariables();
        int i = 0;
        while (i < localVarNames.size()) {
            ctx = ctx.cloneWithVariable(new Variable(localVarNames.get(i), (Object)localVarTypes.get(i)));
            ++i;
        }
        OldExpressionConverter exprConverter = new OldExpressionConverter(ctx, this._typeConverter, extensionName);
        return exprConverter.convert(expr);
    }

    private Function createExpressionExtension(ExpressionExtensionStatement extension) {
        BackendType returnType;
        try {
            returnType = this._typeConverter.convertToBackendType(extension.getReturnType());
        }
        catch (UnsupportedOperationException e) {
            returnType = null;
        }
        return new SourceDefinedFunction(new QualifiedName(extension.getQualifiedName().replaceAll("/", "::")), extension.getParameterNames(), this.getParameterTypes((Extension)extension), returnType, this.convertExpression(extension.getExpression(), extension.getParameterNames(), extension.getParameterTypes(), extension.getName()), extension.isCached(), null);
    }

    private Function createCreateExtension(CreateExtensionStatement extension) {
        BackendType returnType;
        Type createdType = this._ctx.getTypeForName(extension.getReturnTypeIdentifier().getValue());
        String createdVarName = !extension.getReturnVarName().equals("this") ? extension.getReturnVarName() : "this";
        ArrayList<LocalVarEvalExpression> paramExprs = new ArrayList<LocalVarEvalExpression>();
        for (String varName : extension.getParameterNames()) {
            paramExprs.add(new LocalVarEvalExpression(varName, OldExpressionConverter.getSourcePos((SyntaxElement)extension, extension.getName())));
        }
        ArrayList<String> innerParamNames = new ArrayList<String>();
        innerParamNames.add(createdVarName);
        innerParamNames.addAll(extension.getParameterNames());
        ArrayList<Type> innerParamTypes = new ArrayList<Type>();
        innerParamTypes.add(createdType);
        innerParamTypes.addAll(extension.getParameterTypes());
        ExpressionBase inner = this.convertExpression(extension.getExpression(), innerParamNames, innerParamTypes, extension.getName());
        ArrayList<Object> innerSeq = new ArrayList<Object>();
        innerSeq.add(inner);
        innerSeq.add(new LocalVarEvalExpression(createdVarName, inner.getPos()));
        SequenceExpression body = new SequenceExpression(innerSeq, inner.getPos());
        Object createExpr = null;
        createExpr = extension.isCached() ? new CreateCachedExpression(this._typeConverter.convertToBackendType(createdType), paramExprs, OldExpressionConverter.getSourcePos((SyntaxElement)extension, extension.getName())) : new CreateUncachedExpression(this._typeConverter.convertToBackendType(createdType), OldExpressionConverter.getSourcePos((SyntaxElement)extension, extension.getName()));
        NewLocalVarDefExpression createWrapper = new NewLocalVarDefExpression(createdVarName, (ExpressionBase)createExpr, (ExpressionBase)body, OldExpressionConverter.getSourcePos((SyntaxElement)extension, extension.getName()));
        try {
            returnType = this._typeConverter.convertToBackendType(extension.getReturnType());
        }
        catch (UnsupportedOperationException e) {
            returnType = null;
        }
        return new SourceDefinedFunction(new QualifiedName(extension.getQualifiedName()), extension.getParameterNames(), this.getParameterTypes((Extension)extension), returnType, (ExpressionBase)createWrapper, true, null);
    }

    private Function createJavaExtension(JavaExtensionStatement extension) {
        BackendType returnType;
        Method mtd = extension.getJavaMethod(this._ctx, new HashSet());
        try {
            returnType = this._typeConverter.convertToBackendType(mtd.getReturnType());
        }
        catch (UnsupportedOperationException e) {
            returnType = null;
        }
        return new JavaExtensionFunction(mtd, extension.isCached(), this.getParameterTypes((Extension)extension), returnType);
    }
}

