/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.usecase.modelfilter.dependencies.ui.internal.editor;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmt.modisco.java.Package;
import org.eclipse.gmt.modisco.java.Type;
import org.eclipse.modisco.usecase.modelfilter.dependencies.ui.internal.editor.GetUsedTypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetUsedPackages {
    final Set<Package> getUsedPackages(Package contextPackage) {
        Set<Package> result = new HashSet<Package>();
        GetUsedTypes typesFinder = new GetUsedTypes();
        for (Type ownedType : contextPackage.getOwnedElements()) {
            for (Type usedType : typesFinder.getUsedTypes(ownedType)) {
                result.add(this.getContainerPackage((EObject)usedType));
            }
        }
        for (Package ownedPackage : contextPackage.getOwnedPackages()) {
            result.addAll(this.getUsedPackages(ownedPackage));
        }
        Iterator iter = result.iterator();
        while (iter.hasNext()) {
            Package used = (Package)iter.next();
            if (!this.isParentPackage(contextPackage, used)) continue;
            iter.remove();
        }
        if (contextPackage.getOwnedElements().isEmpty()) {
            result = this.filterUsedPackages(result);
        }
        result.remove(null);
        return result;
    }

    private final Package getContainerPackage(EObject source) {
        Package result = null;
        if (source != null) {
            result = source.eContainer() instanceof Package ? (Package)source.eContainer() : this.getContainerPackage(source.eContainer());
        }
        return result;
    }

    private final Set<Package> filterUsedPackages(Set<Package> usedPackages) {
        HashSet<Package> result = new HashSet<Package>();
        for (Package usedPackage : usedPackages) {
            Package common = this.getFirstCommonPackage(usedPackage, usedPackages);
            result.add(common);
        }
        return result;
    }

    private final Package getFirstCommonPackage(Package usedPackage, Set<Package> usedPackages) {
        Package common = usedPackage;
        if (usedPackages.contains(usedPackage)) {
            HashSet<Package> subset = new HashSet<Package>(usedPackages);
            subset.remove(usedPackage);
            common = this.getFirstCommonPackage(usedPackage, subset);
        } else {
            for (Package otherPackage : usedPackages) {
                Package commonTemp = this.getFirstCommonPackage(usedPackage, otherPackage);
                if (commonTemp == null) continue;
                if (common == null) {
                    common = commonTemp;
                    continue;
                }
                if (!this.isParentPackage(commonTemp, common)) continue;
                common = commonTemp;
            }
        }
        return common;
    }

    private final Package getFirstCommonPackage(Package usedPackage, Package otherPackage) {
        Package common = null;
        Package current = usedPackage;
        while (common == null && current != null) {
            if (this.isParentPackage(current, otherPackage)) {
                common = current;
                continue;
            }
            current = current.getPackage();
        }
        return common;
    }

    private boolean isParentPackage(Package parent, Package otherPackage) {
        boolean result = false;
        if (parent != null && otherPackage != null) {
            result = parent == otherPackage ? true : this.isParentPackage(parent, otherPackage.getPackage());
        }
        return result;
    }
}

