/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.regex;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.FilteredTermEnum;
import org.apache.lucene.search.regex.RegexCapabilities;

public class RegexTermEnum
extends FilteredTermEnum {
    private String field = "";
    private String pre = "";
    private boolean endEnum = false;
    private RegexCapabilities regexImpl;

    public RegexTermEnum(IndexReader reader, Term term, RegexCapabilities regexImpl) throws IOException {
        this.field = term.field();
        String text = term.text();
        this.regexImpl = regexImpl;
        regexImpl.compile(text);
        this.pre = regexImpl.prefix();
        if (this.pre == null) {
            this.pre = "";
        }
        this.setEnum(reader.terms(new Term(term.field(), this.pre)));
    }

    protected final boolean termCompare(Term term) {
        String searchText;
        if (this.field == term.field() && (searchText = term.text()).startsWith(this.pre)) {
            return this.regexImpl.match(searchText);
        }
        this.endEnum = true;
        return false;
    }

    public final float difference() {
        return 1.0f;
    }

    public final boolean endEnum() {
        return this.endEnum;
    }

    public void close() throws IOException {
        super.close();
        this.field = null;
    }
}

