/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.usecase.modelfilter.dependencies.ui.internal.handlers;

import java.io.IOException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.modisco.infra.discovery.core.exception.DiscoveryException;
import org.eclipse.modisco.java.Package;
import org.eclipse.modisco.java.Type;
import org.eclipse.modisco.java.discoverer.DiscoverJavaModelFromJavaProject;
import org.eclipse.modisco.java.discoverer.JavaModelUtils;
import org.eclipse.modisco.java.discoverer.internal.core.JavaJdtBridge;
import org.eclipse.modisco.usecase.modelfilter.dependencies.ui.internal.Activator;
import org.eclipse.modisco.usecase.modelfilter.dependencies.ui.internal.Messages;
import org.eclipse.modisco.usecase.modelfilter.dependencies.ui.internal.editor.PrefuseGraphInput;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.ide.IDE;

public class DisplayDependenciesHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object object : structuredSelection) {
                DisplayDependenciesHandler.open(object);
            }
        }
        return null;
    }

    private static void open(Object object) {
        if (object instanceof IJavaProject) {
            IJavaProject javaProject = (IJavaProject)object;
            DisplayDependenciesHandler.openOn(javaProject);
        } else if (object instanceof IFile) {
            IFile file = (IFile)object;
            if (JavaModelUtils.isJavaModelFile((IFile)file)) {
                DisplayDependenciesHandler.openOn(file);
            } else {
                MoDiscoLogger.logWarning((String)("Not a Java model: " + file.getFullPath().toString()), (Plugin)Activator.getDefault());
            }
        } else if (object instanceof IType) {
            IType type = (IType)object;
            IJavaProject javaProject = type.getJavaProject();
            DisplayDependenciesHandler.openOn(type, javaProject);
        } else if (object instanceof ICompilationUnit) {
            ICompilationUnit compilationUnit = (ICompilationUnit)object;
            String typeName = compilationUnit.getPath().removeFileExtension().lastSegment();
            IType type = compilationUnit.getType(typeName);
            IJavaProject javaProject = type.getJavaProject();
            DisplayDependenciesHandler.openOn(type, javaProject);
        } else if (object instanceof IPackageFragment) {
            IPackageFragment packageFragment = (IPackageFragment)object;
            DisplayDependenciesHandler.openOn(packageFragment, packageFragment.getJavaProject());
        } else {
            MoDiscoLogger.logWarning((String)("Input not handled: " + object.getClass().getName()), (Plugin)Activator.getDefault());
        }
    }

    private static void openOn(final IPackageFragment packageFragment, final IJavaProject javaProject) {
        Job job = new Job(Messages.DisplayDependenciesHandler_discoverJavaProject){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    DiscoverJavaModelFromJavaProject discoverer = new DiscoverJavaModelFromJavaProject();
                    discoverer.discoverElement((Object)javaProject, (IProgressMonitor)new NullProgressMonitor());
                    Resource resource = discoverer.getTargetModel();
                    JavaJdtBridge bridge = new JavaJdtBridge();
                    Package modelPackage = bridge.getJavaPackage(resource, packageFragment);
                    if (modelPackage != null) {
                        PrefuseGraphInput prefuseGraphInput = new PrefuseGraphInput(modelPackage, javaProject);
                        DisplayDependenciesHandler.openPrefuseEditor(prefuseGraphInput);
                    }
                }
                catch (DiscoveryException e) {
                    MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    private static void openOn(final IType type, final IJavaProject javaProject) {
        Job job = new Job(Messages.DisplayDependenciesHandler_discoverJavaProject){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    DiscoverJavaModelFromJavaProject discoverer = new DiscoverJavaModelFromJavaProject();
                    discoverer.discoverElement((Object)javaProject, (IProgressMonitor)new NullProgressMonitor());
                    Resource targetModel = discoverer.getTargetModel();
                    JavaJdtBridge bridge = new JavaJdtBridge();
                    Type modelType = bridge.getJavaType(targetModel, type);
                    if (modelType != null) {
                        PrefuseGraphInput prefuseGraphInput = new PrefuseGraphInput(modelType, javaProject);
                        DisplayDependenciesHandler.openPrefuseEditor(prefuseGraphInput);
                    }
                }
                catch (DiscoveryException e) {
                    MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    private static void openOn(final IFile file) {
        Job job = new Job(Messages.DisplayDependenciesHandler_openJavaModelFile){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ResourceSetImpl resourceSet = new ResourceSetImpl();
                    Resource resource = resourceSet.createResource(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true));
                    resource.load(null);
                    PrefuseGraphInput input = new PrefuseGraphInput(resource, JavaCore.create((IProject)file.getProject()));
                    DisplayDependenciesHandler.openPrefuseEditor(input);
                }
                catch (IOException e) {
                    MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    private static void openOn(final IJavaProject javaProject) {
        Job job = new Job(Messages.DisplayDependenciesHandler_discoverJavaProject){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    DiscoverJavaModelFromJavaProject discoverer = new DiscoverJavaModelFromJavaProject();
                    discoverer.discoverElement((Object)javaProject, (IProgressMonitor)new NullProgressMonitor());
                    Resource targetModel = discoverer.getTargetModel();
                    PrefuseGraphInput input = new PrefuseGraphInput(targetModel, javaProject);
                    DisplayDependenciesHandler.openPrefuseEditor(input);
                }
                catch (DiscoveryException e) {
                    MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    protected static void openPrefuseEditor(final IEditorInput editorInput) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    IDE.openEditor((IWorkbenchPage)page, (IEditorInput)editorInput, (String)"org.eclipse.modisco.usecase.modelfilter.dependencies.modeleditor.prefuse.EditorID", (boolean)true);
                }
                catch (PartInitException e) {
                    MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
                }
            }
        });
    }
}

