/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.java.discoverer.ui.internal;

import java.io.File;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.modisco.java.discoverer.AbstractDiscoverJavaModelFromProject;
import org.eclipse.modisco.java.discoverer.ElementsToAnalyze;
import org.eclipse.modisco.java.discoverer.ui.internal.Activator;
import org.eclipse.modisco.java.discoverer.ui.internal.Messages;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class JavaElementsToAnalyzeDialog
extends TitleAreaDialog {
    private static final int COLUMN_USE_SOURCE_WIDTH = 130;
    private static final int COLUMN_DEPENDENCY_SHORTNAME_WIDTH = 400;
    private static final int COLUMN_DEPENDENCY_LONGNAME_WIDTH = 200;
    private static final int DIALOG_WIDTH = 800;
    private static final int DIALOG_HEIGHT = 700;
    private static final String USE_SOURCES_OPTIONS = "USE_SOURCES";
    private final ElementsToAnalyze elementsToAnalyze;
    private CheckboxTreeViewer dependenciesTree;
    private Label textNumberElementsSelected;

    protected JavaElementsToAnalyzeDialog(Shell parentShell, ElementsToAnalyze initialElementsToAnalyze) {
        super(parentShell);
        if (initialElementsToAnalyze == null) {
            throw new IllegalStateException("initialElementsToAnalyze is null. It should be initialized (cf @ParameterInitialValue)");
        }
        this.elementsToAnalyze = AbstractDiscoverJavaModelFromProject.computeElementsToDiscover((ElementsToAnalyze)initialElementsToAnalyze);
    }

    protected Control createDialogArea(Composite parent) {
        Object[] elements;
        CheckboxTreeViewer treeViewer;
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout());
        this.setTitle(Messages.JavaElementsToAnalyzeDialog_title);
        this.setMessage(Messages.JavaElementsToAnalyzeDialog_message);
        this.dependenciesTree = treeViewer = new CheckboxTreeViewer(composite, 68356);
        treeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object element = event.getElement();
                if (event.getChecked()) {
                    JavaElementsToAnalyzeDialog.this.getElementsToAnalyze().addElementToDiscover(element);
                } else {
                    JavaElementsToAnalyzeDialog.this.getElementsToAnalyze().removeElementToDiscover(element);
                }
                treeViewer.update(event.getElement(), null);
                JavaElementsToAnalyzeDialog.this.refreshInformationLabel();
            }
        });
        treeViewer.getTree().setLinesVisible(true);
        treeViewer.getTree().setHeaderVisible(true);
        TreeViewerColumn columnShortName = new TreeViewerColumn((TreeViewer)this.getDependenciesTree(), 0);
        columnShortName.getColumn().setWidth(400);
        columnShortName.getColumn().setText(Messages.JavaElementsToAnalyzeDialog_name);
        columnShortName.setLabelProvider((CellLabelProvider)new JDTDelegateColumnLabelProvider(true));
        TreeViewerColumn columnUseSource = new TreeViewerColumn((TreeViewer)this.getDependenciesTree(), 0);
        columnUseSource.getColumn().setWidth(130);
        columnUseSource.getColumn().setText(Messages.JavaElementsToAnalyzeDialog_useSources);
        columnUseSource.getColumn().setAlignment(0x1000000);
        columnUseSource.setLabelProvider((CellLabelProvider)new UseSourceColumnLabelProvider());
        columnUseSource.setEditingSupport((EditingSupport)new UseSourceEditingSupport((ColumnViewer)this.getDependenciesTree()));
        TreeViewerColumn columnLongName = new TreeViewerColumn((TreeViewer)this.getDependenciesTree(), 0);
        columnLongName.getColumn().setWidth(200);
        columnLongName.getColumn().setText(Messages.JavaElementsToAnalyzeDialog_Path);
        columnLongName.setLabelProvider((CellLabelProvider)new JDTDelegateColumnLabelProvider(false));
        treeViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        DependenciesContentProvider contentProvider = new DependenciesContentProvider();
        this.getDependenciesTree().setContentProvider((IContentProvider)contentProvider);
        DependenciesTreeInput input = new DependenciesTreeInput(this.elementsToAnalyze.getJavaProject());
        this.getDependenciesTree().setInput((Object)input);
        Object[] objectArray = elements = contentProvider.getElements(input);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object[] children;
            Object element = objectArray[n2];
            if (this.getElementsToAnalyze().getElementsToDiscover().contains(element)) {
                this.getDependenciesTree().setChecked(element, true);
                this.getDependenciesTree().expandToLevel(element, 1);
            }
            Object[] objectArray2 = children = contentProvider.getChildren(element);
            int n3 = children.length;
            int n4 = 0;
            while (n4 < n3) {
                Object child = objectArray2[n4];
                if (this.getElementsToAnalyze().getElementsToDiscover().contains(child)) {
                    this.getDependenciesTree().setChecked(child, true);
                }
                ++n4;
            }
            ++n2;
        }
        Composite compositeLabels = new Composite(composite, 0);
        compositeLabels.setLayoutData((Object)new GridData(4, 4, true, false));
        RowLayout rowLayout = new RowLayout();
        rowLayout.wrap = false;
        compositeLabels.setLayout((Layout)rowLayout);
        Label imageInformationNumberElementsSelected = new Label(compositeLabels, 0);
        imageInformationNumberElementsSelected.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK"));
        this.textNumberElementsSelected = new Label(compositeLabels, 0);
        this.refreshInformationLabel();
        return composite;
    }

    protected static boolean hasSourceAvailable(Object element) {
        if (element instanceof IPackageFragmentRoot) {
            IPackageFragmentRoot lib = (IPackageFragmentRoot)element;
            try {
                return lib.getSourceAttachmentPath() != null;
            }
            catch (JavaModelException e) {
                MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
            }
        }
        return false;
    }

    protected void refreshInformationLabel() {
        int nProjectsSelected = 0;
        int nLibrariesSelected = 0;
        Object[] objectArray = this.getDependenciesTree().getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof IJavaProject) {
                ++nProjectsSelected;
            } else if (element instanceof IPackageFragmentRoot) {
                ++nLibrariesSelected;
            }
            ++n2;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(nProjectsSelected);
        if (nProjectsSelected > 1) {
            builder.append(Messages.JavaElementsToAnalyzeDialog_projects);
        } else {
            builder.append(Messages.JavaElementsToAnalyzeDialog_project);
        }
        builder.append(Messages.JavaElementsToAnalyzeDialog_and);
        builder.append(nLibrariesSelected);
        if (nLibrariesSelected > 1) {
            builder.append(Messages.JavaElementsToAnalyzeDialog_libraries);
        } else {
            builder.append(Messages.JavaElementsToAnalyzeDialog_library);
        }
        builder.append(Messages.JavaElementsToAnalyzeDialog_selected);
        this.textNumberElementsSelected.setText(builder.toString());
        this.textNumberElementsSelected.pack(true);
    }

    protected CheckboxTreeViewer getDependenciesTree() {
        return this.dependenciesTree;
    }

    public ElementsToAnalyze getElementsToAnalyze() {
        return this.elementsToAnalyze;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        String sectionName = JavaElementsToAnalyzeDialog.class.getName();
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(sectionName);
        if (section == null) {
            section = settings.addNewSection(sectionName);
            section.put("DIALOG_WIDTH", 800);
            section.put("DIALOG_HEIGHT", 700);
        }
        return section;
    }

    protected boolean isResizable() {
        return true;
    }

    public boolean isHelpAvailable() {
        return false;
    }

    protected class DependenciesContentProvider
    implements ITreeContentProvider {
        protected DependenciesContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof DependenciesTreeInput) {
                IJavaProject javaProject = ((DependenciesTreeInput)inputElement).getJavaProject();
                if (javaProject != null) {
                    try {
                        Set projects = AbstractDiscoverJavaModelFromProject.computeRequiredProjects((IJavaProject)javaProject);
                        return projects.toArray();
                    }
                    catch (JavaModelException e) {
                        MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
                    }
                }
            } else {
                throw new IllegalArgumentException("wrong input");
            }
            return new Object[0];
        }

        public boolean hasChildren(Object element) {
            return element instanceof IJavaProject;
        }

        public Object[] getChildren(Object element) {
            if (element instanceof IJavaProject) {
                IJavaProject javaProject = (IJavaProject)element;
                try {
                    Set requiredLibraries = AbstractDiscoverJavaModelFromProject.computeRequiredLibraries((IJavaProject)javaProject);
                    return requiredLibraries.toArray();
                }
                catch (JavaModelException e) {
                    MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
                }
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof IPackageFragmentRoot) {
                return ((IPackageFragmentRoot)element).getJavaProject();
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    protected class DependenciesTreeInput {
        private final IJavaProject javaProject;

        public DependenciesTreeInput(IJavaProject javaProject) {
            this.javaProject = javaProject;
        }

        public IJavaProject getJavaProject() {
            return this.javaProject;
        }
    }

    protected class JDTDelegateColumnLabelProvider
    extends ColumnLabelProvider {
        private final JavaElementLabelProvider delegate = new JavaElementLabelProvider();
        private boolean displayShortName = true;

        public JDTDelegateColumnLabelProvider(boolean displayShortName) {
            this.displayShortName = displayShortName;
        }

        public void addListener(ILabelProviderListener listener) {
            this.delegate.addListener(listener);
        }

        public void dispose() {
            this.delegate.dispose();
        }

        public boolean equals(Object obj) {
            return this.delegate.equals(obj);
        }

        public Image getImage(Object element) {
            if (this.displayShortName) {
                return this.delegate.getImage(element);
            }
            return null;
        }

        public String getText(Object element) {
            String qualifiedName = this.delegate.getText(element);
            int lastSegmentindex = qualifiedName.lastIndexOf(File.separator);
            String text = null;
            text = this.displayShortName ? qualifiedName.substring(lastSegmentindex + 1) : (lastSegmentindex > -1 ? qualifiedName.substring(0, lastSegmentindex) : "");
            return text;
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public boolean isLabelProperty(Object element, String property) {
            return this.delegate.isLabelProperty(element, property);
        }

        public void removeListener(ILabelProviderListener listener) {
            this.delegate.removeListener(listener);
        }

        public String toString() {
            return this.delegate.toString();
        }
    }

    protected class UseSourceColumnLabelProvider
    extends ColumnLabelProvider {
        protected UseSourceColumnLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IPackageFragmentRoot && JavaElementsToAnalyzeDialog.this.getElementsToAnalyze().getElementsToDiscover().contains(element)) {
                IPackageFragmentRoot packageFragmentRoot = (IPackageFragmentRoot)element;
                if (!JavaElementsToAnalyzeDialog.hasSourceAvailable(packageFragmentRoot)) {
                    return Messages.JavaElementsToAnalyzeDialog_sourceNotAvailable;
                }
                Map discoveryOptions = JavaElementsToAnalyzeDialog.this.getElementsToAnalyze().getDiscoveryOptions((Object)packageFragmentRoot);
                if (discoveryOptions != null && Boolean.TRUE.equals(discoveryOptions.get(JavaElementsToAnalyzeDialog.USE_SOURCES_OPTIONS))) {
                    return Messages.JavaElementsToAnalyzeDialog_useSource;
                }
                return Messages.JavaElementsToAnalyzeDialog_dontUseSource;
            }
            return "";
        }

        public Color getForeground(Object element) {
            if (!JavaElementsToAnalyzeDialog.hasSourceAvailable(element)) {
                return Display.getDefault().getSystemColor(16);
            }
            return null;
        }
    }

    protected class UseSourceEditingSupport
    extends EditingSupport {
        public UseSourceEditingSupport(ColumnViewer columnViewer) {
            super(columnViewer);
        }

        protected CellEditor getCellEditor(Object element) {
            return new CheckboxCellEditor();
        }

        protected boolean canEdit(Object element) {
            return JavaElementsToAnalyzeDialog.hasSourceAvailable(element);
        }

        protected Object getValue(Object element) {
            Object option;
            Map discoveryOptions = JavaElementsToAnalyzeDialog.this.getElementsToAnalyze().getDiscoveryOptions(element);
            if (discoveryOptions != null && (option = discoveryOptions.get(JavaElementsToAnalyzeDialog.USE_SOURCES_OPTIONS)) instanceof Boolean) {
                return option;
            }
            return Boolean.FALSE;
        }

        protected void setValue(Object element, Object value) {
            Map discoveryOptions = JavaElementsToAnalyzeDialog.this.getElementsToAnalyze().getDiscoveryOptions(element);
            if (discoveryOptions != null) {
                discoveryOptions.put(JavaElementsToAnalyzeDialog.USE_SOURCES_OPTIONS, value);
            }
            JavaElementsToAnalyzeDialog.this.getDependenciesTree().refresh();
        }
    }
}

