/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.browser.editors.table;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.CellNavigationStrategy;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.FocusCellOwnerDrawHighlighter;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerFocusCellManager;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.modisco.infra.browser.Messages;
import org.eclipse.modisco.infra.browser.MoDiscoBrowserPlugin;
import org.eclipse.modisco.infra.browser.core.ModelElementItemEx;
import org.eclipse.modisco.infra.browser.custom.MetamodelView;
import org.eclipse.modisco.infra.browser.custom.core.CustomizationsCatalog;
import org.eclipse.modisco.infra.browser.editors.BrowserConfiguration;
import org.eclipse.modisco.infra.browser.editors.EcoreBrowser;
import org.eclipse.modisco.infra.browser.editors.table.ColumnDescription;
import org.eclipse.modisco.infra.browser.editors.table.ITableEditor;
import org.eclipse.modisco.infra.browser.editors.table.TableEditorContentProvider;
import org.eclipse.modisco.infra.browser.editors.table.TableEditorFactory;
import org.eclipse.modisco.infra.browser.editors.table.TableEditorInput;
import org.eclipse.modisco.infra.browser.editors.table.TableEditorLabelProvider;
import org.eclipse.modisco.infra.browser.editors.table.TableEditorToolBar;
import org.eclipse.modisco.infra.browser.editors.table.TableElement;
import org.eclipse.modisco.infra.browser.editors.table.TableElementWithContext;
import org.eclipse.modisco.infra.browser.editors.table.TableSorter;
import org.eclipse.modisco.infra.browser.uicore.internal.customization.CustomizationEngine;
import org.eclipse.modisco.infra.browser.uicore.internal.model.LinkItem;
import org.eclipse.modisco.infra.browser.uicore.internal.model.ModelElementItem;
import org.eclipse.modisco.infra.browser.uicore.internal.util.ImageProvider;
import org.eclipse.modisco.infra.common.core.internal.utils.StringUtils;
import org.eclipse.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.modisco.infra.common.ui.internal.editorInputs.ResourceEditorInput;
import org.eclipse.modisco.infra.facet.FacetStructuralFeature;
import org.eclipse.modisco.infra.facet.core.FacetContext;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;

public class TableEditor
extends EditorPart
implements ISelectionProvider,
IMenuListener,
ITableEditor {
    private static final int LABEL_COLUMN_WIDTH = 125;
    private static final int DEFAULT_COLUMN_WIDTH = 100;
    private static final int MAX_INITIAL_COLUMN_WIDTH = 300;
    public static final String EDITOR_ID = "org.eclipse.modisco.infra.browser.table.editorID";
    private static final int USE_VIRTUAL_THRESHOLD = 1000;
    private static final String KEY_EMPTY_HIDDEN = "emptyHidden";
    private static final String KEY_NOT_COMMON_HIDDEN = "notCommonHidden";
    private TableViewer tableViewer;
    private TableEditorInput tableEditorInput;
    private TableEditorLabelProvider tableEditorLabelProvider;
    private List<ColumnDescription> columnsConfiguration;
    private TableEditorToolBar toolBar;
    private TableEditorContentProvider tableEditorContentProvider;
    private TableViewerFocusCellManager tableViewerFocusCellManager;
    private final Collection<ISelectionChangedListener> selectionChangedListeners = new ArrayList<ISelectionChangedListener>();

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof TableEditorInput)) {
            throw new PartInitException("Input should be of type TableEditorInput");
        }
        this.tableEditorInput = (TableEditorInput)input;
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(this.tableEditorInput);
        this.setPartName(Messages.TableEditor_tableViewer);
    }

    protected TableEditorInput getTableEditorInput() {
        return this.tableEditorInput;
    }

    public void createPartControl(Composite parent) {
        Composite editorComposite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 2;
        editorComposite.setLayout((Layout)gridLayout);
        this.createToolBar(editorComposite);
        this.toolBar.setLabelText(this.tableEditorInput.getDescription());
        GridData tableGridData = new GridData();
        tableGridData.grabExcessHorizontalSpace = true;
        tableGridData.grabExcessVerticalSpace = true;
        tableGridData.horizontalAlignment = 4;
        tableGridData.verticalAlignment = 4;
        int virtualFlag = 0;
        if (this.tableEditorInput.getElements().size() > 1000) {
            virtualFlag = 0x10000000;
        }
        this.loadDefaultCustomizations();
        this.tableViewer = new TableViewer(editorComposite, 0x10304 | virtualFlag);
        FocusCellOwnerDrawHighlighter focusCellOwnerDrawHighlighter = new FocusCellOwnerDrawHighlighter((ColumnViewer)this.tableViewer);
        this.tableViewerFocusCellManager = new TableViewerFocusCellManager(this.tableViewer, (FocusCellHighlighter)focusCellOwnerDrawHighlighter);
        this.tableViewer.getTable().setLayoutData((Object)tableGridData);
        this.tableViewer.getTable().setFont(this.tableEditorInput.getBrowserConfiguration().getAppearanceConfiguration().getCustomFont());
        this.tableViewer.getTable().setLinesVisible(true);
        this.tableViewer.getTable().setHeaderVisible(true);
        this.tableEditorContentProvider = new TableEditorContentProvider();
        this.columnsConfiguration = this.createColumnConfiguration();
        this.tableEditorLabelProvider = new TableEditorLabelProvider(this.columnsConfiguration, this.tableEditorInput.getBrowserConfiguration());
        this.createColumns(this.columnsConfiguration);
        this.tableViewer.setContentProvider((IContentProvider)this.tableEditorContentProvider);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)this.tableEditorLabelProvider);
        this.tableViewer.setInput((Object)this.tableEditorInput);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TableEditor.this.tableSelectionChanged();
            }
        });
        this.tableViewer.getTable().addKeyListener(new KeyListener(){
            private final CellNavigationStrategy cellNavigationStrategy = new CellNavigationStrategy();

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                Event event = new Event();
                event.keyCode = e.keyCode;
                if (this.cellNavigationStrategy.isNavigationEvent(null, event)) {
                    TableEditor.this.tableSelectionChanged();
                }
            }
        });
        this.createContextMenuFor((StructuredViewer)this.tableViewer);
        this.registerOpenListeners();
        this.registerCloseWhenMainEditorClosed();
        this.getSite().setSelectionProvider((ISelectionProvider)this);
        this.packColumns();
    }

    protected void tableSelectionChanged() {
        for (ISelectionChangedListener listener : new ArrayList<ISelectionChangedListener>(this.selectionChangedListeners)) {
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
        }
    }

    private void createToolBar(Composite parent) {
        Composite toolBarComposite = new Composite(parent, 0);
        this.toolBar = new TableEditorToolBar(toolBarComposite, this);
    }

    private void registerCloseWhenMainEditorClosed() {
        EcoreBrowser editor = this.tableEditorInput.getBrowserConfiguration().getEditor();
        if (editor == null) {
            return;
        }
        editor.getEditorSite().getPage().addPartListener(new IPartListener(){

            public void partClosed(IWorkbenchPart part) {
                EcoreBrowser browser = TableEditor.this.tableEditorInput.getBrowserConfiguration().getEditor();
                if (browser != null && part == browser) {
                    TableEditor.this.getSite().getPage().closeEditor((IEditorPart)TableEditor.this, false);
                    part.getSite().getPage().removePartListener((IPartListener)this);
                }
            }

            public void partOpened(IWorkbenchPart part) {
            }

            public void partDeactivated(IWorkbenchPart part) {
            }

            public void partBroughtToTop(IWorkbenchPart part) {
            }

            public void partActivated(IWorkbenchPart part) {
            }
        });
    }

    private void registerOpenListeners() {
        this.tableViewer.getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                ViewerCell cell = TableEditor.this.tableViewer.getCell(new Point(e.x, e.y));
                int column = cell == null ? 0 : cell.getColumnIndex();
                TableEditor.this.openSelectionInModelBrowser(column);
            }
        });
        this.tableViewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13) {
                    TableEditor.this.openSelectionInModelBrowser(0);
                }
            }
        });
    }

    private void packColumns() {
        TableColumn[] tableColumns;
        TableColumn[] tableColumnArray = tableColumns = this.tableViewer.getTable().getColumns();
        int n = tableColumns.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn tableColumn = tableColumnArray[n2];
            tableColumn.pack();
            if (tableColumn.getWidth() > 300) {
                tableColumn.setWidth(300);
            }
            ++n2;
        }
    }

    protected List<ColumnDescription> createColumnConfiguration() {
        TableEditorInput.ElementsDescription elementsDescription = this.tableEditorInput.getElementsDescription();
        ArrayList<ColumnDescription> columns = new ArrayList<ColumnDescription>();
        if (this.showLabelColumn()) {
            columns.add(new ColumnDescription(ColumnDescription.Type.DEFAULT_LABEL));
        }
        if (this.showMetaclassColumn()) {
            columns.add(new ColumnDescription(ColumnDescription.Type.METACLASS_NAME));
        }
        if (elementsDescription.containsEObjects() && this.showEContainerColumn()) {
            columns.add(new ColumnDescription(ColumnDescription.Type.ECONTAINER));
        }
        if (elementsDescription.containsContexts()) {
            columns.add(new ColumnDescription(ColumnDescription.Type.CONTEXT));
        }
        for (EStructuralFeature feature : this.tableEditorInput.getFeatures()) {
            columns.add(new ColumnDescription(feature));
        }
        return columns;
    }

    protected boolean showLabelColumn() {
        return true;
    }

    protected boolean showMetaclassColumn() {
        return true;
    }

    protected boolean showEContainerColumn() {
        return true;
    }

    private boolean isEmpty(EReference reference) {
        Object[] elements = this.tableEditorContentProvider.getElements(this.tableEditorInput);
        FacetContext facetContext = this.tableEditorInput.getBrowserConfiguration().getAppearanceConfiguration().getFacetContext();
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            EObject eObject;
            Object e = objectArray[n2];
            TableElement tableElement = (TableElement)e;
            Object element = tableElement.getElement();
            if (element instanceof EObject && TableEditor.hasStructuralFeature(eObject = (EObject)element, (EStructuralFeature)reference, facetContext)) {
                EList list;
                Object value = TableEditor.getStructuralFeatureValue(eObject, (EStructuralFeature)reference, this.getFacetContext());
                if (reference.isMany() ? !(list = (EList)value).isEmpty() : value != null) {
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    private boolean isEmpty(EAttribute attribute) {
        Object[] elements = this.tableEditorContentProvider.getElements(this.tableEditorInput);
        FacetContext facetContext = this.tableEditorInput.getBrowserConfiguration().getAppearanceConfiguration().getFacetContext();
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            EObject eObject;
            Object e = objectArray[n2];
            TableElement tableElement = (TableElement)e;
            Object element = tableElement.getElement();
            if (element instanceof EObject && TableEditor.hasStructuralFeature(eObject = (EObject)element, (EStructuralFeature)attribute, facetContext)) {
                EList list;
                Object value = TableEditor.getStructuralFeatureValue(eObject, (EStructuralFeature)attribute, this.getFacetContext());
                if (attribute.isMany() ? !(list = (EList)value).isEmpty() : value != null) {
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    private void createColumns(List<ColumnDescription> columns) {
        int columnIndex = 0;
        for (ColumnDescription columnDescription : columns) {
            TableViewerColumn column = new TableViewerColumn(this.tableViewer, 0);
            TableColumn tableColumn = column.getColumn();
            tableColumn.setWidth(100);
            tableColumn.setResizable(true);
            tableColumn.setMoveable(true);
            column.getColumn().setData((Object)columnDescription);
            switch (columnDescription.getType()) {
                case DEFAULT_LABEL: {
                    tableColumn.setText(Messages.TableEditor_columnName_Label);
                    tableColumn.setWidth(125);
                    break;
                }
                case METACLASS_NAME: {
                    tableColumn.setText(Messages.TableEditor_columnName_Metaclass);
                    break;
                }
                case CONTEXT: {
                    tableColumn.setText(Messages.TableEditor_ColumnName_queryContext);
                    break;
                }
                case ECONTAINER: {
                    tableColumn.setText("/eContainer");
                    break;
                }
                case ATTRIBUTE: {
                    EAttribute attribute = columnDescription.getAttribute();
                    if (attribute.isDerived()) {
                        tableColumn.setText("/" + attribute.getName());
                    } else {
                        tableColumn.setText(attribute.getName());
                    }
                    tableColumn.setImage(ImageProvider.getInstance().getAttributeIcon());
                    break;
                }
                case REFERENCE: {
                    EReference reference = columnDescription.getReference();
                    String multiplicity = this.showMultiplicityInColumnNames() ? LinkItem.getMultiplicity((EReference)reference) : "";
                    if (reference.isDerived()) {
                        tableColumn.setText("/" + reference.getName() + multiplicity);
                    } else {
                        tableColumn.setText(reference.getName() + multiplicity);
                    }
                    tableColumn.setImage(LinkItem.getImageFor((EReference)reference));
                    break;
                }
                default: {
                    MoDiscoBrowserPlugin.logWarning("Unhandled column description type");
                }
            }
            final int fColumnIndex = columnIndex++;
            TableSorter tableSorter = new TableSorter(this.tableViewer, column){

                @Override
                protected int doCompare(Viewer viewer, Object e1, Object e2) {
                    String label1 = TableEditor.this.tableEditorLabelProvider.getColumnText(e1, fColumnIndex);
                    String label2 = TableEditor.this.tableEditorLabelProvider.getColumnText(e2, fColumnIndex);
                    return label1.compareToIgnoreCase(label2);
                }
            };
        }
    }

    protected boolean showMultiplicityInColumnNames() {
        return true;
    }

    public void setFocus() {
        if (this.tableViewer != null) {
            this.tableViewer.getTable().setFocus();
        }
    }

    public static boolean canBeOpenedOnSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            if (structuredSelection.size() == 1 && structuredSelection.getFirstElement() instanceof LinkItem) {
                LinkItem linkItem = (LinkItem)structuredSelection.getFirstElement();
                return linkItem.getChildren().size() > 0;
            }
            boolean empty = true;
            for (Object selectedElement : structuredSelection) {
                if (selectedElement instanceof ModelElementItem) {
                    empty = false;
                    continue;
                }
                return false;
            }
            return !empty;
        }
        return false;
    }

    private void openSelectionInModelBrowser(int column) {
        EObject element = this.findElementToOpenInModelBrowser(column);
        if (element != null) {
            this.openElementInModelBrowser(element);
        }
    }

    private TableElement getSelectedElement() {
        ISelection selection = this.tableViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            return (TableElement)structuredSelection.getFirstElement();
        }
        return null;
    }

    public EObject findElementToOpenInModelBrowser(int column) {
        return TableEditor.findElementToOpenInModelBrowser(column, this.getFacetContext(), this.columnsConfiguration, this.getSelectedElement());
    }

    public static EObject findElementToOpenInModelBrowser(int column, FacetContext facetContext, List<ColumnDescription> columnDescriptions, TableElement mainElement) {
        if (mainElement == null) {
            return null;
        }
        EObject mainModelElement = mainElement.getElement() instanceof EObject ? (EObject)mainElement.getElement() : null;
        EObject targetObject = null;
        ColumnDescription columnDescription = columnDescriptions.get(column);
        switch (columnDescription.getType()) {
            case ATTRIBUTE: {
                Object value;
                if (mainModelElement == null || !TableEditor.hasStructuralFeature(mainModelElement, (EStructuralFeature)columnDescription.getAttribute(), facetContext) || !((value = TableEditor.getStructuralFeatureValue(mainModelElement, (EStructuralFeature)columnDescription.getAttribute(), facetContext)) instanceof EObject)) break;
                targetObject = (EObject)value;
                break;
            }
            case REFERENCE: {
                if (mainModelElement == null || !TableEditor.hasStructuralFeature(mainModelElement, (EStructuralFeature)columnDescription.getReference(), facetContext)) break;
                Object value = TableEditor.getStructuralFeatureValue(mainModelElement, (EStructuralFeature)columnDescription.getReference(), facetContext);
                if (columnDescription.getReference().isMany()) {
                    EList list = (EList)value;
                    if (list.size() != 1) break;
                    targetObject = (EObject)list.get(0);
                    break;
                }
                targetObject = (EObject)value;
                break;
            }
            case ECONTAINER: {
                if (mainModelElement == null) break;
                targetObject = mainModelElement.eContainer();
                break;
            }
            case CONTEXT: {
                if (!(mainElement instanceof TableElementWithContext)) break;
                TableElementWithContext tableElementWithContext = (TableElementWithContext)mainElement;
                targetObject = tableElementWithContext.getContext();
                break;
            }
            case DEFAULT_LABEL: {
                targetObject = mainModelElement;
                break;
            }
        }
        if (targetObject != null) {
            return targetObject;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void openElementInModelBrowser(EObject element) {
        EcoreBrowser editor = this.tableEditorInput.getBrowserConfiguration().getEditor();
        if (editor != null) {
            editor.getSite().getPage().activate((IWorkbenchPart)editor);
            editor.browseTo(element);
            return;
        }
        Resource resource = element.eResource();
        if (resource != null) {
            IEditorReference[] editorReferences;
            ResourceSet resourceSet = resource.getResourceSet();
            IEditorReference[] iEditorReferenceArray = editorReferences = this.getSite().getPage().getEditorReferences();
            int n = editorReferences.length;
            int n2 = 0;
            while (n2 < n) {
                EcoreBrowser browser;
                IEditorReference editorReference = iEditorReferenceArray[n2];
                IEditorPart anEditor = editorReference.getEditor(false);
                if (anEditor instanceof EcoreBrowser && (browser = (EcoreBrowser)anEditor).getResourceSet() == resourceSet) {
                    browser.browseTo(element);
                    browser.getSite().getPage().activate((IWorkbenchPart)browser);
                    return;
                }
                ++n2;
            }
        }
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            URIEditorInput editorInput;
            URI elementURI = EcoreUtil.getURI((EObject)element);
            URI resourceURI = elementURI.trimFragment();
            if (resourceURI.isPlatformResource()) {
                String platformString = resourceURI.toPlatformString(true);
                IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(platformString);
                if (!(res instanceof IFile)) {
                    MoDiscoBrowserPlugin.logError("Cannot open model: " + String.valueOf(resourceURI));
                    return;
                }
                IFile file = (IFile)res;
                editorInput = new FileEditorInput(file);
            } else if (EPackage.Registry.INSTANCE.containsKey((Object)resourceURI.toString())) {
                editorInput = new URIEditorInput(resourceURI);
            } else {
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                Resource tempResource = resourceSet.createResource(URI.createURI((String)"http://modisco/browser/table/temp"));
                tempResource.getContents().add((Object)element);
                editorInput = new ResourceEditorInput(tempResource);
            }
            IEditorPart newEditor = IDE.openEditor((IWorkbenchPage)activePage, (IEditorInput)editorInput, (String)"org.eclipse.modisco.infra.browser.editorID", (boolean)true);
            if (!(newEditor instanceof EcoreBrowser)) return;
            EcoreBrowser browser = (EcoreBrowser)newEditor;
            String uriFragment = element.eResource().getURIFragment(element);
            browser.browseToByURI(uriFragment);
            return;
        }
        catch (PartInitException e) {
            MoDiscoBrowserPlugin.logException(e);
        }
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    @Override
    public void setHideEmptyColumns(boolean hideEmptyColumns) {
        try {
            this.tableViewer.getControl().setRedraw(false);
            for (ColumnDescription columnDescription : this.columnsConfiguration) {
                boolean bEmpty = false;
                if (columnDescription.getType() == ColumnDescription.Type.ATTRIBUTE) {
                    bEmpty = this.isEmpty(columnDescription.getAttribute());
                } else if (columnDescription.getType() == ColumnDescription.Type.REFERENCE) {
                    bEmpty = this.isEmpty(columnDescription.getReference());
                }
                TableColumn column = this.findColumn(columnDescription);
                if (hideEmptyColumns && bEmpty) {
                    if (column == null) continue;
                    column.setData(KEY_EMPTY_HIDDEN, (Object)Boolean.TRUE);
                    this.hideColumn(column);
                    continue;
                }
                if (hideEmptyColumns || Boolean.TRUE != column.getData(KEY_EMPTY_HIDDEN)) continue;
                column.setData(KEY_EMPTY_HIDDEN, (Object)Boolean.FALSE);
                this.showEmptyColumn(column);
            }
        }
        finally {
            this.tableViewer.getControl().setRedraw(true);
        }
    }

    @Override
    public void setSortColumnsByType(boolean bSort) {
        try {
            try {
                this.tableViewer.getControl().setRedraw(false);
                TableColumn[] columns = this.tableViewer.getTable().getColumns();
                int[] order = new int[columns.length];
                if (bSort) {
                    ColumnDescription columnDescription;
                    int i = 0;
                    int j = 0;
                    while (j < this.columnsConfiguration.size()) {
                        columnDescription = this.columnsConfiguration.get(j);
                        if (columnDescription.getType() == ColumnDescription.Type.CONTEXT || columnDescription.getType() == ColumnDescription.Type.DEFAULT_LABEL || columnDescription.getType() == ColumnDescription.Type.ECONTAINER || columnDescription.getType() == ColumnDescription.Type.METACLASS_NAME) {
                            order[i++] = j;
                        }
                        ++j;
                    }
                    j = 0;
                    while (j < this.columnsConfiguration.size()) {
                        columnDescription = this.columnsConfiguration.get(j);
                        if (columnDescription.getType() == ColumnDescription.Type.ATTRIBUTE) {
                            order[i++] = j;
                        }
                        ++j;
                    }
                    final class Link {
                        private final int index;
                        private final EReference reference;

                        private Link(int index, EReference reference) {
                            this.index = index;
                            this.reference = reference;
                        }
                    }
                    ArrayList<Link> links = new ArrayList<Link>();
                    int j2 = 0;
                    while (j2 < this.columnsConfiguration.size()) {
                        ColumnDescription columnDescription2 = this.columnsConfiguration.get(j2);
                        if (columnDescription2.getType() == ColumnDescription.Type.REFERENCE) {
                            links.add(new Link(j2, columnDescription2.getReference()));
                        }
                        ++j2;
                    }
                    Collections.sort(links, new Comparator<Link>(){

                        @Override
                        public int compare(Link o1, Link o2) {
                            int r1 = ModelElementItem.getReferenceRank((EReference)o1.reference);
                            int r2 = ModelElementItem.getReferenceRank((EReference)o2.reference);
                            return r1 - r2;
                        }
                    });
                    for (Link link : links) {
                        order[i++] = link.index;
                    }
                } else {
                    int i = 0;
                    while (i < columns.length) {
                        order[i] = i;
                        ++i;
                    }
                }
                this.tableViewer.getTable().setColumnOrder(order);
            }
            catch (Exception e) {
                MoDiscoLogger.logError((Throwable)e, (String)"Error sorting columns by type", (Plugin)MoDiscoBrowserPlugin.getPlugin());
                this.tableViewer.getControl().setRedraw(true);
            }
        }
        finally {
            this.tableViewer.getControl().setRedraw(true);
        }
    }

    @Override
    public void setOnlyShowCommonColumns(boolean onlyShowCommonColumns) {
        try {
            this.tableViewer.getControl().setRedraw(false);
            EClass[] metaclasses = this.tableEditorInput.getMetaclasses();
            for (ColumnDescription columnDescription : this.columnsConfiguration) {
                boolean common = true;
                if (columnDescription.getType() == ColumnDescription.Type.ATTRIBUTE) {
                    common = this.isCommon((EStructuralFeature)columnDescription.getAttribute(), metaclasses);
                } else if (columnDescription.getType() == ColumnDescription.Type.REFERENCE) {
                    common = this.isCommon((EStructuralFeature)columnDescription.getReference(), metaclasses);
                }
                TableColumn column = this.findColumn(columnDescription);
                if (onlyShowCommonColumns && !common) {
                    if (column == null) continue;
                    column.setData(KEY_NOT_COMMON_HIDDEN, (Object)Boolean.TRUE);
                    this.hideColumn(column);
                    continue;
                }
                if (onlyShowCommonColumns || Boolean.TRUE != column.getData(KEY_NOT_COMMON_HIDDEN)) continue;
                column.setData(KEY_NOT_COMMON_HIDDEN, (Object)Boolean.FALSE);
                this.showEmptyColumn(column);
            }
        }
        finally {
            this.tableViewer.getControl().setRedraw(true);
        }
    }

    private void hideColumn(TableColumn column) {
        column.setWidth(0);
        column.setResizable(false);
    }

    private void showEmptyColumn(TableColumn column) {
        if (Boolean.TRUE != column.getData(KEY_EMPTY_HIDDEN) && Boolean.TRUE != column.getData(KEY_NOT_COMMON_HIDDEN)) {
            column.pack();
            column.setResizable(true);
        }
    }

    private boolean isCommon(EStructuralFeature feature, EClass[] metaclasses) {
        EClass[] eClassArray = metaclasses;
        int n = metaclasses.length;
        int n2 = 0;
        while (n2 < n) {
            EClass metaclass = eClassArray[n2];
            if (!metaclass.getEAllStructuralFeatures().contains((Object)feature)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private TableColumn findColumn(ColumnDescription columnDescription) {
        TableColumn[] columns;
        TableColumn[] tableColumnArray = columns = this.tableViewer.getTable().getColumns();
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn tableColumn = tableColumnArray[n2];
            if (tableColumn.getData() == columnDescription) {
                return tableColumn;
            }
            ++n2;
        }
        return null;
    }

    public static String getEditorDescriptionFor(EObject parent, EReference reference, BrowserConfiguration browserConfiguration) {
        String parentLabel = new ModelElementItemEx(parent, null, browserConfiguration).getText();
        return NLS.bind((String)Messages.TableEditor_contentsDescription, (Object)parentLabel, (Object)reference.getName());
    }

    private static Object getStructuralFeatureValue(EObject eObject, EStructuralFeature structuralFeature, FacetContext facetContext) {
        if (structuralFeature instanceof FacetStructuralFeature) {
            try {
                return facetContext.get(eObject, structuralFeature);
            }
            catch (Exception e) {
                MoDiscoBrowserPlugin.logException(e);
                return null;
            }
        }
        return eObject.eGet(structuralFeature);
    }

    private static boolean hasStructuralFeature(EObject eObject, EStructuralFeature structuralFeature, FacetContext facetContext) {
        EClass eClass = eObject.eClass();
        if (facetContext.getFacetFeatures(eObject).contains(structuralFeature)) {
            return true;
        }
        return eClass.getEAllStructuralFeatures().contains((Object)structuralFeature);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (!this.selectionChangedListeners.contains(listener)) {
            this.selectionChangedListeners.add(listener);
        }
    }

    public ISelection getSelection() {
        ViewerCell focusCell = this.tableViewerFocusCellManager.getFocusCell();
        if (focusCell == null) {
            return new StructuredSelection();
        }
        int columnIndex = focusCell.getColumnIndex();
        EObject eObject = this.findElementToOpenInModelBrowser(columnIndex);
        if (eObject == null) {
            return new StructuredSelection();
        }
        return new StructuredSelection((Object)eObject);
    }

    private FacetContext getFacetContext() {
        return this.tableEditorInput.getBrowserConfiguration().getAppearanceConfiguration().getFacetContext();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        this.tableViewer.setSelection(selection);
    }

    protected void createContextMenuFor(StructuredViewer viewer) {
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new GroupMarker("additions"));
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener((IMenuListener)this);
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)this);
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        EObject mainModelElement;
        int columnIndex = this.tableViewerFocusCellManager.getFocusCell().getColumnIndex();
        ColumnDescription columnDescription = this.columnsConfiguration.get(columnIndex);
        EObject element = null;
        TableElement mainElement = this.getSelectedElement();
        if (columnDescription.getType() == ColumnDescription.Type.CONTEXT) {
            mainModelElement = ((TableElementWithContext)mainElement).getContext();
        } else if (mainElement != null && mainElement.getElement() instanceof EObject) {
            mainModelElement = (EObject)mainElement.getElement();
        } else {
            return;
        }
        if (columnDescription.getType() == ColumnDescription.Type.REFERENCE) {
            boolean oneElement = true;
            if (columnDescription.getReference().isMany()) {
                EList list = (EList)TableEditor.getStructuralFeatureValue(mainModelElement, (EStructuralFeature)columnDescription.getReference(), this.getFacetContext());
                boolean bl = oneElement = list.size() == 1;
            }
            if (oneElement) {
                element = this.findElementToOpenInModelBrowser(columnIndex);
                if (element != null) {
                    this.createBrowseMenuItemFor(element, menuManager);
                }
            } else {
                this.createViewInTableMenuItemFor(mainModelElement, columnDescription.getReference(), menuManager);
            }
        } else if (columnDescription.getType() == ColumnDescription.Type.ECONTAINER && (element = mainModelElement.eContainer()) != null) {
            this.createBrowseMenuItemFor(element, menuManager);
        }
        if (element != mainModelElement) {
            this.createBrowseMenuItemFor(mainModelElement, menuManager);
        }
    }

    private void createBrowseMenuItemFor(final EObject element, IMenuManager menuManager) {
        if (element == null) {
            return;
        }
        String text = this.tableEditorLabelProvider.getTextFor(element);
        menuManager.add((IAction)new Action(NLS.bind((String)Messages.TableEditor_browse, (Object)StringUtils.truncateBeforeNewline((String)text))){

            public void run() {
                TableEditor.this.openElementInModelBrowser(element);
            }
        });
    }

    private void createViewInTableMenuItemFor(final EObject parentElement, final EReference reference, IMenuManager menuManager) {
        final EList elements = (EList)TableEditor.getStructuralFeatureValue(parentElement, (EStructuralFeature)reference, this.getFacetContext());
        menuManager.add((IAction)new Action(Messages.openTableEditorOnSelection){

            public boolean isEnabled() {
                return elements.size() > 0;
            }

            public void run() {
                BrowserConfiguration browserConfiguration = TableEditor.this.tableEditorInput.getBrowserConfiguration();
                String description = TableEditor.getEditorDescriptionFor(parentElement, reference, browserConfiguration);
                TableEditor.this.getFactory().openOn(TableEditor.this.tableEditorInput.getBrowserConfiguration(), (List<? extends Object>)elements, description);
            }
        });
    }

    protected TableEditorFactory getFactory() {
        return TableEditorFactory.getInstance();
    }

    protected CustomizationEngine getCustomizationEngine() {
        return this.tableEditorInput.getBrowserConfiguration().getAppearanceConfiguration().getCustomizationEngine();
    }

    public void loadCustomizations(List<MetamodelView> customizationsToLoad) {
        CustomizationEngine customizationEngine = this.getCustomizationEngine();
        customizationEngine.clear();
        for (MetamodelView customizationToLoad : customizationsToLoad) {
            customizationEngine.registerCustomization(customizationToLoad);
        }
        customizationEngine.loadCustomizations();
    }

    private void loadDefaultCustomizations() {
        if (this.getCustomizationEngine().getRegisteredCustomizations().isEmpty()) {
            this.loadCustomizations(CustomizationsCatalog.getInstance().getRegistryDefaultCustomizations());
        }
    }
}

