/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data;

import java.util.HashMap;
import prefuse.data.Table;
import prefuse.util.PrefuseLib;

public class Schema
implements Cloneable {
    private String[] m_names;
    private Class[] m_types;
    private Object[] m_dflts;
    private HashMap m_lookup;
    private int m_size;
    private boolean m_locked;

    public Schema() {
        this(10);
    }

    public Schema(int ncols) {
        this.m_names = new String[ncols];
        this.m_types = new Class[ncols];
        this.m_dflts = new Object[ncols];
        this.m_size = 0;
        this.m_locked = false;
    }

    public Schema(String[] names, Class[] types) {
        this(names.length);
        if (names.length != types.length) {
            throw new IllegalArgumentException("Input arrays should be the same length");
        }
        int i = 0;
        while (i < names.length) {
            this.addColumn(names[i], types[i], null);
            ++i;
        }
    }

    public Schema(String[] names, Class[] types, Object[] defaults) {
        this(names.length);
        if (names.length != types.length || types.length != defaults.length) {
            throw new IllegalArgumentException("Input arrays should be the same length");
        }
        int i = 0;
        while (i < names.length) {
            this.addColumn(names[i], types[i], defaults[i]);
            ++i;
        }
    }

    public Object clone() {
        Schema s = new Schema(this.m_size);
        int i = 0;
        while (i < this.m_size) {
            s.addColumn(this.m_names[i], this.m_types[i], this.m_dflts[i]);
            ++i;
        }
        return s;
    }

    protected void initLookup() {
        this.m_lookup = new HashMap();
        int i = 0;
        while (i < this.m_names.length) {
            this.m_lookup.put(this.m_names[i], new Integer(i));
            ++i;
        }
    }

    public Schema lockSchema() {
        this.m_locked = true;
        return this;
    }

    public boolean isLocked() {
        return this.m_locked;
    }

    public void addColumn(String name, Class type) {
        this.addColumn(name, type, null);
    }

    public void addColumn(String name, Class type, Object defaultValue) {
        if (this.m_locked) {
            throw new IllegalStateException("Can not add column to a locked Schema.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Null column names are not allowed.");
        }
        if (type == null) {
            throw new IllegalArgumentException("Null column types are not allowed.");
        }
        int i = 0;
        while (i < this.m_size) {
            if (this.m_names[i].equals(name)) {
                throw new IllegalArgumentException("Duplicate column names are not allowed: " + this.m_names[i]);
            }
            ++i;
        }
        if (this.m_names.length == this.m_size) {
            int capacity = 3 * this.m_names.length / 2 + 1;
            String[] names = new String[capacity];
            Class[] types = new Class[capacity];
            Object[] dflts = new Object[capacity];
            System.arraycopy(this.m_names, 0, names, 0, this.m_size);
            System.arraycopy(this.m_types, 0, types, 0, this.m_size);
            System.arraycopy(this.m_dflts, 0, dflts, 0, this.m_size);
            this.m_names = names;
            this.m_types = types;
            this.m_dflts = dflts;
        }
        this.m_names[this.m_size] = name;
        this.m_types[this.m_size] = type;
        this.m_dflts[this.m_size] = defaultValue;
        if (this.m_lookup != null) {
            this.m_lookup.put(name, new Integer(this.m_size));
        }
        ++this.m_size;
    }

    public void addInterpolatedColumn(String name, Class type, Object dflt) {
        this.addColumn(name, type, dflt);
        this.addColumn(PrefuseLib.getStartField(name), type, dflt);
        this.addColumn(PrefuseLib.getEndField(name), type, dflt);
    }

    public void addInterpolatedColumn(String name, Class type) {
        this.addInterpolatedColumn(name, type, null);
    }

    public int getColumnCount() {
        return this.m_size;
    }

    public String getColumnName(int col) {
        return this.m_names[col];
    }

    public int getColumnIndex(String field) {
        Integer idx;
        if (this.m_lookup == null) {
            this.initLookup();
        }
        return (idx = (Integer)this.m_lookup.get(field)) == null ? -1 : idx;
    }

    public Class getColumnType(int col) {
        return this.m_types[col];
    }

    public Class getColumnType(String field) {
        int idx = this.getColumnIndex(field);
        return idx < 0 ? null : this.m_types[idx];
    }

    public Object getDefault(int col) {
        return this.m_dflts[col];
    }

    public Object getDefault(String field) {
        int idx = this.getColumnIndex(field);
        return idx < 0 ? null : this.m_dflts[idx];
    }

    public void setDefault(int col, Object val) {
        if (this.m_locked) {
            throw new IllegalStateException("Can not update default values of a locked Schema.");
        }
        this.m_dflts[col] = val;
    }

    public void setDefault(String field, Object val) {
        if (this.m_locked) {
            throw new IllegalStateException("Can not update default values of a locked Schema.");
        }
        int idx = this.getColumnIndex(field);
        this.m_dflts[idx] = val;
    }

    public void setDefault(String field, int val) {
        this.setDefault(field, (Object)new Integer(val));
    }

    public void setDefault(String field, long val) {
        this.setDefault(field, (Object)new Long(val));
    }

    public void setDefault(String field, float val) {
        this.setDefault(field, (Object)new Float(val));
    }

    public void setDefault(String field, double val) {
        this.setDefault(field, (Object)new Double(val));
    }

    public void setDefault(String field, boolean val) {
        this.setDefault(field, (Object)(val ? Boolean.TRUE : Boolean.FALSE));
    }

    public void setInterpolatedDefault(String field, Object val) {
        this.setDefault(field, val);
        this.setDefault(PrefuseLib.getStartField(field), val);
        this.setDefault(PrefuseLib.getEndField(field), val);
    }

    public void setInterpolatedDefault(String field, int val) {
        this.setInterpolatedDefault(field, new Integer(val));
    }

    public void setInterpolatedDefault(String field, long val) {
        this.setInterpolatedDefault(field, new Long(val));
    }

    public void setInterpolatedDefault(String field, float val) {
        this.setInterpolatedDefault(field, new Float(val));
    }

    public void setInterpolatedDefault(String field, double val) {
        this.setInterpolatedDefault(field, new Double(val));
    }

    public void setInterpolatedDefault(String field, boolean val) {
        this.setInterpolatedDefault(field, val ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Schema)) {
            return false;
        }
        Schema s = (Schema)o;
        if (this.m_size != s.getColumnCount()) {
            return false;
        }
        int i = 0;
        while (i < this.m_size) {
            if (!(this.m_names[i].equals(s.getColumnName(i)) && this.m_types[i].equals(s.getColumnType(i)) && this.m_dflts[i].equals(s.getDefault(i)))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isAssignableFrom(Schema s) {
        int ssize = s.getColumnCount();
        if (ssize > this.m_size) {
            return false;
        }
        int i = 0;
        while (i < ssize) {
            int idx = this.getColumnIndex(s.getColumnName(i));
            if (idx < 0) {
                return false;
            }
            if (!this.m_types[idx].equals(s.getColumnType(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int hashcode = 0;
        int i = 0;
        while (i < this.m_size) {
            int idx = i + 1;
            int code = idx * this.m_names[i].hashCode();
            code ^= idx * this.m_types[i].hashCode();
            if (this.m_dflts[i] != null) {
                code ^= this.m_dflts[i].hashCode();
            }
            hashcode ^= code;
            ++i;
        }
        return hashcode;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("Schema[");
        int i = 0;
        while (i < this.m_size) {
            if (i > 0) {
                sbuf.append(' ');
            }
            sbuf.append('(').append(this.m_names[i]).append(", ");
            sbuf.append(this.m_types[i].getName()).append(", ");
            sbuf.append(this.m_dflts[i]).append(')');
            ++i;
        }
        sbuf.append(']');
        return sbuf.toString();
    }

    public Table instantiate() {
        return this.instantiate(0);
    }

    public Table instantiate(int nrows) {
        Table t = new Table(nrows, this.m_size);
        int i = 0;
        while (i < this.m_size) {
            t.addColumn(this.m_names[i], this.m_types[i], this.m_dflts[i]);
            ++i;
        }
        return t;
    }
}

