/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.parser;

import prefuse.data.parser.DataParseException;
import prefuse.data.parser.DataParser;

public class LongParser
implements DataParser {
    public Class getType() {
        return Long.TYPE;
    }

    public String format(Object value) {
        if (value == null) {
            return null;
        }
        if (!(value instanceof Number)) {
            throw new IllegalArgumentException("This class can only format Objects of type Number.");
        }
        return String.valueOf(String.valueOf(((Number)value).longValue())) + "L";
    }

    public boolean canParse(String text) {
        try {
            LongParser.parseLong(text);
            return true;
        }
        catch (DataParseException e) {
            return false;
        }
    }

    public Object parse(String text) throws DataParseException {
        return new Long(LongParser.parseLong(text));
    }

    public static long parseLong(String text) throws DataParseException {
        try {
            char c;
            if (text.length() > 0 && ((c = text.charAt(text.length() - 1)) == 'l' || c == 'L')) {
                text = text.substring(0, text.length() - 1);
            }
            return Long.parseLong(text);
        }
        catch (NumberFormatException e) {
            throw new DataParseException(e);
        }
    }
}

