/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.tuple;

import java.util.Date;
import prefuse.data.Graph;
import prefuse.data.Schema;
import prefuse.data.Table;
import prefuse.data.Tuple;

public class TableTuple
implements Tuple {
    protected Table m_table;
    protected int m_row;

    protected void init(Table table, Graph graph, int row) {
        this.m_table = table;
        this.m_row = this.m_table.isValidRow(row) ? row : -1;
    }

    public Schema getSchema() {
        return this.m_table.getSchema();
    }

    public Table getTable() {
        return this.m_table;
    }

    public int getRow() {
        return this.m_row;
    }

    public boolean isValid() {
        return this.m_row != -1;
    }

    void invalidate() {
        this.m_row = -1;
    }

    private void validityCheck() {
        if (this.m_row == -1) {
            throw new IllegalStateException("This tuple is no longer valid. It has been deleted from its table");
        }
    }

    public Class getColumnType(String field) {
        return this.m_table.getColumnType(field);
    }

    public Class getColumnType(int col) {
        return this.m_table.getColumnType(col);
    }

    public int getColumnIndex(String field) {
        return this.m_table.getColumnNumber(field);
    }

    public int getColumnCount() {
        return this.m_table.getColumnCount();
    }

    public String getColumnName(int col) {
        return this.m_table.getColumnName(col);
    }

    public boolean canGet(String field, Class type) {
        return this.m_table.canGet(field, type);
    }

    public boolean canSet(String field, Class type) {
        return this.m_table.canSet(field, type);
    }

    public final Object get(String field) {
        this.validityCheck();
        return this.m_table.get(this.m_row, field);
    }

    public final void set(String field, Object value) {
        this.validityCheck();
        this.m_table.set(this.m_row, field, value);
    }

    public final Object get(int idx) {
        this.validityCheck();
        return this.m_table.get(this.m_row, idx);
    }

    public final void set(int idx, Object value) {
        this.validityCheck();
        this.m_table.set(this.m_row, idx, value);
    }

    public Object getDefault(String field) {
        this.validityCheck();
        return this.m_table.getDefault(field);
    }

    public void revertToDefault(String field) {
        this.validityCheck();
        this.m_table.revertToDefault(this.m_row, field);
    }

    public final boolean canGetInt(String field) {
        return this.m_table.canGetInt(field);
    }

    public final boolean canSetInt(String field) {
        return this.m_table.canSetInt(field);
    }

    public final int getInt(String field) {
        this.validityCheck();
        return this.m_table.getInt(this.m_row, field);
    }

    public final void setInt(String field, int val) {
        this.validityCheck();
        this.m_table.setInt(this.m_row, field, val);
    }

    public final int getInt(int col) {
        this.validityCheck();
        return this.m_table.getInt(this.m_row, col);
    }

    public final void setInt(int col, int val) {
        this.validityCheck();
        this.m_table.setInt(this.m_row, col, val);
    }

    public final boolean canGetLong(String field) {
        return this.m_table.canGetLong(field);
    }

    public final boolean canSetLong(String field) {
        return this.m_table.canSetLong(field);
    }

    public final long getLong(String field) {
        this.validityCheck();
        return this.m_table.getLong(this.m_row, field);
    }

    public final void setLong(String field, long val) {
        this.validityCheck();
        this.m_table.setLong(this.m_row, field, val);
    }

    public final long getLong(int col) {
        this.validityCheck();
        return this.m_table.getLong(this.m_row, col);
    }

    public final void setLong(int col, long val) {
        this.validityCheck();
        this.m_table.setLong(this.m_row, col, val);
    }

    public final boolean canGetFloat(String field) {
        return this.m_table.canGetFloat(field);
    }

    public final boolean canSetFloat(String field) {
        return this.m_table.canSetFloat(field);
    }

    public final float getFloat(String field) {
        this.validityCheck();
        return this.m_table.getFloat(this.m_row, field);
    }

    public final void setFloat(String field, float val) {
        this.validityCheck();
        this.m_table.setFloat(this.m_row, field, val);
    }

    public final float getFloat(int col) {
        this.validityCheck();
        return this.m_table.getFloat(this.m_row, col);
    }

    public final void setFloat(int col, float val) {
        this.validityCheck();
        this.m_table.setFloat(this.m_row, col, val);
    }

    public final boolean canGetDouble(String field) {
        return this.m_table.canGetDouble(field);
    }

    public final boolean canSetDouble(String field) {
        return this.m_table.canSetDouble(field);
    }

    public final double getDouble(String field) {
        this.validityCheck();
        return this.m_table.getDouble(this.m_row, field);
    }

    public final void setDouble(String field, double val) {
        this.validityCheck();
        this.m_table.setDouble(this.m_row, field, val);
    }

    public final double getDouble(int col) {
        this.validityCheck();
        return this.m_table.getDouble(this.m_row, col);
    }

    public final void setDouble(int col, double val) {
        this.validityCheck();
        this.m_table.setDouble(this.m_row, col, val);
    }

    public final boolean canGetBoolean(String field) {
        return this.m_table.canGetBoolean(field);
    }

    public final boolean canSetBoolean(String field) {
        return this.m_table.canSetBoolean(field);
    }

    public final boolean getBoolean(String field) {
        this.validityCheck();
        return this.m_table.getBoolean(this.m_row, field);
    }

    public final void setBoolean(String field, boolean val) {
        this.validityCheck();
        this.m_table.setBoolean(this.m_row, field, val);
    }

    public final boolean getBoolean(int col) {
        this.validityCheck();
        return this.m_table.getBoolean(this.m_row, col);
    }

    public final void setBoolean(int col, boolean val) {
        this.validityCheck();
        this.m_table.setBoolean(this.m_row, col, val);
    }

    public final boolean canGetString(String field) {
        return this.m_table.canGetString(field);
    }

    public final boolean canSetString(String field) {
        return this.m_table.canSetString(field);
    }

    public final String getString(String field) {
        this.validityCheck();
        return this.m_table.getString(this.m_row, field);
    }

    public final void setString(String field, String val) {
        this.validityCheck();
        this.m_table.setString(this.m_row, field, val);
    }

    public final String getString(int col) {
        this.validityCheck();
        return this.m_table.getString(this.m_row, col);
    }

    public final void setString(int col, String val) {
        this.validityCheck();
        this.m_table.setString(this.m_row, col, val);
    }

    public final boolean canGetDate(String field) {
        return this.m_table.canGetDate(field);
    }

    public final boolean canSetDate(String field) {
        return this.m_table.canSetDate(field);
    }

    public final Date getDate(String field) {
        this.validityCheck();
        return this.m_table.getDate(this.m_row, field);
    }

    public final void setDate(String field, Date val) {
        this.validityCheck();
        this.m_table.setDate(this.m_row, field, val);
    }

    public final Date getDate(int col) {
        this.validityCheck();
        return this.m_table.getDate(this.m_row, col);
    }

    public final void setDate(int col, Date val) {
        this.validityCheck();
        this.m_table.setDate(this.m_row, col, val);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Tuple[");
        int i = 0;
        while (i < this.getColumnCount()) {
            if (i > 0) {
                sb.append(',');
            }
            try {
                sb.append(this.get(i).toString());
            }
            catch (Exception e) {
                sb.append("?");
            }
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }
}

