/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import prefuse.data.Tuple;

public class SortedTupleIterator
implements Iterator {
    private ArrayList m_tuples;
    private Comparator m_cmp;
    private Iterator m_iter;

    public SortedTupleIterator(Iterator iter, Comparator c) {
        this(iter, 128, c);
    }

    public SortedTupleIterator(Iterator iter, int size, Comparator c) {
        this.m_tuples = new ArrayList(size);
        this.init(iter, c);
    }

    public void init(Iterator iter, Comparator c) {
        this.m_tuples.clear();
        this.m_cmp = c;
        while (iter.hasNext()) {
            Tuple t = (Tuple)iter.next();
            this.m_tuples.add(t);
        }
        Collections.sort(this.m_tuples, this.m_cmp);
        this.m_iter = this.m_tuples.iterator();
    }

    public boolean hasNext() {
        return this.m_iter.hasNext();
    }

    public Object next() {
        return this.m_iter.next();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

