/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.test.label;

import junit.framework.TestCase;
import org.eclipse.emf.common.util.URI;
import org.eclipse.ocl.examples.xtext.tests.TestUtil;
import org.eclipse.ocl.pivot.internal.labels.EcoreURILabelGenerator;
import org.eclipse.ocl.pivot.labels.ILabelGenerator;
import org.eclipse.ocl.pivot.labels.LabelGeneratorRegistry;
import org.eclipse.ocl.pivot.utilities.ClassUtil;

public class StandaloneLabelTests
extends TestCase {
    public String getName() {
        return TestUtil.getName((String)ClassUtil.nonNullState((Object)super.getName()));
    }

    public void testEcoreURILabel() {
        String testURI = "http://xyzzy/jj";
        URI uri = URI.createURI((String)testURI);
        LabelGeneratorRegistry myRegistry = new LabelGeneratorRegistry(null);
        String actualLabel = myRegistry.labelFor((Object)uri);
        String expectedLabel1 = "<unknown-URI " + testURI + ">";
        String expectedLabel2 = "<unknown-Hierarchical " + testURI + ">";
        String expectedLabel = actualLabel.contains("URI") ? expectedLabel1 : expectedLabel2;
        StandaloneLabelTests.assertEquals((String)expectedLabel, (String)actualLabel);
        myRegistry = new LabelGeneratorRegistry(ILabelGenerator.Registry.INSTANCE);
        EcoreURILabelGenerator.initialize((ILabelGenerator.Registry)myRegistry);
        actualLabel = myRegistry.labelFor((Object)uri);
        expectedLabel = testURI;
        StandaloneLabelTests.assertEquals((String)expectedLabel, (String)actualLabel);
        EcoreURILabelGenerator.initialize((ILabelGenerator.Registry)ILabelGenerator.Registry.INSTANCE);
        actualLabel = myRegistry.labelFor((Object)uri);
        expectedLabel = testURI;
        StandaloneLabelTests.assertEquals((String)expectedLabel, (String)actualLabel);
        myRegistry.uninstall(URI.class);
        actualLabel = myRegistry.labelFor((Object)uri);
        expectedLabel = testURI;
        StandaloneLabelTests.assertEquals((String)expectedLabel, (String)actualLabel);
        ILabelGenerator.Registry.INSTANCE.uninstall(URI.class);
        actualLabel = myRegistry.labelFor((Object)uri);
        StandaloneLabelTests.assertEquals((String)expectedLabel, (String)actualLabel);
    }
}

