/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.test.label;

import junit.framework.TestCase;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.labels.ILabelGenerator;
import org.eclipse.ocl.pivot.labels.LabelGeneratorRegistry;
import org.eclipse.ocl.pivot.utilities.NameUtil;

public class LabelTests
extends TestCase {
    protected // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull ILabelGenerator.Registry registry = new LabelGeneratorRegistry(ILabelGenerator.Registry.INSTANCE);

    public void setUp() {
        if (!EcorePlugin.IS_ECLIPSE_RUNNING) {
            LabelGeneratorRegistry.initialize((ILabelGenerator.Registry)this.registry);
        }
        EcorePackage.eINSTANCE.getClass();
    }

    public void testEcoreURILabel() {
        String testURI = "http://xyzzy/jj";
        URI uri = URI.createURI((String)testURI);
        String actualLabel = this.registry.labelFor((Object)uri);
        String expectedLabel = testURI;
        LabelTests.assertEquals((String)expectedLabel, (String)actualLabel);
    }

    public void testEcoreFeatureLabel() {
        String actualLabel = this.registry.labelFor((Object)EcorePackage.Literals.ENAMED_ELEMENT__NAME);
        String expectedLabel = "ecore/ENamedElement/name";
        LabelTests.assertEquals((String)expectedLabel, (String)actualLabel);
    }

    public void testEcoreFeatureQualifiedName() {
        String actualLabel = NameUtil.qualifiedNameFor((Object)EcorePackage.Literals.ENAMED_ELEMENT__NAME);
        String expectedLabel = "ecore::ENamedElement::name";
        LabelTests.assertEquals((String)expectedLabel, (String)actualLabel);
    }

    public void testEcoreFeatureName() {
        String actualLabel = NameUtil.simpleNameFor((Object)EcorePackage.Literals.ENAMED_ELEMENT__NAME);
        String expectedLabel = "name";
        LabelTests.assertEquals((String)expectedLabel, (String)actualLabel);
    }
}

