/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.impactanalyzer.instanceScope;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.ecore.CollectionType;
import org.eclipse.ocl.ecore.IterateExp;
import org.eclipse.ocl.ecore.LetExp;
import org.eclipse.ocl.ecore.LoopExp;
import org.eclipse.ocl.ecore.OCLExpression;
import org.eclipse.ocl.ecore.OperationCallExp;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.examples.impactanalyzer.impl.OperationBodyToCallMapper;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.EmptyResultNavigationStep;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.NavigationStep;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.PathCache;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.Tracer;
import org.eclipse.ocl.examples.impactanalyzer.util.AnnotatedEObject;
import org.eclipse.ocl.examples.impactanalyzer.util.OCLFactory;
import org.eclipse.ocl.examples.impactanalyzer.util.OclHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTracer<T extends EObject>
implements Tracer {
    private T expression;
    private final Stack<String> tuplePartNames;
    protected final OCLFactory oclFactory;

    protected AbstractTracer(T expression, OCLFactory oclFactory) {
        this(expression, null, oclFactory);
    }

    protected AbstractTracer(T expression, Stack<String> tuplePartNames, OCLFactory oclFactory) {
        this.expression = expression;
        this.tuplePartNames = tuplePartNames;
        this.oclFactory = oclFactory;
    }

    protected AbstractTracer(T expression, AbstractTracer<?> caller, String additionalTuplePartNameToLookFor, OCLFactory oclFactory) {
        this(expression, AbstractTracer.getExtendedListOfTuplePartNames(caller.tuplePartNames, additionalTuplePartNameToLookFor), oclFactory);
    }

    protected T getExpression() {
        return this.expression;
    }

    protected boolean isLookingForTuplePart() {
        return this.tuplePartNames != null && this.tuplePartNames.size() > 0;
    }

    protected String getTuplePartNameLookedFor() {
        return this.tuplePartNames.peek();
    }

    private static Stack<String> getExtendedListOfTuplePartNames(Stack<String> oldTuplePartNames, String toAdd) {
        Stack result;
        if (oldTuplePartNames == null || oldTuplePartNames.size() == 0) {
            result = new Stack();
        } else {
            Object clone = oldTuplePartNames.clone();
            if (clone instanceof Stack) {
                Stack x;
                result = x = (Stack)clone;
            } else {
                throw new ClassCastException("Cloning an instance of Stack<String> didn't return an instance of the same type.");
            }
        }
        result.add(toAdd);
        return result;
    }

    public Stack<String> getExtendedListOfTuplePartNames(String toAdd) {
        return AbstractTracer.getExtendedListOfTuplePartNames(this.tuplePartNames, toAdd);
    }

    protected Stack<String> getListOfTuplePartNamesWithFoundRemoved() {
        Stack result;
        if (this.tuplePartNames == null || this.tuplePartNames.size() <= 1) {
            result = null;
        } else {
            Object clone = this.tuplePartNames.clone();
            if (clone instanceof Stack) {
                Stack x;
                result = x = (Stack)clone;
                result.pop();
            } else {
                throw new ClassCastException("Cloning an instance of Stack<String> didn't return an instance of the same type.");
            }
        }
        return result;
    }

    public Stack<String> getTupleLiteralPartNamesToLookFor() {
        return this.tuplePartNames;
    }

    protected OCLExpression getRootExpression() {
        return OclHelper.getRootExpression(this.getExpression());
    }

    protected boolean doesTypeMatch(EObject s) {
        return this.getExpression().eClass().isInstance((Object)s);
    }

    public static boolean doesTypeMatch(EClass sourceType, AnnotatedEObject fromObject) {
        return sourceType.isInstance((Object)fromObject.getAnnotatedObject());
    }

    @Override
    public NavigationStep traceback(EClass context, PathCache pathCache, OperationBodyToCallMapper operationBodyToCallMapper) {
        EmptyResultNavigationStep result = new EmptyResultNavigationStep((OCLExpression)this.getExpression());
        this.applyScopesOnNavigationStep(result, operationBodyToCallMapper);
        return result;
    }

    protected EClass getInnermostElementType(EClassifier type) {
        while (!(type instanceof EClass) && type instanceof CollectionType) {
            type = (EClassifier)((CollectionType)type).getElementType();
        }
        return (EClass)type;
    }

    protected Set<Variable> calculateLeavingScopes(OperationBodyToCallMapper operationBodyToCallMapper) {
        return Collections.emptySet();
    }

    protected Set<Variable> calculateEnteringScope(OperationBodyToCallMapper operationBodyToCallMapper) {
        return Collections.emptySet();
    }

    protected void applyScopesOnNavigationStep(NavigationStep step, OperationBodyToCallMapper operationBodyToCallMapper) {
        step.addEnteringScopes(this.calculateEnteringScope(operationBodyToCallMapper));
        step.addLeavingScopes(this.calculateLeavingScopes(operationBodyToCallMapper));
    }

    protected Set<Variable> variablesIntroducedBetween(OCLExpression origin, OCLExpression parent, OperationBodyToCallMapper operationBodyToCallMapper) {
        OCLExpression e = origin;
        HashSet<Variable> result = new HashSet<Variable>();
        while (e != parent) {
            if (e instanceof OCLExpression) {
                result.addAll(AbstractTracer.getVariablesScopedByExpression(e, operationBodyToCallMapper));
            }
            e = e.eContainer();
        }
        return result;
    }

    protected static Set<Variable> getVariablesScopedByExpression(OCLExpression e, OperationBodyToCallMapper operationBodyToCallMapper) {
        EObject container = e.eContainer();
        HashSet<Variable> result = new HashSet<Variable>();
        if (container instanceof LoopExp && ((LoopExp)container).getBody() == e) {
            Variable resultVariable;
            for (org.eclipse.ocl.expressions.Variable v : ((LoopExp)container).getIterator()) {
                result.add((Variable)v);
            }
            if (container instanceof IterateExp && (resultVariable = (Variable)((IterateExp)container).getResult()) != null) {
                result.add(resultVariable);
            }
        } else if (container instanceof LetExp && ((LetExp)container).getIn() == e) {
            result.add((Variable)((LetExp)container).getVariable());
        } else {
            Set<OperationCallExp> calls = operationBodyToCallMapper.getCallsOf(e);
            if (!calls.isEmpty()) {
                result.addAll(operationBodyToCallMapper.getSelfVariablesUsedInBody(e));
                result.addAll(operationBodyToCallMapper.getParameterVariablesUsedInBody(e));
            }
        }
        return result;
    }

    protected static Set<Variable> getAllVariablesInScope(OCLExpression e, OperationBodyToCallMapper operationBodyToCallMapper) {
        HashSet<Variable> result = new HashSet<Variable>();
        OCLExpression cursor = e;
        while (cursor != null) {
            if (cursor instanceof OCLExpression) {
                result.addAll(AbstractTracer.getVariablesScopedByExpression(cursor, operationBodyToCallMapper));
            }
            cursor = cursor.eContainer();
        }
        return result;
    }

    protected Set<Variable> getVariablesIntroducedBetweenHereAnd(OCLExpression parent, OperationBodyToCallMapper operationBodyToCallMapper) {
        return this.variablesIntroducedBetween((OCLExpression)this.getExpression(), parent, operationBodyToCallMapper);
    }

    protected static OCLExpression commonCompositionParent(OCLExpression first, OCLExpression second) {
        HashSet<OCLExpression> firstsContainersIncludingFirst = new HashSet<OCLExpression>();
        OCLExpression firstsContainer = first;
        while (firstsContainer != null && firstsContainer instanceof OCLExpression) {
            firstsContainersIncludingFirst.add(firstsContainer);
            firstsContainer = firstsContainer.eContainer();
        }
        OCLExpression secondsContainer = second;
        OCLExpression result = null;
        while (result == null && secondsContainer != null && secondsContainer instanceof OCLExpression) {
            if (firstsContainersIncludingFirst.contains(secondsContainer)) {
                result = secondsContainer;
                continue;
            }
            secondsContainer = secondsContainer.eContainer();
        }
        return result;
    }

    protected OCLExpression commonCompositionParent(OCLExpression second) {
        return AbstractTracer.commonCompositionParent((OCLExpression)this.getExpression(), second);
    }
}

