/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.proxy.ui.apiaccess;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.ui.editor.IMultiDiagramEditor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class PapyrusResourceAccess {
    protected ModelSet modelSet;

    public TransactionalEditingDomain getDomain() {
        return this.getCurrentModelSet().getTransactionalEditingDomain();
    }

    public EObject getRootEObjectFromResource() {
        Object object;
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(Display.getDefault().getActiveShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new BaseWorkbenchContentProvider());
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        PatternFilter UMLPattern = new PatternFilter(){

            public boolean isElementVisible(Viewer viewer, Object element) {
                if (viewer != null) {
                    return super.isElementVisible(viewer, element);
                }
                return true;
            }
        };
        UMLPattern.setPattern("*.*");
        dialog.setAllowMultiple(false);
        dialog.addFilter((ViewerFilter)UMLPattern);
        dialog.open();
        if (dialog.getResult().length > 0 && (object = dialog.getResult()[0]) instanceof IFile) {
            IFile aReviewModel = (IFile)object;
            Resource tmpResource = this.getCurrentModelSet().getResource(URI.createPlatformResourceURI((String)aReviewModel.getFullPath().toOSString(), (boolean)true), true);
            return (EObject)tmpResource.getContents().get(0);
        }
        return null;
    }

    protected IWorkbenchPart getBootstrapPart() {
        IEditorPart part = null;
        try {
            IWorkbenchPage activePage;
            IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (activeWorkbenchWindow != null && (activePage = activeWorkbenchWindow.getActivePage()) != null) {
                part = activePage.getActiveEditor();
            }
        }
        catch (NullPointerException e) {
            return null;
        }
        if (this.isImportant((IWorkbenchPart)part)) {
            return part;
        }
        return null;
    }

    protected boolean isImportant(IWorkbenchPart part) {
        return part instanceof IMultiDiagramEditor;
    }

    public ModelSet getCurrentModelSet() {
        if (this.modelSet != null) {
            return this.modelSet;
        }
        IWorkbenchPart part = this.getBootstrapPart();
        if (part instanceof IMultiDiagramEditor) {
            try {
                this.modelSet = (ModelSet)this.getServiceRegistry().getService(ModelSet.class);
            }
            catch (org.osgi.framework.ServiceException e) {
                e.printStackTrace();
            }
            catch (ServiceException e) {
                e.printStackTrace();
            }
        }
        return this.modelSet;
    }

    public ServicesRegistry getServiceRegistry() {
        IWorkbenchPart part = this.getBootstrapPart();
        if (part instanceof IMultiDiagramEditor) {
            ServicesRegistry registry = ((IMultiDiagramEditor)part).getServicesRegistry();
            return registry;
        }
        return null;
    }
}

