/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.types.generator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.papyrus.eclipse.project.editors.project.PluginEditor;
import org.eclipse.papyrus.toolsmiths.Activator;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.osgi.framework.Version;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TypesPluginGenerator {
    public static final String TYPES_CORE_PLUGIN = "org.eclipse.papyrus.infra.types.core";
    private static final String EXTENSION_POINT = "org.eclipse.papyrus.infra.types.core.elementTypeSetConfiguration";
    private static final String ELEMENT_TYPE_SET = "elementTypeSet";
    private static final String CLIENT_CONTEXT_ID = "clientContextID";
    private static final String PATH = "path";

    public IStatus generate(Collection<IPath> elementTypesConfigurationModels, String contextId, boolean generateExtensionPoint) {
        Map<IProject, Collection<IPath>> paths = this.groupByProject(elementTypesConfigurationModels);
        for (Map.Entry<IProject, Collection<IPath>> entry : paths.entrySet()) {
            IProject project = entry.getKey();
            IStatus iStatus = this.configurePlugin(project, entry.getValue(), contextId, generateExtensionPoint);
        }
        return Status.OK_STATUS;
    }

    protected IStatus configurePlugin(IProject project, Collection<IPath> modelPaths, String contextId, boolean generateExtensionPoint) {
        if (!project.exists()) {
            return new Status(2, this.getClass(), "The target model is not located in a workspace project; cannot configure the plug-in.");
        }
        if (!project.isOpen()) {
            try {
                project.open(null);
            }
            catch (CoreException e) {
                Activator.log.error((Throwable)e);
                return new Status(2, this.getClass(), "The target model is located in a workspace project that couldn't be opened; impossible to configure the plug-in.");
            }
        }
        try {
            PluginEditor editor = new PluginEditor(project);
            editor.init();
            if (!editor.exists()) {
                return new Status(2, this.getClass(), "The target model is not located in an Eclipse Plug-in Project; impossible to configure the plug-in.");
            }
            this.addDependencies(editor);
            if (generateExtensionPoint) {
                this.addExtensions(editor, modelPaths, contextId);
            }
            for (IPath path : modelPaths) {
                this.addBuildProperties(editor, path);
            }
            editor.save();
        }
        catch (Exception ex) {
            return new Status(2, this.getClass(), "The target model is not located in an Eclipse Plug-in Project; impossible to configure the plug-in.", (Throwable)ex);
        }
        return Status.OK_STATUS;
    }

    protected void addDependencies(PluginEditor editor) {
        if (!editor.hasDependency(TYPES_CORE_PLUGIN)) {
            Version currentVersion = this.getTypesCorePluginVersion();
            editor.addDependency(TYPES_CORE_PLUGIN, String.format("[%s, %s)", this.getTypesCorePluginMin(currentVersion), this.getTypesCorePluginMax(currentVersion)));
        }
    }

    private Version getTypesCorePluginVersion() {
        List pluginModels = PluginRegistry.findModels((String)TYPES_CORE_PLUGIN, null).toList();
        for (IPluginModelBase next : pluginModels) {
            if (next.getBundleDescription() == null) continue;
            return next.getBundleDescription().getVersion();
        }
        return null;
    }

    private String getTypesCorePluginMin(Version currentVersion) {
        return new Version(currentVersion.getMajor(), currentVersion.getMinor(), 0).toString();
    }

    private String getTypesCorePluginMax(Version currentVersion) {
        return new Version(currentVersion.getMajor() + 1, 0, 0).toString();
    }

    protected void addExtensions(PluginEditor editor, Collection<IPath> modelPaths, String contextId) {
        if (!editor.pluginManifestExists()) {
            editor.getPluginEditor().create();
        }
        editor.addToBuild("plugin.xml");
        Set missingPaths = modelPaths.stream().map(this::toLocalProjectPath).map(IPath::toString).collect(Collectors.toSet());
        List extensions = editor.getExtensions(EXTENSION_POINT);
        for (Node extension : extensions) {
            NodeList childNodes = extension.getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                Element childElement;
                Node childNode = childNodes.item(i);
                if (childNode.getNodeType() == 1 && ELEMENT_TYPE_SET.equals(childNode.getNodeName()) && contextId.equals((childElement = (Element)childNode).getAttribute(CLIENT_CONTEXT_ID)) && childElement.hasAttribute(PATH)) {
                    missingPaths.remove(childElement.getAttribute(PATH));
                }
                ++i;
            }
        }
        for (String modelPath : missingPaths) {
            Element ext = editor.addExtension(EXTENSION_POINT);
            Element elementTypeSet = editor.addChild(ext, ELEMENT_TYPE_SET);
            elementTypeSet.setAttribute(PATH, modelPath);
            elementTypeSet.setAttribute(CLIENT_CONTEXT_ID, contextId);
        }
    }

    protected void addBuildProperties(PluginEditor editor, IPath modelPath) {
        IPath path = this.toLocalProjectPath(modelPath);
        path = path.removeLastSegments(1);
        editor.addToBuild(path.toString() + "/");
    }

    protected IPath toLocalProjectPath(IPath modelPath) {
        IPath path = modelPath.removeFirstSegments(1);
        return path;
    }

    private Map<IProject, Collection<IPath>> groupByProject(Collection<IPath> elementTypesConfigurationModels) {
        HashMap<IProject, Collection<IPath>> result = new HashMap<IProject, Collection<IPath>>();
        for (IPath configPath : elementTypesConfigurationModels) {
            result.computeIfAbsent(this.getProject(configPath), project -> new ArrayList()).add(configPath);
        }
        return result;
    }

    private IProject getProject(IPath path) {
        if (path.segmentCount() == 0) {
            return null;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        return root.getProject(path.segment(0));
    }
}

