/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.junit.framework.classification.rules;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import org.eclipse.papyrus.junit.framework.classification.rules.Condition;
import org.eclipse.papyrus.junit.framework.classification.rules.Conditional;
import org.junit.Assert;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public class ConditionRule
implements MethodRule {
    public Statement apply(final Statement base, final FrameworkMethod method, final Object target) {
        return new Statement(){

            public void evaluate() throws Throwable {
                if (ConditionRule.testCondition(method.getMethod().getDeclaringClass(), (Conditional)method.getAnnotation(Conditional.class), target)) {
                    base.evaluate();
                }
            }
        };
    }

    public static boolean testCondition(Class<?> testClass, Conditional conditional, Object test) {
        boolean result = true;
        if (conditional != null) {
            Method conditionMethod = ConditionRule.findConditionMethod(testClass, conditional);
            if (conditionMethod != null) {
                result = ConditionRule.evaluateCondition(conditionMethod, test);
            } else {
                Field conditionField = ConditionRule.findConditionField(testClass, conditional);
                if (conditionField != null) {
                    result = ConditionRule.evaluateCondition(conditionField, test);
                } else {
                    Assert.fail((String)("Condition not found: " + conditional.key()));
                }
            }
        }
        return result;
    }

    static Method findConditionMethod(Class<?> testClass, Conditional conditional) {
        Method result = null;
        Method[] methodArray = testClass.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method next = methodArray[n2];
            Condition condition = next.getAnnotation(Condition.class);
            if (condition != null && ConditionRule.match(conditional.key(), condition, next)) {
                result = next;
                break;
            }
            ++n2;
        }
        return result;
    }

    static Field findConditionField(Class<?> testClass, Conditional conditional) {
        Field result = null;
        Field[] fieldArray = testClass.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field next = fieldArray[n2];
            Condition condition = next.getAnnotation(Condition.class);
            if (condition != null && ConditionRule.match(conditional.key(), condition, next)) {
                result = next;
                break;
            }
            ++n2;
        }
        return result;
    }

    static boolean evaluateCondition(Method conditionMethod, Object test) {
        boolean result = true;
        try {
            result = (Boolean)conditionMethod.invoke(test, new Object[0]);
        }
        catch (InvocationTargetException e) {
            e.getTargetException().printStackTrace();
            Assert.fail((String)("Condition method evaluation failed: " + e.getTargetException().getLocalizedMessage()));
        }
        catch (Exception e) {
            Assert.fail((String)String.format("Condition method must be public, accept no arguments, and return a boolean result: %s::%s()", conditionMethod.getDeclaringClass().getSimpleName(), conditionMethod.getName()));
        }
        return result;
    }

    static boolean evaluateCondition(Field conditionField, Object test) {
        boolean result = true;
        try {
            result = (Boolean)conditionField.get(test);
        }
        catch (Exception e) {
            Assert.fail((String)String.format("Condition field must be public and boolean-valued: %s::%s", conditionField.getDeclaringClass().getSimpleName(), conditionField.getName()));
        }
        return result;
    }

    static boolean match(String conditionKey, Condition condition, Member conditionMember) {
        String match = condition.key();
        if (match == null || match.equals("")) {
            match = conditionMember.getName();
        }
        return match.equals(conditionKey);
    }
}

