/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.profilemigration.internal.migrators.atomic.stereotype;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.papyrus.toolsmiths.profilemigration.MigratorProfileApplication;
import org.eclipse.papyrus.toolsmiths.profilemigration.internal.data.structure.StereotypeApplicationDescriptor;
import org.eclipse.papyrus.toolsmiths.profilemigration.internal.data.structure.StereotypeApplicationRegistry;
import org.eclipse.papyrus.toolsmiths.profilemigration.internal.utils.TreeNodeUtils;
import org.eclipse.papyrus.toolsmiths.profilemigration.migrators.atomic.AbstractMigrator;
import org.eclipse.papyrus.toolsmiths.profilemigration.migrators.atomic.stereotype.IAddPropertyToStereotypeMigrator;
import org.eclipse.papyrus.toolsmiths.profilemigration.ui.dialogs.AddPropertyToStereotypeDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Extension;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

public class AddPropertyToStereotypeMigrator
extends AbstractMigrator
implements IAddPropertyToStereotypeMigrator {
    Stereotype stereotype;
    Property property;

    public AddPropertyToStereotypeMigrator(TreeNode treeNode) {
        super(treeNode);
    }

    public static boolean isValid(TreeNode treeNode) {
        EObject element;
        return TreeNodeUtils.isAddType(treeNode, MigratorProfileApplication.appliedProfile) && (element = TreeNodeUtils.getAddedElement(treeNode)) instanceof Property && ((Property)element).getLower() > 0 && ((Property)element).getDefaultValue() == null && !(((Property)element).getAssociation() instanceof Extension);
    }

    @Override
    public boolean isValid() {
        return AddPropertyToStereotypeMigrator.isValid(this.treeNode);
    }

    @Override
    public void migrationAction() {
        List<StereotypeApplicationDescriptor> list = StereotypeApplicationRegistry.getAllStereotypeApplicationDescriptors(this.stereotype);
        HashMap mapElementToStereotype = new HashMap();
        for (StereotypeApplicationDescriptor descriptor : list) {
            if (mapElementToStereotype.get(descriptor.getOwner()) == null) {
                ArrayList<Stereotype> stereotypes = new ArrayList<Stereotype>();
                stereotypes.add(descriptor.getStereotype());
                mapElementToStereotype.put(descriptor.getOwner(), stereotypes);
                continue;
            }
            ((List)mapElementToStereotype.get(descriptor.getOwner())).add(descriptor.getStereotype());
        }
        if (!mapElementToStereotype.isEmpty()) {
            AddPropertyToStereotypeDialog dialog = new AddPropertyToStereotypeDialog(Display.getDefault().getActiveShell(), this.stereotype, this.property, mapElementToStereotype);
            dialog.open();
        }
    }

    @Override
    public void initAttributes() {
        if (this.isValid()) {
            this.property = (Property)TreeNodeUtils.getAddedElement(this.treeNode);
            this.stereotype = (Stereotype)this.property.getOwner();
        }
    }

    @Override
    public int getPriority() {
        return 50;
    }

    @Override
    public Stereotype getStereotype() {
        return this.stereotype;
    }

    @Override
    public Property getProperty() {
        return this.property;
    }

    @Override
    public Element getAddedElement() {
        return this.getProperty();
    }

    @Override
    public Element getAddedElementContainer() {
        return this.getStereotype();
    }
}

