/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.dev.types.providers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.MetamodelType;
import org.eclipse.gmf.runtime.emf.type.core.SpecializationType;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.dev.types.utils.IElementTypeComparator;

public class ElementTypesContentProvider
implements ITreeContentProvider {
    private Map<IElementType, List<SpecializationType>> elementTypesHierarchy = new HashMap<IElementType, List<SpecializationType>>();

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof Object[]) {
            this.elementTypesHierarchy.clear();
            Object[] objectArray = (Object[])newInput;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object elementType = objectArray[n2];
                if (elementType instanceof MetamodelType) {
                    if (!this.elementTypesHierarchy.containsKey(elementType)) {
                        this.elementTypesHierarchy.put((IElementType)((MetamodelType)elementType), new ArrayList());
                    }
                } else if (elementType instanceof SpecializationType) {
                    IElementType[] iElementTypeArray = ((SpecializationType)elementType).getSpecializedTypes();
                    int n3 = iElementTypeArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IElementType superType = iElementTypeArray[n4];
                        if (!this.elementTypesHierarchy.containsKey(superType)) {
                            this.elementTypesHierarchy.put(superType, new ArrayList());
                        }
                        this.elementTypesHierarchy.get(superType).add((SpecializationType)elementType);
                        ++n4;
                    }
                }
                ++n2;
            }
        }
    }

    public Object[] getElements(Object inputElement) {
        this.inputChanged(null, null, inputElement);
        ArrayList<IElementType> result = new ArrayList<IElementType>();
        for (IElementType iElementType : this.elementTypesHierarchy.keySet()) {
            if (!(iElementType instanceof MetamodelType)) continue;
            result.add(iElementType);
        }
        Collections.sort(result, new IElementTypeComparator());
        return result.toArray();
    }

    public Object[] getChildren(Object parentElement) {
        return this.elementTypesHierarchy.containsKey(parentElement) ? this.elementTypesHierarchy.get(parentElement).toArray() : Collections.emptyList().toArray();
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length != 0;
    }
}

