/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.editor.representation.architecture;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.papyrus.emf.ui.providers.labelproviders.DelegatingToEMFLabelProvider;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.sirius.editor.representation.ICreateSiriusDiagramEditorCommand;
import org.eclipse.papyrus.sirius.editor.representation.SiriusDiagramPrototype;
import org.eclipse.papyrus.sirius.editor.representation.architecture.Activator;
import org.eclipse.papyrus.sirius.editor.representation.architecture.commands.CreateSiriusDiagramEditorViewCommand;
import org.eclipse.papyrus.sirius.editor.representation.architecture.internal.messages.Messages;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractCreateSiriusDiagramEditorCommand
implements ICreateSiriusDiagramEditorCommand {
    protected String askDiagramName(String dialogTitle, String proposedName) {
        InputDialog dialog = new InputDialog(Display.getCurrent().getActiveShell(), dialogTitle, Messages.AbstractCreateSiriusDiagramEditorCommand_DialogMessage, proposedName, null);
        if (dialog.open() == 0) {
            return dialog.getValue();
        }
        return null;
    }

    protected DSemanticDiagram execute(SiriusDiagramPrototype diagramTemplatePrototype, String diagramName, EObject semanticContext, boolean openAfterCreation, String id) {
        return this.execute(diagramTemplatePrototype, diagramName, semanticContext, semanticContext, openAfterCreation, id);
    }

    public DSemanticDiagram execute(SiriusDiagramPrototype diagram, String diagramName, EObject semanticContext, EObject graphicalContext, boolean openAfterCreation, String id) {
        Resource res = semanticContext.eResource();
        URI semanticURI = res.getURI();
        if (semanticURI.isPlatformPlugin()) {
            Activator.log.error("Unexpected Error", (Throwable)new UnsupportedOperationException("Diagram for element stored as platform plugin is not yet supported"));
            return null;
        }
        TransactionalEditingDomain domain = this.getEditingDomain(semanticContext);
        if (domain == null) {
            return null;
        }
        String siriusDiagramMainTitle = this.getSiriusDiagramMainTitle(semanticContext);
        CreateSiriusDiagramEditorViewCommand command = this.createDSemanticDiagramEditorCreationCommand(domain, diagram, diagramName, siriusDiagramMainTitle, semanticContext, graphicalContext, openAfterCreation, id);
        domain.getCommandStack().execute((Command)command);
        return (DSemanticDiagram)command.getCreatedEditorView();
    }

    public CreateSiriusDiagramEditorViewCommand createDSemanticDiagramEditorCreationCommand(TransactionalEditingDomain editingDomain, SiriusDiagramPrototype diagramPrototype, String diagramName, String diagramMainTitle, EObject semanticContext, EObject graphicalContext, boolean openAfterCreation, String diagramId) {
        return new CreateSiriusDiagramEditorViewCommand(editingDomain, diagramPrototype, diagramName, diagramMainTitle, semanticContext, graphicalContext, openAfterCreation, diagramId);
    }

    public CreateSiriusDiagramEditorViewCommand createDSemanticDiagramEditorCreationCommand(TransactionalEditingDomain editingDomain, SiriusDiagramPrototype diagramPrototype, String diagramName, String diagramMainTitle, EObject semanticContext, boolean openAfterCreation, String diagramId) {
        return new CreateSiriusDiagramEditorViewCommand(editingDomain, diagramPrototype, diagramName, diagramMainTitle, semanticContext, openAfterCreation, diagramId);
    }

    protected final ServicesRegistry getServiceRegistry(EObject modelElement) {
        try {
            return ServiceUtilsForEObject.getInstance().getServiceRegistry(modelElement);
        }
        catch (ServiceException e) {
            Activator.log.error("ServicesRegistry not found", (Throwable)e);
            return null;
        }
    }

    protected final TransactionalEditingDomain getEditingDomain(EObject modelElement) {
        ServicesRegistry servicesRegistry = this.getServiceRegistry(modelElement);
        if (servicesRegistry == null) {
            return null;
        }
        try {
            return ServiceUtils.getInstance().getTransactionalEditingDomain((Object)servicesRegistry);
        }
        catch (ServiceException e) {
            Activator.log.error("EditingDomain not found", (Throwable)e);
            return null;
        }
    }

    protected String getSiriusDiagramMainTitle(EObject semanticContext) {
        return DelegatingToEMFLabelProvider.INSTANCE.getText((Object)semanticContext);
    }
}

