/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.dev.project.management.internal.operations;

import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.papyrus.dev.project.management.Activator;
import org.eclipse.papyrus.dev.project.management.internal.operations.AbstractManifestUpdateOperation;
import org.eclipse.papyrus.dev.project.management.internal.operations.DependencyAnalysisContext;
import org.eclipse.papyrus.eclipse.project.editors.interfaces.IManifestEditor;
import org.eclipse.papyrus.infra.tools.util.Iterables2;

public class SingletonBundle
extends AbstractManifestUpdateOperation {
    public SingletonBundle(Map<? extends IFile, ? extends IManifestEditor> manifests) {
        super("Optimize Bundle Dependencies", manifests);
    }

    @Override
    protected IStatus doExecute(IProgressMonitor monitor, Map<? extends IFile, ? extends IManifestEditor> manifests) throws ExecutionException {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)"Analyzing ...", (int)(manifests.size() + 1));
        sub.split(1).beginTask("Initializing", -1);
        DependencyAnalysisContext analysisContext = new DependencyAnalysisContext(manifests.keySet());
        List bundles = Iterables2.topoSort(analysisContext.getAnalysisRoots(), DependencyAnalysisContext.BundleAnalysis::partialCompare);
        for (DependencyAnalysisContext.BundleAnalysis bundle : bundles) {
            IManifestEditor editor = manifests.get(bundle.getManifest());
            SubMonitor step = sub.split(1);
            if (step.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (editor != null) {
                editor.init();
                editor.setSingleton(true);
                editor.save();
                continue;
            }
            Activator.log.warn("Null editor: " + bundle.getBundleID());
        }
        return Status.OK_STATUS;
    }
}

