/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.uml.diagram.common.provider;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.common.core.service.AbstractProvider;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramEditDomain;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.AbstractDecorator;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecorator;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorProvider;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.services.decoration.DecorationChange;
import org.eclipse.papyrus.infra.services.decoration.DecorationService;
import org.eclipse.papyrus.infra.services.decoration.util.Decoration;
import org.eclipse.papyrus.infra.services.decoration.util.IPapyrusDecoration;
import org.eclipse.papyrus.sirius.editor.internal.decorations.DiagramDecorationAdapter;
import org.eclipse.papyrus.sirius.editor.utils.ServiceUtilsForSirius;
import org.eclipse.papyrus.sirius.uml.diagram.common.Activator;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.ValueSpecification;

public abstract class ValidationDecoratorProvider
extends AbstractProvider
implements IDecoratorProvider {
    protected static final String KEY = "validationStatus";
    private static Map<String, IDecorator> allDecorators = new HashMap<String, IDecorator>();

    public abstract void createDecorators(IDecoratorTarget var1);

    public abstract boolean provides(IOperation var1);

    public static void refreshDecorators(View view) {
        ValidationDecoratorProvider.refreshDecorators(ViewUtil.getIdStr((View)view), TransactionUtil.getEditingDomain((EObject)view));
    }

    private static void refreshDecorators(String viewId, final TransactionalEditingDomain domain) {
        IDecorator decorator;
        IDecorator iDecorator = decorator = viewId != null ? allDecorators.get(viewId) : null;
        if (decorator == null || domain == null) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    domain.runExclusive(new Runnable(){

                        @Override
                        public void run() {
                            decorator.refresh();
                        }
                    });
                }
                catch (Exception e) {
                    Activator.log.error("Decorator refresh failure", (Throwable)e);
                }
            }
        });
    }

    public static class StatusDecorator
    extends AbstractDecorator
    implements Observer {
        private String viewId;
        private TransactionalEditingDomain editingDomain;
        private DecorationService decorationService;
        private Object element;
        private final DiagramDecorationAdapter diagramDecorationAdapter;

        public StatusDecorator(IDecoratorTarget decoratorTarget) {
            super(decoratorTarget);
            this.diagramDecorationAdapter = new DiagramDecorationAdapter(decoratorTarget);
        }

        public void refresh() {
            View view = (View)this.getDecoratorTarget().getAdapter(View.class);
            if (view == null || view.eResource() == null) {
                return;
            }
            if (view.getElement() != null && this.decorationService != null) {
                this.diagramDecorationAdapter.removeDecorations();
                BasicEList semanticDecorations = new BasicEList();
                for (Object decoratedElement : this.getDecoratedElements(this.element)) {
                    semanticDecorations.addAll(this.decorationService.getDecorations(decoratedElement, false));
                }
                List graphicalDecorations = this.decorationService.getDecorations((Object)view, false);
                LinkedList decorations = new LinkedList(semanticDecorations);
                decorations.addAll(graphicalDecorations);
                if (view instanceof Edge) {
                    this.diagramDecorationAdapter.setDecorationsEdge(decorations, 50, true);
                } else {
                    this.diagramDecorationAdapter.setDecorationsNode(decorations, 0, true);
                }
            }
        }

        public void refresh(DecorationChange change) {
            if (change.getChangeKind() == DecorationChange.DecorationChangeKind.DecorationRemoved || change.getChangeKind() == DecorationChange.DecorationChangeKind.DecorationModified || change.getChangeKind() == DecorationChange.DecorationChangeKind.RefreshAll) {
                this.refresh();
                return;
            }
            View view = (View)this.getDecoratorTarget().getAdapter(View.class);
            if (view == null || view.eResource() == null) {
                return;
            }
            if (view instanceof Edge) {
                this.refresh();
                return;
            }
            if (view.getElement() != null && change.getChangeKind() == DecorationChange.DecorationChangeKind.DecorationAdded) {
                this.diagramDecorationAdapter.addDecorationNode((IPapyrusDecoration)change.getDecoration(), -1, true);
            }
        }

        public void activate() {
            IDecorator decorator;
            try {
                final View view = (View)this.getDecoratorTarget().getAdapter(View.class);
                this.element = view.getElement();
                if (this.element instanceof DSemanticDecorator) {
                    this.element = ((DSemanticDecorator)this.element).getTarget();
                }
                EditPart editPart = (EditPart)this.getDecoratorTarget().getAdapter(EditPart.class);
                IDiagramEditDomain domain = (IDiagramEditDomain)editPart.getViewer().getEditDomain();
                ServicesRegistry serviceRegistry = ServiceUtilsForSirius.getInstance().getServiceRegistry(domain);
                this.decorationService = (DecorationService)serviceRegistry.getService(DecorationService.class);
                this.decorationService.addListener((Observer)this);
                TransactionUtil.getEditingDomain((EObject)view).runExclusive(new Runnable(){

                    @Override
                    public void run() {
                        viewId = view != null ? ViewUtil.getIdStr((View)view) : null;
                        editingDomain = TransactionUtil.getEditingDomain((EObject)view);
                    }
                });
            }
            catch (Exception e) {
                Activator.log.error("ViewID access failure", (Throwable)e);
            }
            if (this.viewId != null && (decorator = allDecorators.get(this.viewId)) == null) {
                allDecorators.put(this.viewId, (IDecorator)this);
            }
        }

        public void deactivate() {
            this.diagramDecorationAdapter.removeDecorations();
            if (this.decorationService != null) {
                this.decorationService.deleteListener((Observer)this);
                this.decorationService = null;
            }
            if (this.viewId != null) {
                allDecorators.remove(this.viewId);
            }
            super.deactivate();
        }

        @Override
        public void update(Observable o, Object arg) {
            DecorationChange change;
            if (arg instanceof DecorationChange && ((change = (DecorationChange)arg).getChangeKind() == DecorationChange.DecorationChangeKind.RefreshAll || this.decorationMatches(this.element, change.getDecoration()))) {
                this.refresh(change);
            }
        }

        public List<Object> getDecoratedElements(Object viewElement) {
            ValueSpecification vs;
            BasicEList decoratedElements = new BasicEList();
            decoratedElements.add(viewElement);
            if (this.element instanceof Constraint && (vs = ((Constraint)this.element).getSpecification()) != null) {
                decoratedElements.add(vs);
            }
            return decoratedElements;
        }

        public boolean decorationMatches(Object viewElement, Decoration decoration) {
            return this.getDecoratedElements(viewElement).contains(decoration.getElement());
        }
    }
}

