/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.uml.diagram.sequence.services;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.sirius.uml.diagram.sequence.services.utils.SequenceDiagramUMLHelper;
import org.eclipse.papyrus.uml.domain.services.internal.helpers.OccurrenceSpecificationHelper;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ExecutionOccurrenceSpecification;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OccurrenceSpecification;

public class SequenceDiagramOrderServices {
    public static final String FINISH_ANNOTATION_SOURCE = "org.eclipse.papyrus.sirius.uml.diagram.sequence.finish";
    public static final String ORDERING_ANNOTATION_SOURCE = "org.eclipse.papyrus.sirius.uml.diagram.sequence.end";
    public static final String START_ANNOTATION_SOURCE = "org.eclipse.papyrus.sirius.uml.diagram.sequence.start";
    private static final SequenceDiagramUMLHelper UML_HELPER = new SequenceDiagramUMLHelper();

    public EAnnotation createStartingEnd(NamedElement baseElement) {
        return this.createEnd(baseElement, START_ANNOTATION_SOURCE);
    }

    public EAnnotation createFinishingEnd(NamedElement baseElement) {
        return this.createEnd(baseElement, FINISH_ANNOTATION_SOURCE);
    }

    private EAnnotation createEnd(NamedElement baseElement, String endId) {
        EAnnotation annotation = EcoreFactory.eINSTANCE.createEAnnotation();
        annotation.setSource(endId);
        InteractionFragment fragment = this.getSemanticEnd(endId, (Element)baseElement);
        annotation.getReferences().add((Object)fragment);
        if (baseElement != fragment) {
            annotation.getReferences().add((Object)baseElement);
        }
        Interaction owningInteraction = UML_HELPER.getOwningInteraction((Element)baseElement);
        EAnnotation orderingAnnotation = this.getOrderingAnnotation(owningInteraction);
        orderingAnnotation.getContents().add((Object)annotation);
        return annotation;
    }

    public boolean removeEnd(EAnnotation end) {
        NamedElement endOwner = this.getEndOwner(end);
        Interaction owningInteraction = UML_HELPER.getOwningInteraction((Element)endOwner);
        EAnnotation orderingAnnotation = this.getOrderingAnnotation(owningInteraction);
        return orderingAnnotation.getContents().remove((Object)end);
    }

    public InteractionFragment getEndFragment(EAnnotation end) {
        return (InteractionFragment)end.getReferences().get(0);
    }

    public NamedElement getEndOwner(EAnnotation end) {
        EList refs = end.getReferences();
        int index = 0;
        if (refs.size() > 1) {
            index = 1;
        }
        return (NamedElement)refs.get(index);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isStartingEnd(EAnnotation end) {
        InteractionFragment interactionFragment = this.getEndFragment(end);
        if (interactionFragment instanceof MessageOccurrenceSpecification) {
            void occurrence;
            MessageOccurrenceSpecification messageOccurrenceSpecification = (MessageOccurrenceSpecification)interactionFragment;
            MessageOccurrenceSpecification cfr_ignored_0 = (MessageOccurrenceSpecification)interactionFragment;
            boolean start = OccurrenceSpecificationHelper.isExecutionStartOccurrence((OccurrenceSpecification)occurrence);
            boolean finish = OccurrenceSpecificationHelper.isExecutionFinishOccurrence((OccurrenceSpecification)occurrence);
            if (start || finish) {
                return start;
            }
        }
        return START_ANNOTATION_SOURCE.equals(end.getSource());
    }

    /*
     * WARNING - void declaration
     */
    public boolean isFinishingEnd(EAnnotation end) {
        InteractionFragment interactionFragment = this.getEndFragment(end);
        if (interactionFragment instanceof MessageOccurrenceSpecification) {
            void occurrence;
            MessageOccurrenceSpecification messageOccurrenceSpecification = (MessageOccurrenceSpecification)interactionFragment;
            MessageOccurrenceSpecification cfr_ignored_0 = (MessageOccurrenceSpecification)interactionFragment;
            boolean start = OccurrenceSpecificationHelper.isExecutionStartOccurrence((OccurrenceSpecification)occurrence);
            boolean finish = OccurrenceSpecificationHelper.isExecutionFinishOccurrence((OccurrenceSpecification)occurrence);
            if (start || finish) {
                return finish;
            }
        }
        return FINISH_ANNOTATION_SOURCE.equals(end.getSource());
    }

    public EAnnotation getStartingEnd(Element element) {
        return this.getEnd(element, START_ANNOTATION_SOURCE);
    }

    public EAnnotation getFinishingEnd(Element element) {
        return this.getEnd(element, FINISH_ANNOTATION_SOURCE);
    }

    /*
     * WARNING - void declaration
     */
    private EAnnotation getEnd(Element element, String endId) {
        Element element2;
        Objects.requireNonNull(element);
        EAnnotation result = null;
        if (FINISH_ANNOTATION_SOURCE.equals(endId) && (element2 = element) instanceof InteractionOperand) {
            void operand;
            InteractionOperand interactionOperand = (InteractionOperand)element2;
            InteractionOperand cfr_ignored_0 = (InteractionOperand)element2;
            Element element3 = operand.getOwner();
            if (element3 instanceof CombinedFragment) {
                void owner;
                CombinedFragment combinedFragment = (CombinedFragment)element3;
                CombinedFragment cfr_ignored_1 = (CombinedFragment)element3;
                int index = owner.getOperands().indexOf((Object)operand);
                result = index == owner.getOperands().size() - 1 ? this.getFinishingEnd((Element)owner) : this.getStartingEnd((Element)owner.getOperands().get(index + 1));
                return result;
            }
        }
        InteractionFragment semanticEnd = this.getSemanticEnd(endId, element);
        boolean ignoreId = element instanceof ExecutionSpecification;
        Interaction rootInteraction = UML_HELPER.getOwningInteraction(element);
        for (EAnnotation end : this.getEndsOrdering(rootInteraction)) {
            boolean matchingId;
            boolean bl = matchingId = ignoreId || endId.equals(end.getSource());
            if (!matchingId || this.getEndFragment(end) != semanticEnd) continue;
            result = end;
            break;
        }
        return result;
    }

    private InteractionFragment getSemanticEnd(String source, Element element) {
        InteractionFragment result = null;
        if (START_ANNOTATION_SOURCE.equals(source)) {
            result = UML_HELPER.getSemanticStart(element);
        } else if (FINISH_ANNOTATION_SOURCE.equals(source)) {
            result = UML_HELPER.getSemanticFinish(element);
        }
        return result;
    }

    public List<EObject> getEndsOrdering(Interaction interaction, List<EObject> eventEnds) {
        ArrayList<EAnnotation> result = new ArrayList<EAnnotation>(this.getEndsOrdering(interaction));
        result.retainAll(eventEnds);
        return result;
    }

    public List<EAnnotation> getEndsOrdering(Interaction interaction) {
        List result = (List)this.getOrderingAnnotation(interaction).getContents();
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isValidOrderingContent(EObject eObject) {
        boolean result = false;
        EObject eObject2 = eObject;
        if (eObject2 instanceof EAnnotation) {
            Object object;
            void annotation;
            EAnnotation eAnnotation = (EAnnotation)eObject2;
            EAnnotation cfr_ignored_0 = (EAnnotation)eObject2;
            if (!annotation.getReferences().isEmpty() && (object = annotation.getReferences().get(0)) instanceof InteractionFragment) {
                void head;
                InteractionFragment interactionFragment = (InteractionFragment)object;
                InteractionFragment cfr_ignored_1 = (InteractionFragment)object;
                result = head instanceof MessageOccurrenceSpecification || head instanceof ExecutionOccurrenceSpecification ? annotation.getReferences().size() == 2 : true;
            }
        }
        return result;
    }

    private EAnnotation getOrderingAnnotation(Interaction interaction) {
        return interaction.getEAnnotation(ORDERING_ANNOTATION_SOURCE);
    }

    public Element findIncludingFragment(InteractionFragment element) {
        ArrayDeque stack = new ArrayDeque();
        Lifeline covered = UML_HELPER.getCoveredLifeline(element);
        this.iterateCoveredFragments(covered, (end, current) -> {
            boolean found = element == this.getEndFragment((EAnnotation)end);
            boolean keepOn = true;
            if (this.isStartingEnd((EAnnotation)end) && SequenceDiagramOrderServices.isIncludingFragment(current)) {
                stack.push(current);
            } else if (!found && this.isFinishingEnd((EAnnotation)end) && SequenceDiagramOrderServices.isIncludingFragment(current)) {
                if (stack.isEmpty()) {
                    keepOn = false;
                } else {
                    stack.pop();
                }
            }
            return keepOn && !found;
        });
        if (stack.isEmpty()) {
            return covered;
        }
        return (Element)stack.peek();
    }

    public Interaction refreshEndsModel(Interaction root) {
        EAnnotation ordering = this.getOrderingAnnotation(root);
        if (ordering == null) {
            ordering = root.createEAnnotation(ORDERING_ANNOTATION_SOURCE);
        }
        List<EObject> invalidOrderingContent = ordering.getContents().stream().filter(content -> !this.isValidOrderingContent((EObject)content)).toList();
        EcoreUtil.deleteAll(invalidOrderingContent, (boolean)false);
        return root;
    }

    private void iterateCoveredFragments(Lifeline covered, BiPredicate<EAnnotation, Element> continuingTask) {
        for (EAnnotation end : this.getEndsOrdering(covered.getInteraction())) {
            if (UML_HELPER.getCoveredLifeline(this.getEndFragment(end)) == covered && !continuingTask.test(end, (Element)this.getIncludingFragment(end))) break;
        }
    }

    public <T extends InteractionFragment> Collection<T> selectIncludedFragments(NamedElement parent, Class<T> type) {
        FragmentSearch search = this.createFragmentSearch(parent, type);
        this.iterateCoveredFragments(UML_HELPER.getCoveredLifeline(parent), (end, current) -> {
            if (this.isStartingEnd((EAnnotation)end)) {
                search.selectOnStart((Element)current);
            } else if (this.isFinishingEnd((EAnnotation)end) && search.isSelectionOver((Element)current)) {
                return false;
            }
            return true;
        });
        return search.result;
    }

    private <T> FragmentSearch<T> createFragmentSearch(NamedElement parent, Class<T> type) {
        int initialDepth = -1;
        if (parent == UML_HELPER.getCoveredLifeline(parent)) {
            initialDepth = 0;
        }
        return new FragmentSearch<T>(parent, type, new int[]{initialDepth}, new ArrayList());
    }

    private static boolean isIncludingFragment(Element element) {
        return element instanceof ExecutionSpecification;
    }

    /*
     * WARNING - void declaration
     */
    private InteractionFragment getIncludingFragment(EAnnotation end) {
        InteractionFragment element = this.getEndFragment(end);
        ExecutionSpecification result = null;
        InteractionFragment interactionFragment = element;
        if (interactionFragment instanceof MessageOccurrenceSpecification) {
            void occurrence;
            MessageOccurrenceSpecification messageOccurrenceSpecification = (MessageOccurrenceSpecification)interactionFragment;
            MessageOccurrenceSpecification cfr_ignored_0 = (MessageOccurrenceSpecification)interactionFragment;
            result = SequenceDiagramUMLHelper.getAssociatedExecution((OccurrenceSpecification)occurrence);
        } else {
            NamedElement namedElement = this.getEndOwner(end);
            if (namedElement instanceof InteractionFragment) {
                void fragment;
                InteractionFragment interactionFragment2 = (InteractionFragment)namedElement;
                InteractionFragment cfr_ignored_1 = (InteractionFragment)namedElement;
                result = fragment;
            }
        }
        return result;
    }

    public EAnnotation findOccurrenceEnd(OccurrenceSpecification element) {
        Interaction owner = UML_HELPER.getOwningInteraction((Element)element);
        if (element != null && owner != null) {
            for (EAnnotation end : this.getEndsOrdering(owner)) {
                if (element != this.getEndFragment(end)) continue;
                return end;
            }
        }
        return null;
    }

    private record FragmentSearch<T>(NamedElement parent, Class<T> type, int[] depth, List<T> result) {
        void selectOnStart(Element current) {
            if (current == this.parent) {
                if (this.depth[0] == -1) {
                    this.depth[0] = 0;
                }
            } else if (this.depth[0] >= 0) {
                if (this.depth[0] == 0 && this.type.isInstance(current)) {
                    this.result.add(this.type.cast(current));
                }
                if (SequenceDiagramOrderServices.isIncludingFragment(current)) {
                    this.depth[0] = this.depth[0] + 1;
                }
            }
        }

        boolean isSelectionOver(Element current) {
            if (current == this.parent || this.depth[0] == 0 && SequenceDiagramOrderServices.isIncludingFragment(current)) {
                return true;
            }
            if (this.depth[0] > 0 && SequenceDiagramOrderServices.isIncludingFragment(current)) {
                this.depth[0] = this.depth[0] - 1;
            }
            return false;
        }
    }
}

