/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.uml.diagram.sequence.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.papyrus.sirius.uml.diagram.sequence.services.SequenceDiagramOrderServices;
import org.eclipse.papyrus.sirius.uml.diagram.sequence.services.utils.SequenceDiagramUMLHelper;
import org.eclipse.papyrus.uml.domain.services.UMLHelper;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.DurationConstraint;
import org.eclipse.uml2.uml.DurationObservation;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.InteractionUse;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.StateInvariant;
import org.eclipse.uml2.uml.TimeConstraint;
import org.eclipse.uml2.uml.TimeObservation;

public class SequenceDiagramSemanticCandidatesServices {
    private final SequenceDiagramOrderServices orderServices = new SequenceDiagramOrderServices();
    private final SequenceDiagramUMLHelper umlHelper = new SequenceDiagramUMLHelper();

    public Collection<Lifeline> getLifelineCandidates(Interaction interaction) {
        return interaction.getLifelines();
    }

    public Collection<StateInvariant> getStateInvariantCandidates(NamedElement owner) {
        return this.orderServices.selectIncludedFragments(owner, StateInvariant.class);
    }

    public Collection<ExecutionSpecification> getExecutionSpecificationCandidates(NamedElement owner) {
        return this.orderServices.selectIncludedFragments(owner, ExecutionSpecification.class);
    }

    public Collection<CombinedFragment> getCombinedFragmentCandidates(Interaction interaction) {
        return this.getAllFragments(CombinedFragment.class, interaction);
    }

    public Collection<InteractionOperand> getInteractionOperandCandidates(CombinedFragment combinedFragment) {
        return combinedFragment.getOperands();
    }

    public Collection<InteractionUse> getInteractionUseCandidates(Interaction interaction) {
        return this.getAllFragments(InteractionUse.class, interaction);
    }

    public Collection<Message> getLostFoundMessageCandidates(Interaction interaction) {
        return interaction.getMessages().stream().filter(msg -> msg.getReceiveEvent() == null || msg.getSendEvent() == null).toList();
    }

    public Collection<EAnnotation> getImplicitTimeElementCandidates(Interaction interaction) {
        Collection<EAnnotation> explicits = this.getTimeElementCandidates(interaction);
        return this.orderServices.getEndsOrdering(interaction).stream().filter(end -> this.orderServices.getEndFragment((EAnnotation)end) instanceof OccurrenceSpecification).filter(end -> !explicits.contains(end)).toList();
    }

    public Collection<EAnnotation> getTimeElementCandidates(Interaction interaction) {
        List<NamedElement> events = Stream.concat(this.collectTimeConstraintEvents(interaction), this.collectTimeObservationEvents(interaction)).toList();
        return this.orderServices.getEndsOrdering(interaction).stream().filter(end -> events.contains(this.orderServices.getEndFragment((EAnnotation)end))).toList();
    }

    public Stream<NamedElement> collectTimeConstraintEvents(Interaction interaction) {
        return interaction.getOwnedRules().stream().filter(TimeConstraint.class::isInstance).flatMap(constraint -> constraint.getConstrainedElements().stream()).filter(NamedElement.class::isInstance).map(NamedElement.class::cast);
    }

    private Stream<NamedElement> collectTimeObservationEvents(Interaction interaction) {
        return UMLHelper.getPackagedContainment((Element)interaction).stream().filter(TimeObservation.class::isInstance).map(TimeObservation.class::cast).map(TimeObservation::getEvent).filter(event -> this.isRelatedEvent((NamedElement)event, interaction));
    }

    public Collection<PackageableElement> getDurationElementCandidates(Interaction interaction, boolean single) {
        return Stream.concat(this.collectDurationConstraints(interaction, single), this.collectDurationObservations(interaction, single)).toList();
    }

    private Stream<DurationObservation> collectDurationObservations(Interaction interaction, boolean single) {
        return UMLHelper.getPackagedContainment((Element)interaction).stream().filter(DurationObservation.class::isInstance).map(DurationObservation.class::cast).filter(obs -> this.isObservationCandidate((DurationObservation)obs, interaction, single));
    }

    private boolean isObservationCandidate(DurationObservation observation, Interaction container, boolean single) {
        boolean matching = false;
        EList events = observation.getEvents();
        if (single && events.size() == 1) {
            matching = this.isRelatedEvent((NamedElement)events.get(0), container);
        } else if (!single && events.size() == 2) {
            matching = this.isRelatedEvent((NamedElement)events.get(0), container);
            matching = matching && this.isRelatedEvent((NamedElement)events.get(1), container);
        }
        return matching;
    }

    private boolean isRelatedEvent(NamedElement element, Interaction container) {
        return this.umlHelper.getOwningInteraction((Element)element) == container;
    }

    private Stream<DurationConstraint> collectDurationConstraints(Interaction parent, boolean single) {
        return parent.getOwnedRules().stream().filter(DurationConstraint.class::isInstance).map(DurationConstraint.class::cast).filter(rule -> this.isConstraintCandidate((DurationConstraint)rule, single));
    }

    private boolean isConstraintCandidate(DurationConstraint element, boolean single) {
        long count = element.getConstrainedElements().stream().filter(target -> target instanceof NamedElement && !(target instanceof Interaction)).count();
        return single && count == 1L || !single && count == 2L;
    }

    private <T extends InteractionFragment> Collection<T> getAllFragments(Class<T> type, Interaction interaction) {
        return this.collectAllFragments((List<InteractionFragment>)interaction.getFragments(), type, new ArrayList());
    }

    /*
     * WARNING - void declaration
     */
    private <T extends InteractionFragment> Collection<T> collectAllFragments(List<InteractionFragment> fragments, Class<T> type, Collection<T> results) {
        for (InteractionFragment fragment : fragments) {
            void combined;
            InteractionFragment interactionFragment;
            if (type.isInstance(fragment)) {
                results.add((InteractionFragment)type.cast(fragment));
            }
            if (!((interactionFragment = fragment) instanceof CombinedFragment)) continue;
            CombinedFragment cfr_ignored_0 = (CombinedFragment)interactionFragment;
            CombinedFragment cfr_ignored_1 = (CombinedFragment)interactionFragment;
            for (InteractionOperand operand : combined.getOperands()) {
                this.collectAllFragments((List<InteractionFragment>)operand.getFragments(), type, results);
            }
        }
        return results;
    }

    /*
     * WARNING - void declaration
     */
    public Collection<? extends Element> getSdLinkTargets(Element element) {
        EList result = Collections.emptyList();
        Element element2 = element;
        if (element2 instanceof Constraint) {
            void constraint;
            Constraint constraint2 = (Constraint)element2;
            Constraint cfr_ignored_0 = (Constraint)element2;
            result = constraint.getConstrainedElements();
        } else {
            Element element3 = element;
            if (element3 instanceof Comment) {
                void comment;
                Comment comment2 = (Comment)element3;
                Comment cfr_ignored_1 = (Comment)element3;
                result = comment.getAnnotatedElements();
            } else {
                Element element4 = element;
                if (element4 instanceof DurationObservation) {
                    void observation;
                    DurationObservation durationObservation = (DurationObservation)element4;
                    DurationObservation cfr_ignored_2 = (DurationObservation)element4;
                    result = observation.getEvents();
                }
            }
        }
        return result;
    }
}

