/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.junit.utils.rules;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.junit.utils.rules.ModelSetFixture;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class NoTransactionFixture
implements TestRule {
    private final ModelSetFixture modelSet;

    public NoTransactionFixture(ModelSetFixture modelSet) {
        this.modelSet = modelSet;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                final AtomicReference throwable = new AtomicReference();
                ((TransactionalEditingDomain)NoTransactionFixture.this.modelSet.getEditingDomain()).getCommandStack().execute((Command)new AbstractCommand(){

                    public void execute() {
                        try {
                            base.evaluate();
                        }
                        catch (Throwable t) {
                            throwable.set(t);
                        }
                    }

                    public void redo() {
                    }

                    protected boolean prepare() {
                        return true;
                    }
                });
                if (throwable.get() != null) {
                    throw (Throwable)throwable.get();
                }
            }
        };
    }

    public ResourceSet getResourceSet() {
        return this.modelSet.getResourceSet();
    }
}

