/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.junit.util.diagram;

import java.util.Optional;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.sirius.junit.util.diagram.AbstractSiriusDiagramTests;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.junit.Assert;

public abstract class AbstractSemanticDropSubNodeTests
extends AbstractSiriusDiagramTests {
    protected void dropElementToContainer(NamedElement semanticOwner, Element elementToDrop, String containerMappingType, String compartmentMappingType, String dropToolId, String expectedMappingType) {
        this.checkSiriusDiagramSynchronization(false);
        DSemanticDiagram siriusDiagram = this.fixture.getActiveSiriusDiagram();
        Assert.assertNotNull((Object)siriusDiagram);
        Assert.assertFalse((String)"The diagram must be unsynchronized to test drop", (boolean)siriusDiagram.isSynchronized());
        DNodeContainer containerNode = (DNodeContainer)this.getNodeFromDiagram(semanticOwner.getName(), containerMappingType);
        DDiagramElement createdElement = this.dropNodeInDNodeContainer(containerNode, compartmentMappingType, dropToolId, expectedMappingType, elementToDrop);
        String createdElementMappingName = createdElement.getDiagramElementMapping().getName();
        Assert.assertEquals((String)"The dropped element is not the expected one", (Object)expectedMappingType, (Object)createdElementMappingName);
    }

    protected void dropElementToSubContainers(NamedElement semanticOwner, Element elementToDrop, String containerMappingType, String compartmentMappingType, String dropToolId, String expectedMappingType) {
        this.checkSiriusDiagramSynchronization(false);
        DSemanticDiagram siriusDiagram = this.fixture.getActiveSiriusDiagram();
        Assert.assertNotNull((Object)siriusDiagram);
        Assert.assertFalse((String)"The diagram must be unsynchronized to test drop", (boolean)siriusDiagram.isSynchronized());
        Optional<DNodeContainer> optionalContainerNode = this.getElementsFromDiagramBySemanticName(semanticOwner.getName(), containerMappingType).stream().filter(DNodeContainer.class::isInstance).map(DNodeContainer.class::cast).findFirst();
        if (optionalContainerNode.isPresent()) {
            DDiagramElement createdElement = this.dropNodeInDNodeContainer(optionalContainerNode.get(), compartmentMappingType, dropToolId, expectedMappingType, elementToDrop);
            String createdElementMappingName = createdElement.getDiagramElementMapping().getName();
            Assert.assertEquals((String)"The dropped element is not the expected one", (Object)expectedMappingType, (Object)createdElementMappingName);
        } else {
            Assert.fail((String)"Impossible to find the container matching the given semantic owner and container mapping");
        }
    }

    private final DDiagramElement dropNodeInDNodeContainer(DNodeContainer containerNode, String compartmentMappingType, String dropToolId, String expectedMappingType, Element elementToBeDropped) {
        Diagram diagram = this.getDiagram();
        DDiagramElementContainer subNodeContainer = this.getDDiagramElementContainerInContainer(containerNode, compartmentMappingType);
        Assert.assertNotNull((String)NLS.bind((String)"We didn't find the compartment type {0}", (Object)compartmentMappingType), (Object)subNodeContainer);
        Assert.assertEquals((String)"The compartment must be empty", (long)0L, (long)subNodeContainer.getElements().size());
        DDiagram diagramRepresentation = (DDiagram)diagram.getElement();
        Object graphicalNodeContainer = null;
        graphicalNodeContainer = this.isBorderNode(expectedMappingType) ? containerNode : subNodeContainer;
        int intialElementNumber = graphicalNodeContainer.getElements().size();
        boolean result = this.fixture.applyContainerDropDescriptionTool(diagramRepresentation, dropToolId, (DragAndDropTarget)subNodeContainer, (EObject)elementToBeDropped);
        Assert.assertTrue((String)"The drop of element failed", (boolean)result);
        this.fixture.flushDisplayEvents();
        Assert.assertEquals((long)(intialElementNumber + 1), (long)graphicalNodeContainer.getElements().size());
        DDiagramElement createdElementRepresentation = (DDiagramElement)graphicalNodeContainer.getElements().get(0);
        Assert.assertEquals((String)"The mapping is not the expected one", (Object)expectedMappingType, (Object)createdElementRepresentation.getMapping().getName());
        Assert.assertEquals((String)"The created element representation must have 1 associated semantic element", (long)1L, (long)createdElementRepresentation.getSemanticElements().size());
        this.fixture.getEditingDomain().getCommandStack().undo();
        this.fixture.flushDisplayEvents();
        Assert.assertEquals((long)intialElementNumber, (long)graphicalNodeContainer.getElements().size());
        this.fixture.getEditingDomain().getCommandStack().redo();
        this.fixture.flushDisplayEvents();
        Assert.assertEquals((long)(intialElementNumber + 1), (long)graphicalNodeContainer.getElements().size());
        return (DDiagramElement)graphicalNodeContainer.getElements().get(0);
    }

    protected boolean isBorderNode(String elementToDropMappingType) {
        return false;
    }
}

