/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.customization.nattableconfiguration.helper;

import org.eclipse.papyrus.infra.nattable.model.nattable.nattableconfiguration.TableConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.DisplayStyle;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.NattablestylePackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.TableDisplayStyle;

public class TableConfigurationHelper {
    private final TableConfiguration configuration;
    private static final String NOT_YET_SUPPORTED = "not yet supported";
    public static final String EMPTY_STRING = "";
    public static final String AXIS_FLAT_STYLE = "Flat";
    public static final String AXIS_TREE_STYLE = "Tree";
    public static final String AXIS_COMPACT_TREE_STYLE = "Compact";
    public static final String AXIS_LARGE_TREE_STYLE = "Large";

    public TableConfigurationHelper(TableConfiguration configuration) {
        this.configuration = configuration;
    }

    public void setRowAxisAsFlat() {
        TableDisplayStyle displayStyle = (TableDisplayStyle)this.configuration.getStyle(NattablestylePackage.eINSTANCE.getTableDisplayStyle());
        if (displayStyle == null) {
            displayStyle = (TableDisplayStyle)this.configuration.createStyle(NattablestylePackage.eINSTANCE.getTableDisplayStyle());
        }
        displayStyle.setDisplayStyle(DisplayStyle.NORMAL);
    }

    public void setRowAxisAsCompactTree() {
        TableDisplayStyle displayStyle = (TableDisplayStyle)this.configuration.getStyle(NattablestylePackage.eINSTANCE.getTableDisplayStyle());
        if (displayStyle == null) {
            displayStyle = (TableDisplayStyle)this.configuration.createStyle(NattablestylePackage.eINSTANCE.getTableDisplayStyle());
        }
        displayStyle.setDisplayStyle(DisplayStyle.HIERARCHIC_SINGLE_TREE_COLUMN);
    }

    public void setRowAxisAsLargeTree() {
        TableDisplayStyle displayStyle = (TableDisplayStyle)this.configuration.getStyle(NattablestylePackage.eINSTANCE.getTableDisplayStyle());
        if (displayStyle == null) {
            displayStyle = (TableDisplayStyle)this.configuration.createStyle(NattablestylePackage.eINSTANCE.getTableDisplayStyle());
        }
        displayStyle.setDisplayStyle(DisplayStyle.HIERARCHIC_MULTI_TREE_COLUMN);
    }

    public void setRowAxisAsTree() {
        this.setRowAxisAsCompactTree();
    }

    public void setColumnAxisAsFlat() {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public void setColumnAxisAsCompactTree() {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public void setColumnAxisAsLargeTree() {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public void setColumnAxisAsTree() {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public Boolean isRowAxisFlat() {
        TableDisplayStyle displayStyle = (TableDisplayStyle)this.configuration.getStyle(NattablestylePackage.eINSTANCE.getTableDisplayStyle());
        Boolean returnedValue = null;
        if (displayStyle != null) {
            returnedValue = DisplayStyle.NORMAL.equals((Object)displayStyle.getDisplayStyle());
        }
        return returnedValue;
    }

    public Boolean isColumnAxisFlat() {
        return null;
    }

    public Boolean isRowAxisTree() {
        TableDisplayStyle displayStyle = (TableDisplayStyle)this.configuration.getStyle(NattablestylePackage.eINSTANCE.getTableDisplayStyle());
        Boolean returnedValue = null;
        if (displayStyle != null) {
            returnedValue = DisplayStyle.HIERARCHIC_SINGLE_TREE_COLUMN.equals((Object)displayStyle.getDisplayStyle()) || DisplayStyle.HIERARCHIC_MULTI_TREE_COLUMN.equals((Object)displayStyle.getDisplayStyle());
        }
        return returnedValue;
    }

    public Boolean isColumnAxisTree() {
        return null;
    }

    public Boolean isRowAxisCompactTree() {
        TableDisplayStyle displayStyle = (TableDisplayStyle)this.configuration.getStyle(NattablestylePackage.eINSTANCE.getTableDisplayStyle());
        Boolean returnedValue = null;
        if (displayStyle != null) {
            returnedValue = DisplayStyle.HIERARCHIC_SINGLE_TREE_COLUMN.equals((Object)displayStyle.getDisplayStyle());
        }
        return returnedValue;
    }

    public Boolean isColumnAxisCompactTree() {
        return null;
    }

    public Boolean isRowAxisLargeTree() {
        TableDisplayStyle displayStyle = (TableDisplayStyle)this.configuration.getStyle(NattablestylePackage.eINSTANCE.getTableDisplayStyle());
        Boolean returnedValue = null;
        if (displayStyle != null) {
            returnedValue = DisplayStyle.HIERARCHIC_MULTI_TREE_COLUMN.equals((Object)displayStyle.getDisplayStyle());
        }
        return returnedValue;
    }

    public Boolean isColumnAxisLargeTree() {
        return null;
    }

    public String getTableType() {
        String type = this.configuration.getType();
        if (type == null) {
            type = EMPTY_STRING;
        }
        return type;
    }

    public String getDefaultTableName() {
        String name = this.configuration.getName();
        if (name == null) {
            name = EMPTY_STRING;
        }
        return name;
    }

    public String getTableConfigurationDescription() {
        String description = this.configuration.getDescription();
        if (description == null) {
            description = EMPTY_STRING;
        }
        return description;
    }

    public TableConfiguration getTableConfiguration() {
        return this.configuration;
    }

    public void setDefaultTableName(String name) {
        this.configuration.setName(name);
    }

    public void setTableType(String type) {
        this.configuration.setType(type);
    }

    public void setTableIcon(String iconPath) {
        this.configuration.setIconPath(iconPath);
    }

    public void setTableConfigurationDescription(String description) {
        this.configuration.setDescription(description);
    }
}

