/**
 * Copyright (c) 2012-2013 Montages AG, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package impl.diagram.update;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.papyrus.gmf.codegen.xtend.annotations.MetaDef;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import xpt.Common;
import xpt.Common_qvto;

@Singleton
@SuppressWarnings("all")
public class domain2notation {
  @Inject
  @Extension
  private Common _common;

  @Inject
  @Extension
  private Common_qvto _common_qvto;

  @MetaDef
  public CharSequence DomainToNotationClassName(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("Domain2Notation");
    return _builder;
  }

  public CharSequence DomainToNotationClass(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _DomainToNotationClass_One2One = this.DomainToNotationClass_One2One(it);
    _builder.append(_DomainToNotationClass_One2One);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public CharSequence DomainToNotationClass_One2One_extendsList(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("extends java.util.HashMap<org.eclipse.emf.ecore.EObject, org.eclipse.gmf.runtime.notation.View>");
    return _builder;
  }

  public CharSequence DomainToNotationClass_One2One(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("    ");
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment, "    ");
    _builder.newLineIfNotEmpty();
    _builder.append("@SuppressWarnings(\"serial\")");
    _builder.newLine();
    _builder.append("protected static class ");
    CharSequence _DomainToNotationClassName = this.DomainToNotationClassName(it);
    _builder.append(_DomainToNotationClassName);
    _builder.append(" ");
    CharSequence _DomainToNotationClass_One2One_extendsList = this.DomainToNotationClass_One2One_extendsList(it);
    _builder.append(_DomainToNotationClass_One2One_extendsList);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.append("    ");
    CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_1, "    ");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public boolean containsDomainElement(org.eclipse.emf.ecore.EObject domainElement){");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return this.containsKey(domainElement);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_2 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_2, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public org.eclipse.gmf.runtime.notation.View getHinted(org.eclipse.emf.ecore.EObject domainEObject, String hint) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return this.get(domainEObject);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_3 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_3, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public void putView(org.eclipse.emf.ecore.EObject domainElement, org.eclipse.gmf.runtime.notation.View view) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (!containsKey(view.getElement()) ");
    {
      boolean _notEmpty = this._common_qvto.<String>notEmpty(it.getContainsShortcutsTo());
      if (_notEmpty) {
        _builder.append("|| !isShortcut(view)");
      }
    }
    _builder.append(") {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    _builder.append("this.put(domainElement, view);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence DomainToNotationClass_One2Many(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("    ");
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment, "    ");
    _builder.newLineIfNotEmpty();
    _builder.append("@SuppressWarnings({\"rawtypes\", \"unchecked\"})");
    _builder.newLine();
    _builder.append("protected static class ");
    CharSequence _DomainToNotationClassName = this.DomainToNotationClassName(it);
    _builder.append(_DomainToNotationClassName);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.append("    ");
    CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_1, "    ");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("private final java.util.HashMap myMap = new java.util.HashMap();");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("    ");
    CharSequence _generatedMemberComment_2 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_2, "    ");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public boolean containsDomainElement(org.eclipse.emf.ecore.EObject domainElement){");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return myMap.containsKey(domainElement);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    CharSequence _generatedMemberComment_3 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_3, "    ");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public boolean containsKey(org.eclipse.emf.ecore.EObject domainElement){");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return containsDomainElement(domainElement);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("    ");
    CharSequence _generatedMemberComment_4 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_4, "    ");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public void putView(org.eclipse.emf.ecore.EObject domainElement, org.eclipse.gmf.runtime.notation.View view){");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("Object viewOrList = myMap.get(domainElement);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (viewOrList instanceof org.eclipse.gmf.runtime.notation.View){");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("myMap.remove(domainElement);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("java.util.List<org.eclipse.gmf.runtime.notation.View> list = new java.util.LinkedList<org.eclipse.gmf.runtime.notation.View>();");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("list.add((org.eclipse.gmf.runtime.notation.View)viewOrList);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("myMap.put(domainElement, list);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("list.add(view);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("} else if (viewOrList instanceof java.util.List){");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("((java.util.List)viewOrList).add(view);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("myMap.put(domainElement, view);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("    ");
    CharSequence _generatedMemberComment_5 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_5, "    ");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public org.eclipse.gmf.runtime.notation.View get(org.eclipse.emf.ecore.EObject domainEObject){");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("Object viewOrList = myMap.get(domainEObject);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (viewOrList instanceof org.eclipse.gmf.runtime.notation.View){");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return (org.eclipse.gmf.runtime.notation.View)viewOrList;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (viewOrList instanceof java.util.List){");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("// preferring not-shortcut to shortcut -- important for cases when links arr to/from ");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("// the element that is additionally shortcutted to the same diagram");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("for (Object next : (java.util.List)viewOrList){");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("org.eclipse.gmf.runtime.notation.View nextView = (org.eclipse.gmf.runtime.notation.View)next;");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("if (nextView.getEAnnotation(\"Shortcut\") == null) { ");
    CharSequence _nonNLS = this._common.nonNLS(1);
    _builder.append(_nonNLS, "\t\t\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t\t");
    _builder.append("return nextView;");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return (org.eclipse.gmf.runtime.notation.View)((java.util.List)viewOrList).get(0);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("    ");
    CharSequence _generatedMemberComment_6 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_6, "    ");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public org.eclipse.gmf.runtime.notation.View getHinted(org.eclipse.emf.ecore.EObject domainEObject, String hint){");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (hint == null){");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return get(domainEObject);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("Object viewOrList = myMap.get(domainEObject);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (viewOrList instanceof org.eclipse.gmf.runtime.notation.View){");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("//no choice, will return what we have");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return (org.eclipse.gmf.runtime.notation.View)viewOrList;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (viewOrList instanceof java.util.List){ ");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("for (Object next : (java.util.List)viewOrList){");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("org.eclipse.gmf.runtime.notation.View nextView = (org.eclipse.gmf.runtime.notation.View)next;");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("if (hint.equals(nextView.getType())){");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("return nextView;");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("//hint not found -- return what we have");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return (org.eclipse.gmf.runtime.notation.View)((java.util.List)viewOrList).get(0);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
}
