/**
 * Copyright (c) 2013-2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 * 	Michael Golubev (Montages) - initial API and implementation
 * 	Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package xpt;

import com.google.inject.Singleton;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Singleton
@SuppressWarnings("all")
public class Common_qvto {
  public boolean oclIsKindOf(final Object obj, final Class<?> clazz) {
    return ((obj != null) && clazz.isInstance(obj));
  }

  public String lastSegment(final String qualifiedName) {
    return this.lastSegment(qualifiedName, ".");
  }

  public String withoutLastSegment(final String qualifiedName) {
    return this.withoutLastSegment(qualifiedName, ".");
  }

  public String lastSegment(final String qualifiedName, final String separator) {
    return IterableExtensions.<String>lastOrNull(((Iterable<String>)Conversions.doWrapArray(qualifiedName.split(Pattern.quote(separator)))));
  }

  public String withoutLastSegment(final String qualifiedName, final String separator) {
    String[] parts = qualifiedName.split(Pattern.quote(separator));
    final String[] _converted_parts = (String[])parts;
    final String[] _converted_parts_1 = (String[])parts;
    int _size = ((List<String>)Conversions.doWrapArray(_converted_parts_1)).size();
    int _minus = (_size - 1);
    return IterableExtensions.join(IterableExtensions.<String>take(((Iterable<String>)Conversions.doWrapArray(_converted_parts)), _minus), separator);
  }

  public String substringAfter(final String name, final String prefix) {
    boolean _startsWith = name.startsWith(prefix);
    boolean _not = (!_startsWith);
    if (_not) {
      throw new IllegalArgumentException(((("String " + name) + " does not startWith: ") + prefix));
    }
    return name.substring(prefix.length());
  }

  public void ERROR(final String msg) {
    throw new IllegalStateException(msg);
  }

  public <T extends Object> T notNullOf(final T a, final T b) {
    T _xifexpression = null;
    if ((a != null)) {
      _xifexpression = a;
    } else {
      _xifexpression = b;
    }
    return _xifexpression;
  }

  public boolean nullOrSpaces(final String text) {
    return ((text == null) || (text.trim().length() == 0));
  }

  public <T extends Object> boolean notEmpty(final Iterable<T> collection) {
    boolean _isEmpty = IterableExtensions.isEmpty(collection);
    return (!_isEmpty);
  }
}
