/**
 * Copyright (c) 2007, 2010, 2013, 2021 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 * Alexander Shatalin (Borland) - initial API and implementation
 * Michael Golubev (Montages) - #372479, #386838
 * Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : 1.4 Merge papyrus extension templates into codegen.xtend
 * Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : L1.2 clean up
 */
package xpt.editor;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import metamodel.MetaModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenChildNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCompartment;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenConstraint;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenContainerBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenExpressionInterpreter;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenExpressionProviderBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenExpressionProviderContainer;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenJavaExpressionProvider;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLink;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenTopLevelNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.LinkModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.TypeLinkModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.TypeModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ValueExpression;
import org.eclipse.papyrus.gmf.codegen.xtend.annotations.MetaDef;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;
import xpt.CodeStyle;
import xpt.Common;
import xpt.Common_qvto;
import xpt.diagram.editpolicies.LinkUtils_qvto;
import xpt.diagram.updater.Utils_qvto;
import xpt.expressions.getExpression;

@Singleton
@SuppressWarnings("all")
public class VisualIDRegistry {
  @Inject
  @Extension
  private Common _common;

  @Inject
  @Extension
  private Common_qvto _common_qvto;

  @Inject
  @Extension
  private Utils_qvto _utils_qvto;

  @Inject
  @Extension
  private LinkUtils_qvto _linkUtils_qvto;

  @Inject
  @Extension
  private MetaModel _metaModel;

  @Inject
  private CodeStyle xptCodeStyle;

  @Inject
  private MetaModel xptMetaModel;

  @Inject
  private getExpression xptGetExpression;

  @MetaDef
  public CharSequence getVisualIdMethodName(final GenDiagram xptSelf) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("getVisualID");
    return _builder;
  }

  @MetaDef
  public CharSequence getModelIDMethodName(final GenDiagram xptSelf) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("getModelID");
    return _builder;
  }

  @MetaDef
  public CharSequence getVisualIDMethodCall(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    _builder.append(".");
    CharSequence _visualIdMethodName = this.getVisualIdMethodName(it);
    _builder.append(_visualIdMethodName);
    return _builder;
  }

  @MetaDef
  public CharSequence getModelIDMethodCall(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    _builder.append(".");
    CharSequence _modelIDMethodName = this.getModelIDMethodName(it);
    _builder.append(_modelIDMethodName);
    return _builder;
  }

  /**
   * FIXME: static because its used from xpt.Common (also imported here), to avoid cyclic injection
   */
  @MetaDef
  public static CharSequence visualID(final GenCommonBase xptSelf) {
    StringConcatenation _builder = new StringConcatenation();
    String _editPartQualifiedClassName = xptSelf.getEditPartQualifiedClassName();
    _builder.append(_editPartQualifiedClassName);
    _builder.append(".VISUAL_ID");
    return _builder;
  }

  /**
   * FIXME: static because its used from xpt.Common (also imported here), to avoid cyclic injection
   */
  @MetaDef
  public static CharSequence modelID(final GenDiagram xptSelf) {
    StringConcatenation _builder = new StringConcatenation();
    String _editPartQualifiedClassName = xptSelf.getEditPartQualifiedClassName();
    _builder.append(_editPartQualifiedClassName);
    _builder.append(".MODEL_ID");
    return _builder;
  }

  /**
   * XXX looks like these methods would produce incorrect result for visualID of GenDiagram itself
   * check if getType() method shouldn't be fixed similar to getVisualID, i.e. map diagram's visual id to MODEL_ID instead plain String.valueOf()
   */
  @MetaDef
  public CharSequence typeMethodCall(final GenCommonBase xptSelf, final CharSequence visualIdVar) {
    StringConcatenation _builder = new StringConcatenation();
    String _visualIDRegistryQualifiedClassName = xptSelf.getDiagram().getVisualIDRegistryQualifiedClassName();
    _builder.append(_visualIDRegistryQualifiedClassName);
    _builder.append(".");
    CharSequence _typeMethodName = this.getTypeMethodName(xptSelf.getDiagram());
    _builder.append(_typeMethodName);
    _builder.append("(");
    _builder.append(visualIdVar);
    _builder.append(")");
    return _builder;
  }

  @MetaDef
  public CharSequence typeMethodCall(final GenCommonBase xptSelf) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _typeMethodCall = this.typeMethodCall(xptSelf, VisualIDRegistry.visualID(xptSelf).toString());
    _builder.append(_typeMethodCall);
    return _builder;
  }

  @MetaDef
  public CharSequence getTypeMethodName(final GenDiagram xptSelf) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("getType");
    return _builder;
  }

  @MetaDef
  public CharSequence runtimeTypedInstanceName(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("TYPED_INSTANCE");
    return _builder;
  }

  @MetaDef
  public CharSequence runtimeTypedInstanceCall(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    _builder.append(".");
    CharSequence _runtimeTypedInstanceName = this.runtimeTypedInstanceName(it);
    _builder.append(_runtimeTypedInstanceName);
    return _builder;
  }

  @MetaDef
  public CharSequence getDiagramVisualIDMethodName(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("getDiagramVisualID");
    return _builder;
  }

  @MetaDef
  public CharSequence getDiagramVisualIDMethodCall(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    _builder.append(".");
    CharSequence _diagramVisualIDMethodName = this.getDiagramVisualIDMethodName(it);
    _builder.append(_diagramVisualIDMethodName);
    return _builder;
  }

  @MetaDef
  public CharSequence getNodeVisualIDMethodName(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("getNodeVisualID");
    return _builder;
  }

  @MetaDef
  public CharSequence getNodeVisualIDMethodCall(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    _builder.append(".");
    CharSequence _nodeVisualIDMethodName = this.getNodeVisualIDMethodName(it);
    _builder.append(_nodeVisualIDMethodName);
    return _builder;
  }

  @MetaDef
  public CharSequence canCreateNodeMethodName(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("canCreateNode");
    return _builder;
  }

  @MetaDef
  public CharSequence canCreateNodeMethodCall(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    _builder.append(".");
    CharSequence _canCreateNodeMethodName = this.canCreateNodeMethodName(it);
    _builder.append(_canCreateNodeMethodName);
    return _builder;
  }

  @MetaDef
  public CharSequence getLinkWithClassVisualIDMethodCall(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    _builder.append(".");
    CharSequence _linkWithClassVisualIDMethodName = this.getLinkWithClassVisualIDMethodName(it);
    _builder.append(_linkWithClassVisualIDMethodName);
    return _builder;
  }

  @MetaDef
  public CharSequence getLinkWithClassVisualIDMethodName(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("getLinkWithClassVisualID");
    return _builder;
  }

  @MetaDef
  public CharSequence domainElementConstraintMethodName(final GenCommonBase it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("is");
    String _stringUniqueIdentifier = this._common.stringUniqueIdentifier(it);
    _builder.append(_stringUniqueIdentifier);
    return _builder;
  }

  @MetaDef
  public CharSequence checkNodeVisualIDMethodName(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("checkNodeVisualID");
    return _builder;
  }

  @MetaDef
  public CharSequence checkNodeVisualIDMethodCall(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    _builder.append(".");
    CharSequence _checkNodeVisualIDMethodName = this.checkNodeVisualIDMethodName(it);
    _builder.append(_checkNodeVisualIDMethodName);
    return _builder;
  }

  @MetaDef
  public CharSequence isCompartmentVisualIDMethodName(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("isCompartmentVisualID");
    return _builder;
  }

  @MetaDef
  public CharSequence isCompartmentVisualIDMethodCall(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    _builder.append(".");
    CharSequence _isCompartmentVisualIDMethodName = this.isCompartmentVisualIDMethodName(it);
    _builder.append(_isCompartmentVisualIDMethodName);
    return _builder;
  }

  @MetaDef
  public CharSequence isSemanticLeafVisualIDMethodName(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("isSemanticLeafVisualID");
    return _builder;
  }

  @MetaDef
  public CharSequence isSemanticLeafVisualIDMethodCall(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    _builder.append(".");
    CharSequence _isSemanticLeafVisualIDMethodName = this.isSemanticLeafVisualIDMethodName(it);
    _builder.append(_isSemanticLeafVisualIDMethodName);
    return _builder;
  }

  /**
   * [MG]: this set of def dispatch'es had been moved from xpt.editor.Utils.qvto as local for VisualIDRegistry
   */
  protected Iterable<GenCommonBase> _getEssentialVisualChildren(final GenCommonBase it) {
    return CollectionLiterals.<GenCommonBase>newLinkedList();
  }

  /**
   * [MG]: this set of def dispatch'es had been moved from xpt.editor.Utils.qvto as local for VisualIDRegistry
   */
  protected Iterable<GenCommonBase> _getEssentialVisualChildren(final GenLink it) {
    return Iterables.<GenCommonBase>filter(it.getLabels(), GenCommonBase.class);
  }

  /**
   * [MG]: this set of def dispatch'es had been moved from xpt.editor.Utils.qvto as local for VisualIDRegistry
   */
  protected Iterable<GenCommonBase> _getEssentialVisualChildren(final GenContainerBase it) {
    return Iterables.<GenCommonBase>filter(it.getContainedNodes(), GenCommonBase.class);
  }

  /**
   * [MG]: this set of def dispatch'es had been moved from xpt.editor.Utils.qvto as local for VisualIDRegistry
   */
  protected Iterable<GenCommonBase> _getEssentialVisualChildren(final GenNode it) {
    LinkedList<GenCommonBase> result = CollectionLiterals.<GenCommonBase>newLinkedList();
    result.addAll(it.getLabels());
    result.addAll(it.getCompartments());
    result.addAll(it.getContainedNodes());
    return result;
  }

  public Iterable<GenNode> getContainedSemanticNodes(final GenContainerBase container) {
    final Function1<GenNode, Boolean> _function = (GenNode node) -> {
      TypeModelFacet _modelFacet = node.getModelFacet();
      return Boolean.valueOf((null != _modelFacet));
    };
    return IterableExtensions.<GenNode>filter(container.getContainedNodes(), _function);
  }

  public CharSequence className(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    String _visualIDRegistryClassName = it.getVisualIDRegistryClassName();
    _builder.append(_visualIDRegistryClassName);
    return _builder;
  }

  public CharSequence packageName(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    String _packageName = it.getEditorGen().getEditor().getPackageName();
    _builder.append(_packageName);
    return _builder;
  }

  public CharSequence qualifiedClassName(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(".");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    return _builder;
  }

  public CharSequence fullPath(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }

  public CharSequence VisualIDRegistry(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _copyright = this._common.copyright(it.getDiagram().getEditorGen());
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("package ");
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedClassComment = this._common.generatedClassComment(
      (("This registry is used to determine which type of visual object should be\n" + 
        "created for the corresponding Diagram, Node, ChildNode or Link represented\n") + 
        "by a domain model object."));
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _attributes = this.attributes(it);
    _builder.append(_attributes, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _viewVisualID = this.getViewVisualID(it);
    _builder.append(_viewVisualID, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _modelID = this.getModelID(it);
    _builder.append(_modelID, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _visualID = this.getVisualID(it);
    _builder.append(_visualID, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _type = this.getType(it);
    _builder.append(_type, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _diagramVisualID = this.getDiagramVisualID(it);
    _builder.append(_diagramVisualID, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _nodeVisualID = this.getNodeVisualID(it);
    _builder.append(_nodeVisualID, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _canCreateNode = this.canCreateNode(it);
    _builder.append(_canCreateNode, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _linkWithClassVisualID = this.getLinkWithClassVisualID(it);
    _builder.append(_linkWithClassVisualID, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _isDiagram = this.isDiagram(it);
    _builder.append(_isDiagram, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _constraintMethods = this.constraintMethods(it);
    _builder.append(_constraintMethods, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _checkNodeVisualID = this.checkNodeVisualID(it);
    _builder.append(_checkNodeVisualID, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _isCompartmentVisualID = this.isCompartmentVisualID(it);
    _builder.append(_isCompartmentVisualID, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    String _isSemanticLeafVisualID = this.isSemanticLeafVisualID(it);
    _builder.append(_isSemanticLeafVisualID, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _runtimeTypedInstance = this.runtimeTypedInstance(it);
    _builder.append(_runtimeTypedInstance, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence attributes(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("// Uncomment for debug purpose ?");
    _builder.newLine();
    _builder.append("// /**");
    _builder.newLine();
    _builder.append("// * @generated");
    _builder.newLine();
    _builder.append("// */");
    _builder.newLine();
    _builder.append("// private static final String DEBUG_KEY = \"");
    String _iD = it.getEditorGen().getPlugin().getID();
    _builder.append(_iD);
    _builder.append("/debug/visualID\"; ");
    CharSequence _nonNLS = this._common.nonNLS(1);
    _builder.append(_nonNLS);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public CharSequence getViewVisualID(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public static String ");
    CharSequence _visualIdMethodName = this.getVisualIdMethodName(it);
    _builder.append(_visualIdMethodName);
    _builder.append("(org.eclipse.gmf.runtime.notation.View view) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("if (view instanceof org.eclipse.gmf.runtime.notation.Diagram) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (");
    CharSequence _modelID = VisualIDRegistry.modelID(it);
    _builder.append(_modelID, "\t\t");
    _builder.append(".equals(view.getType())) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    _builder.append("return ");
    CharSequence _visualID = VisualIDRegistry.visualID(it);
    _builder.append(_visualID, "\t\t\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t\t\t");
    CharSequence _unrecognizedVID = this.unrecognizedVID(it);
    _builder.append(_unrecognizedVID, "\t\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return ");
    CharSequence _visualIDMethodCall = this.getVisualIDMethodCall(it);
    _builder.append(_visualIDMethodCall, "\t");
    _builder.append("(view.getType());");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence getModelID(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public static String ");
    CharSequence _modelIDMethodName = this.getModelIDMethodName(it);
    _builder.append(_modelIDMethodName);
    _builder.append("(org.eclipse.gmf.runtime.notation.View view) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("org.eclipse.gmf.runtime.notation.View diagram = view.getDiagram();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("while (view != diagram) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.emf.ecore.EAnnotation annotation = view.getEAnnotation(\"Shortcut\"); ");
    CharSequence _nonNLS = this._common.nonNLS(1);
    _builder.append(_nonNLS, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("if (annotation != null) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return annotation.getDetails().get(\"modelID\"); ");
    CharSequence _nonNLS_1 = this._common.nonNLS(1);
    _builder.append(_nonNLS_1, "\t\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("view = (org.eclipse.gmf.runtime.notation.View) view.eContainer();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return diagram != null ? diagram.getType() : null;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence getVisualID(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public static String ");
    CharSequence _visualIdMethodName = this.getVisualIdMethodName(it);
    _builder.append(_visualIdMethodName);
    _builder.append("(String type) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("return type;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence getType(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public static String ");
    CharSequence _typeMethodName = this.getTypeMethodName(it);
    _builder.append(_typeMethodName);
    _builder.append("(String visualID) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("return visualID;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence getDiagramVisualID(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public static String ");
    CharSequence _diagramVisualIDMethodName = this.getDiagramVisualIDMethodName(it);
    _builder.append(_diagramVisualIDMethodName);
    _builder.append("(org.eclipse.emf.ecore.EObject domainElement) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("if (domainElement == null) {");
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _unrecognizedVID = this.unrecognizedVID(it);
    _builder.append(_unrecognizedVID, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return ");
    CharSequence _visualID = VisualIDRegistry.visualID(it);
    _builder.append(_visualID, "\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence returnVisualID(final GenCommonBase it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("if (");
    CharSequence _checkSemanticElement = this.checkSemanticElement(it);
    _builder.append(_checkSemanticElement);
    _builder.append(") {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("return ");
    CharSequence _visualID = VisualIDRegistry.visualID(it);
    _builder.append(_visualID, "\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  protected CharSequence _checkSemanticElement(final GenCommonBase it) {
    StringConcatenation _builder = new StringConcatenation();
    this._common_qvto.ERROR(("checkSemanticElement not supported for: " + it));
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _checkSemanticElement(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _checkDomainElementMetaclass = this.checkDomainElementMetaclass(it.getDomainDiagramElement());
    _builder.append(_checkDomainElementMetaclass);
    _builder.append(" && isDiagram(");
    CharSequence _CastEObject = this.xptMetaModel.CastEObject(it.getDomainDiagramElement(), "domainElement");
    _builder.append(_CastEObject);
    _builder.append(")");
    return _builder;
  }

  protected CharSequence _checkSemanticElement(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _checkDomainElementMetaclass = this.checkDomainElementMetaclass(it.getModelFacet().getMetaClass());
    _builder.append(_checkDomainElementMetaclass);
    CharSequence _checkDomainElementConstraints = this.checkDomainElementConstraints(it.getModelFacet(), it);
    _builder.append(_checkDomainElementConstraints);
    return _builder;
  }

  protected CharSequence _checkSemanticElement(final GenLink it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _checkSemanticElement = this.checkSemanticElement(it.getModelFacet(), it);
    _builder.append(_checkSemanticElement);
    return _builder;
  }

  public CharSequence checkDomainElementMetaclass(final GenClass it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _MetaClass = this.xptMetaModel.MetaClass(it);
    _builder.append(_MetaClass);
    _builder.append(".isSuperTypeOf(domainElement.eClass())");
    return _builder;
  }

  public CharSequence checkDomainElementConstraints(final TypeModelFacet it, final GenCommonBase commonBase) {
    StringConcatenation _builder = new StringConcatenation();
    {
      GenConstraint _modelElementSelector = it.getModelElementSelector();
      boolean _tripleNotEquals = (null != _modelElementSelector);
      if (_tripleNotEquals) {
        {
          if (((commonBase instanceof GenLink) || (!(it.getModelElementSelector().getProvider() instanceof GenJavaExpressionProvider)))) {
            _builder.append("&& ");
            CharSequence _domainElementConstraintMethodName = this.domainElementConstraintMethodName(commonBase);
            _builder.append(_domainElementConstraintMethodName);
            _builder.append("(");
            CharSequence _CastEObject = this._metaModel.CastEObject(it.getMetaClass(), "domainElement");
            _builder.append(_CastEObject);
            _builder.append(")");
            _builder.newLineIfNotEmpty();
          } else {
            _builder.append("&& ");
            CharSequence _domainElementConstraintMethodName_1 = this.domainElementConstraintMethodName(commonBase);
            _builder.append(_domainElementConstraintMethodName_1);
            _builder.append("(containerView, ");
            CharSequence _CastEObject_1 = this._metaModel.CastEObject(it.getMetaClass(), "domainElement");
            _builder.append(_CastEObject_1);
            _builder.append(")");
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    return _builder;
  }

  protected CharSequence _checkSemanticElement(final LinkModelFacet it, final GenLink genLink) {
    StringConcatenation _builder = new StringConcatenation();
    this._common_qvto.ERROR(("checkSemanticElement is supported only for TypeLinkModelFacet: " + it));
    return _builder;
  }

  protected CharSequence _checkSemanticElement(final TypeLinkModelFacet it, final GenLink genLink) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _checkDomainElementMetaclass = this.checkDomainElementMetaclass(it.getMetaClass());
    _builder.append(_checkDomainElementMetaclass);
    CharSequence _checkDomainElementConstraints = this.checkDomainElementConstraints(it, genLink);
    _builder.append(_checkDomainElementConstraints);
    return _builder;
  }

  public CharSequence getNodeVisualID(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public static String ");
    CharSequence _nodeVisualIDMethodName = this.getNodeVisualIDMethodName(it);
    _builder.append(_nodeVisualIDMethodName);
    _builder.append("(org.eclipse.gmf.runtime.notation.View containerView, org.eclipse.emf.ecore.EObject domainElement) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("if (domainElement == null) {");
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _unrecognizedVID = this.unrecognizedVID(it);
    _builder.append(_unrecognizedVID, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("String containerModelID = ");
    CharSequence _modelIDMethodCall = this.getModelIDMethodCall(it);
    _builder.append(_modelIDMethodCall, "\t");
    _builder.append("(containerView);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("if (!");
    CharSequence _modelID = VisualIDRegistry.modelID(it);
    _builder.append(_modelID, "\t");
    _builder.append(".equals(containerModelID)");
    {
      EList<String> _shortcutsProvidedFor = it.getShortcutsProvidedFor();
      for(final String spf : _shortcutsProvidedFor) {
        CharSequence _checkContainerModelID = this.checkContainerModelID(spf);
        _builder.append(_checkContainerModelID, "\t");
      }
    }
    _builder.append(") { ");
    CharSequence _nonNLS_All = this._common.nonNLS_All(it.getShortcutsProvidedFor());
    _builder.append(_nonNLS_All, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    CharSequence _unrecognizedVID_1 = this.unrecognizedVID(it);
    _builder.append(_unrecognizedVID_1, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("String containerVisualID;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (");
    CharSequence _modelID_1 = VisualIDRegistry.modelID(it);
    _builder.append(_modelID_1, "\t");
    _builder.append(".equals(containerModelID)) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("containerVisualID = ");
    CharSequence _visualIDMethodCall = this.getVisualIDMethodCall(it);
    _builder.append(_visualIDMethodCall, "\t\t");
    _builder.append("(containerView);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (containerView instanceof org.eclipse.gmf.runtime.notation.Diagram) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("containerVisualID = ");
    CharSequence _visualID = VisualIDRegistry.visualID(it);
    _builder.append(_visualID, "\t\t\t");
    _builder.append(";\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t\t\t");
    CharSequence _unrecognizedVID_2 = this.unrecognizedVID(it);
    _builder.append(_unrecognizedVID_2, "\t\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (containerVisualID != null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("switch (containerVisualID) {");
    _builder.newLine();
    {
      EList<GenContainerBase> _allContainers = it.getAllContainers();
      for(final GenContainerBase container : _allContainers) {
        _builder.append("\t\t\t");
        CharSequence _caseDomainContainerVisualID = this.caseDomainContainerVisualID(container);
        _builder.append(_caseDomainContainerVisualID, "\t\t\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _unrecognizedVID_3 = this.unrecognizedVID(it);
    _builder.append(_unrecognizedVID_3, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence caseDomainContainerVisualID(final GenContainerBase it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _notEmpty = this._common_qvto.<GenNode>notEmpty(this.getContainedSemanticNodes(it));
      if (_notEmpty) {
        CharSequence _caseVisualID = this.caseVisualID(it);
        _builder.append(_caseVisualID);
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        {
          Iterable<GenNode> _containedSemanticNodes = this.getContainedSemanticNodes(it);
          for(final GenNode node : _containedSemanticNodes) {
            CharSequence _returnVisualID = this.returnVisualID(node);
            _builder.append(_returnVisualID, "\t");
          }
        }
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("break;");
        _builder.newLine();
      }
    }
    return _builder;
  }

  public CharSequence canCreateNode(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public static boolean ");
    CharSequence _canCreateNodeMethodName = this.canCreateNodeMethodName(it);
    _builder.append(_canCreateNodeMethodName);
    _builder.append("(org.eclipse.gmf.runtime.notation.View containerView, String nodeVisualID) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("String containerModelID = ");
    CharSequence _modelIDMethodCall = this.getModelIDMethodCall(it);
    _builder.append(_modelIDMethodCall, "\t");
    _builder.append("(containerView);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("if (!");
    CharSequence _modelID = VisualIDRegistry.modelID(it);
    _builder.append(_modelID, "\t");
    _builder.append(".equals(containerModelID)");
    {
      EList<String> _shortcutsProvidedFor = it.getShortcutsProvidedFor();
      for(final String spf : _shortcutsProvidedFor) {
        CharSequence _checkContainerModelID = this.checkContainerModelID(spf);
        _builder.append(_checkContainerModelID, "\t");
      }
    }
    _builder.append(") { ");
    CharSequence _nonNLS_All = this._common.nonNLS_All(it.getShortcutsProvidedFor());
    _builder.append(_nonNLS_All, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("return false;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("String containerVisualID;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (");
    CharSequence _modelID_1 = VisualIDRegistry.modelID(it);
    _builder.append(_modelID_1, "\t");
    _builder.append(".equals(containerModelID)) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("containerVisualID = ");
    CharSequence _visualIDMethodCall = this.getVisualIDMethodCall(it);
    _builder.append(_visualIDMethodCall, "\t\t");
    _builder.append("(containerView);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (containerView instanceof org.eclipse.gmf.runtime.notation.Diagram) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("containerVisualID = ");
    CharSequence _visualID = VisualIDRegistry.visualID(it);
    _builder.append(_visualID, "\t\t\t");
    _builder.append(";\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return false;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (containerVisualID != null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("switch (containerVisualID) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    {
      final Function1<GenContainerBase, Boolean> _function = (GenContainerBase e) -> {
        return Boolean.valueOf(this._common_qvto.<GenCommonBase>notEmpty(this.getEssentialVisualChildren(e)));
      };
      Iterable<GenContainerBase> _filter = IterableExtensions.<GenContainerBase>filter(it.getAllContainers(), _function);
      for(final GenContainerBase container : _filter) {
        CharSequence _checkEssentialChildren = this.checkEssentialChildren(container);
        _builder.append(_checkEssentialChildren, "\t\t\t");
      }
    }
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    {
      final Function1<GenLink, Boolean> _function_1 = (GenLink l) -> {
        return Boolean.valueOf(this._common_qvto.<GenCommonBase>notEmpty(this.getEssentialVisualChildren(l)));
      };
      Iterable<GenLink> _filter_1 = IterableExtensions.<GenLink>filter(it.getLinks(), _function_1);
      for(final GenLink link : _filter_1) {
        CharSequence _checkEssentialChildren_1 = this.checkEssentialChildren(link);
        _builder.append(_checkEssentialChildren_1, "\t\t\t");
      }
    }
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return false;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence checkContainerModelID(final String someModelId) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(" ");
    _builder.append("&& !\"");
    _builder.append(someModelId, " ");
    _builder.append("\".equals(containerModelID)");
    return _builder;
  }

  public CharSequence checkEssentialChildren(final GenCommonBase it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _caseVisualID = this.caseVisualID(it);
    _builder.append(_caseVisualID);
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    {
      Iterable<GenCommonBase> _essentialVisualChildren = this.getEssentialVisualChildren(it);
      for(final GenCommonBase child : _essentialVisualChildren) {
        CharSequence _checkEssentialChild = this.checkEssentialChild(child);
        _builder.append(_checkEssentialChild, "\t");
      }
    }
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("break;");
    _builder.newLine();
    return _builder;
  }

  public CharSequence checkEssentialChild(final GenCommonBase it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("if (");
    CharSequence _visualID = VisualIDRegistry.visualID(it);
    _builder.append(_visualID);
    _builder.append(".equals(nodeVisualID)) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("return true;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence getLinkWithClassVisualID(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public static String ");
    CharSequence _linkWithClassVisualIDMethodName = this.getLinkWithClassVisualIDMethodName(it);
    _builder.append(_linkWithClassVisualIDMethodName);
    _builder.append("(org.eclipse.emf.ecore.EObject domainElement) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("if (domainElement == null) {");
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _unrecognizedVID = this.unrecognizedVID(it);
    _builder.append(_unrecognizedVID, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    {
      final Function1<GenLink, Boolean> _function = (GenLink l) -> {
        return Boolean.valueOf(this._linkUtils_qvto.isTypeLink(l));
      };
      Iterable<GenLink> _filter = IterableExtensions.<GenLink>filter(it.getLinks(), _function);
      for(final GenLink typeLink : _filter) {
        CharSequence _returnVisualID = this.returnVisualID(typeLink);
        _builder.append(_returnVisualID, "\t");
      }
    }
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _unrecognizedVID_1 = this.unrecognizedVID(it);
    _builder.append(_unrecognizedVID_1, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence isDiagram(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      GenClass _domainDiagramElement = it.getDomainDiagramElement();
      boolean _tripleNotEquals = (null != _domainDiagramElement);
      if (_tripleNotEquals) {
        _builder.append("// Uncomment for debug purpose ?");
        _builder.newLine();
        _builder.append("// /**");
        _builder.newLine();
        _builder.append("// * User can change implementation of this method to handle some specific");
        _builder.newLine();
        _builder.append("// * situations not covered by default logic.");
        _builder.newLine();
        _builder.append("// *");
        _builder.newLine();
        _builder.append("// * @generated");
        _builder.newLine();
        _builder.append("// */");
        _builder.newLine();
        _builder.append("// private static boolean isDiagram(Package element) {");
        _builder.newLine();
        _builder.append("// return true;");
        _builder.newLine();
        _builder.append("// }");
        _builder.newLine();
      }
    }
    return _builder;
  }

  /**
   * Support for extra contstraints to check about model element.
   * Includes expression fields for interpreted constrains (like ocl or regexp).
   * For each model element that has an associated constraint, there's a method is<DomainElement>_<UID>()
   * that performs extra specification as defined by value expression
   * 
   * FIXME don't use static fields, replace with instance/separate cache (e.g. accessible from Activator)
   */
  public CharSequence constraintMethods(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      GenExpressionProviderContainer _expressionProviders = it.getEditorGen().getExpressionProviders();
      boolean _tripleNotEquals = (null != _expressionProviders);
      if (_tripleNotEquals) {
        {
          final Function1<GenTopLevelNode, Boolean> _function = (GenTopLevelNode n) -> {
            boolean _isSansDomain = n.isSansDomain();
            return Boolean.valueOf((!_isSansDomain));
          };
          final Function1<GenTopLevelNode, Boolean> _function_1 = (GenTopLevelNode n) -> {
            GenConstraint _modelElementSelector = n.getModelFacet().getModelElementSelector();
            return Boolean.valueOf((_modelElementSelector != null));
          };
          Iterable<GenTopLevelNode> _filter = IterableExtensions.<GenTopLevelNode>filter(IterableExtensions.<GenTopLevelNode>filter(it.getTopLevelNodes(), _function), _function_1);
          for(final GenTopLevelNode topNode : _filter) {
            CharSequence _constraintMethod = this.constraintMethod(topNode);
            _builder.append(_constraintMethod);
          }
        }
        _builder.newLineIfNotEmpty();
        {
          final Function1<GenChildNode, Boolean> _function_2 = (GenChildNode n) -> {
            boolean _isSansDomain = n.isSansDomain();
            return Boolean.valueOf((!_isSansDomain));
          };
          final Function1<GenChildNode, Boolean> _function_3 = (GenChildNode n) -> {
            GenConstraint _modelElementSelector = n.getModelFacet().getModelElementSelector();
            return Boolean.valueOf((_modelElementSelector != null));
          };
          Iterable<GenChildNode> _filter_1 = IterableExtensions.<GenChildNode>filter(IterableExtensions.<GenChildNode>filter(it.getChildNodes(), _function_2), _function_3);
          for(final GenChildNode childNode : _filter_1) {
            CharSequence _constraintMethod_1 = this.constraintMethod(childNode);
            _builder.append(_constraintMethod_1);
          }
        }
        _builder.newLineIfNotEmpty();
        {
          final Function1<GenLink, Boolean> _function_4 = (GenLink n) -> {
            boolean _isSansDomain = n.isSansDomain();
            return Boolean.valueOf((!_isSansDomain));
          };
          Iterable<GenLink> _filter_2 = IterableExtensions.<GenLink>filter(it.getLinks(), _function_4);
          for(final GenLink link : _filter_2) {
            CharSequence _constraintMethod_2 = this.constraintMethod(link.getModelFacet(), link);
            _builder.append(_constraintMethod_2);
          }
        }
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }

  public CharSequence constraintMethod(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _domainElementConstraintMethod = this.domainElementConstraintMethod(it.getModelFacet().getModelElementSelector().getProvider(), it, it.getModelFacet().getModelElementSelector(), it.getModelFacet().getMetaClass());
    _builder.append(_domainElementConstraintMethod);
    return _builder;
  }

  protected CharSequence _constraintMethod(final LinkModelFacet it, final GenLink l) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }

  protected CharSequence _constraintMethod(final TypeLinkModelFacet it, final GenLink l) {
    StringConcatenation _builder = new StringConcatenation();
    {
      GenConstraint _modelElementSelector = it.getModelElementSelector();
      boolean _tripleNotEquals = (_modelElementSelector != null);
      if (_tripleNotEquals) {
        CharSequence _domainElementConstraintMethod = this.domainElementConstraintMethod(it.getModelElementSelector().getProvider(), l, it.getModelElementSelector(), it.getMetaClass());
        _builder.append(_domainElementConstraintMethod);
      }
    }
    return _builder;
  }

  protected CharSequence _domainElementConstraintMethod(final GenExpressionProviderBase it, final GenCommonBase diagramElement, final ValueExpression expression, final GenClass context) {
    StringConcatenation _builder = new StringConcatenation();
    this._common_qvto.ERROR(("Constraint method is not supported for " + it));
    return _builder;
  }

  protected CharSequence _domainElementConstraintMethod(final GenJavaExpressionProvider it, final GenCommonBase diagramElement, final ValueExpression expression, final GenClass context) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("\t");
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment, "\t");
    _builder.newLineIfNotEmpty();
    {
      if ((diagramElement instanceof GenLink)) {
        _builder.append("private static boolean ");
        CharSequence _domainElementConstraintMethodName = this.domainElementConstraintMethodName(diagramElement);
        _builder.append(_domainElementConstraintMethodName);
        _builder.append("(");
        CharSequence _QualifiedClassName = this._metaModel.QualifiedClassName(context);
        _builder.append(_QualifiedClassName);
        _builder.append(" domainElement) {");
        _builder.newLineIfNotEmpty();
      } else {
        _builder.append("private static boolean ");
        CharSequence _domainElementConstraintMethodName_1 = this.domainElementConstraintMethodName(diagramElement);
        _builder.append(_domainElementConstraintMethodName_1);
        _builder.append("(org.eclipse.gmf.runtime.notation.View containerView, ");
        CharSequence _QualifiedClassName_1 = this._metaModel.QualifiedClassName(context);
        _builder.append(_QualifiedClassName_1);
        _builder.append(" domainElement) {");
        _builder.newLineIfNotEmpty();
      }
    }
    {
      if ((it.isInjectExpressionBody() && ((expression.getBody() != null) && (expression.getBody().length() != 0)))) {
        String _body = expression.getBody();
        _builder.append(_body);
        _builder.newLineIfNotEmpty();
      } else {
        if ((it.isThrowException() || (it.isInjectExpressionBody() && ((expression.getBody() == null) || (expression.getBody().length() == 0))))) {
          _builder.append("// FIXME: implement this method ");
          _builder.newLine();
          _builder.append("// Ensure that you remove @generated or mark it @generated NOT");
          _builder.newLine();
          _builder.append("throw new java.lang.UnsupportedOperationException(\"No java implementation provided in \'");
          CharSequence _domainElementConstraintMethodName_2 = this.domainElementConstraintMethodName(diagramElement);
          _builder.append(_domainElementConstraintMethodName_2);
          _builder.append("\' operation\");");
          CharSequence _nonNLS = this._common.nonNLS();
          _builder.append(_nonNLS);
          _builder.newLineIfNotEmpty();
        } else {
          _builder.append("return false;");
          _builder.newLine();
        }
      }
    }
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  protected CharSequence _domainElementConstraintMethod(final GenExpressionInterpreter it, final GenCommonBase diagramElement, final ValueExpression expression, final GenClass context) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private static boolean ");
    CharSequence _domainElementConstraintMethodName = this.domainElementConstraintMethodName(diagramElement);
    _builder.append(_domainElementConstraintMethodName);
    _builder.append("(");
    CharSequence _QualifiedClassName = this.xptMetaModel.QualifiedClassName(context);
    _builder.append(_QualifiedClassName);
    _builder.append(" domainElement) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("Object result = ");
    CharSequence _expression = this.xptGetExpression.getExpression(it, expression, context);
    _builder.append(_expression, "\t");
    _builder.append(".evaluate(domainElement);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("return result instanceof Boolean && ((Boolean)result).booleanValue();");
    _builder.newLine();
    _builder.append("}\t\t\t");
    _builder.newLine();
    return _builder;
  }

  public CharSequence unrecognizedVID(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("return \"\"; ");
    CharSequence _nonNLS = this._common.nonNLS();
    _builder.append(_nonNLS);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public CharSequence checkNodeVisualID(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public static boolean ");
    CharSequence _checkNodeVisualIDMethodName = this.checkNodeVisualIDMethodName(it);
    _builder.append(_checkNodeVisualIDMethodName);
    _builder.append("(org.eclipse.gmf.runtime.notation.View containerView, org.eclipse.emf.ecore.EObject domainElement, String candidate) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("if (candidate == null){");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// unrecognized id is always bad");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return false;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("String basic = ");
    CharSequence _nodeVisualIDMethodName = this.getNodeVisualIDMethodName(it);
    _builder.append(_nodeVisualIDMethodName, "\t");
    _builder.append("(containerView, domainElement);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("return candidate.equals(basic);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence isCompartmentVisualID(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public static boolean ");
    CharSequence _isCompartmentVisualIDMethodName = this.isCompartmentVisualIDMethodName(it);
    _builder.append(_isCompartmentVisualIDMethodName);
    _builder.append("(String visualID) {");
    _builder.newLineIfNotEmpty();
    {
      boolean _notEmpty = this._common_qvto.<GenCompartment>notEmpty(it.getCompartments());
      if (_notEmpty) {
        _builder.append("\t");
        _builder.append("if (visualID != null) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("switch (visualID) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t\t");
        {
          EList<GenCompartment> _compartments = it.getCompartments();
          for(final GenCompartment compartment : _compartments) {
            CharSequence _caseVisualID = this.caseVisualID(compartment);
            _builder.append(_caseVisualID, "\t\t\t");
          }
        }
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t\t\t");
        _builder.append("return true;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.append("\t");
    _builder.append("return false;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public String isSemanticLeafVisualID(final GenDiagram it) {
    final Function1<GenNode, Boolean> _function = (GenNode n) -> {
      return Boolean.valueOf((IterableExtensions.isEmpty(this._utils_qvto.getSemanticChildren(n)) && IterableExtensions.<GenCompartment>forall(n.getCompartments(), ((Function1<GenCompartment, Boolean>) (GenCompartment c) -> {
        return Boolean.valueOf(IterableExtensions.isEmpty(this._utils_qvto.getSemanticChildren(c)));
      }))));
    };
    final Function1<GenNode, Integer> _function_1 = (GenNode n) -> {
      return Integer.valueOf(n.getVisualID());
    };
    List<GenNode> leafs = IterableExtensions.<GenNode, Integer>sortBy(IterableExtensions.<GenNode>filter(it.getAllNodes(), _function), _function_1);
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public static boolean ");
    CharSequence _isSemanticLeafVisualIDMethodName = this.isSemanticLeafVisualIDMethodName(it);
    _builder.append(_isSemanticLeafVisualIDMethodName);
    _builder.append("(String visualID) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("if (visualID != null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("switch (visualID) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    CharSequence _caseVisualID = this.caseVisualID(it);
    _builder.append(_caseVisualID, "\t\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t");
    _builder.append("return false;");
    _builder.newLine();
    {
      boolean _notEmpty = this._common_qvto.<GenNode>notEmpty(leafs);
      if (_notEmpty) {
        _builder.append("\t\t\t");
        {
          for(final GenNode leaf : leafs) {
            CharSequence _caseVisualID_1 = this.caseVisualID(leaf);
            _builder.append(_caseVisualID_1, "\t\t\t");
          }
        }
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("\t");
        _builder.append("return true;");
        _builder.newLine();
      }
    }
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return false;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder.toString();
  }

  public CharSequence runtimeTypedInstance(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public static final org.eclipse.papyrus.infra.gmfdiag.common.structure.DiagramStructure ");
    CharSequence _runtimeTypedInstanceName = this.runtimeTypedInstanceName(it);
    _builder.append(_runtimeTypedInstanceName);
    _builder.append(" = new org.eclipse.papyrus.infra.gmfdiag.common.structure.DiagramStructure() {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _overrideC = this.xptCodeStyle.overrideC(it);
    _builder.append(_overrideC, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public String ");
    CharSequence _visualIdMethodName = this.getVisualIdMethodName(it);
    _builder.append(_visualIdMethodName, "\t");
    _builder.append("(org.eclipse.gmf.runtime.notation.View view) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("return ");
    CharSequence _visualIDMethodCall = this.getVisualIDMethodCall(it);
    _builder.append(_visualIDMethodCall, "\t\t");
    _builder.append("(view);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_1, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _overrideC_1 = this.xptCodeStyle.overrideC(it);
    _builder.append(_overrideC_1, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public String ");
    CharSequence _modelIDMethodName = this.getModelIDMethodName(it);
    _builder.append(_modelIDMethodName, "\t");
    _builder.append("(org.eclipse.gmf.runtime.notation.View view) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("return ");
    CharSequence _modelIDMethodCall = this.getModelIDMethodCall(it);
    _builder.append(_modelIDMethodCall, "\t\t");
    _builder.append("(view);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_2 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_2, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _overrideC_2 = this.xptCodeStyle.overrideC(it);
    _builder.append(_overrideC_2, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public String ");
    CharSequence _nodeVisualIDMethodName = this.getNodeVisualIDMethodName(it);
    _builder.append(_nodeVisualIDMethodName, "\t");
    _builder.append("(org.eclipse.gmf.runtime.notation.View containerView, org.eclipse.emf.ecore.EObject domainElement) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("return ");
    CharSequence _nodeVisualIDMethodCall = this.getNodeVisualIDMethodCall(it);
    _builder.append(_nodeVisualIDMethodCall, "\t\t");
    _builder.append("(containerView, domainElement);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_3 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_3, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _overrideC_3 = this.xptCodeStyle.overrideC(it);
    _builder.append(_overrideC_3, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public boolean ");
    CharSequence _checkNodeVisualIDMethodName = this.checkNodeVisualIDMethodName(it);
    _builder.append(_checkNodeVisualIDMethodName, "\t");
    _builder.append("(org.eclipse.gmf.runtime.notation.View containerView, org.eclipse.emf.ecore.EObject domainElement, String candidate) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("return ");
    CharSequence _checkNodeVisualIDMethodCall = this.checkNodeVisualIDMethodCall(it);
    _builder.append(_checkNodeVisualIDMethodCall, "\t\t");
    _builder.append("(containerView, domainElement, candidate);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_4 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_4, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _overrideC_4 = this.xptCodeStyle.overrideC(it);
    _builder.append(_overrideC_4, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public boolean ");
    CharSequence _isCompartmentVisualIDMethodName = this.isCompartmentVisualIDMethodName(it);
    _builder.append(_isCompartmentVisualIDMethodName, "\t");
    _builder.append("(String visualID) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("return ");
    CharSequence _isCompartmentVisualIDMethodCall = this.isCompartmentVisualIDMethodCall(it);
    _builder.append(_isCompartmentVisualIDMethodCall, "\t\t");
    _builder.append("(visualID);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_5 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_5, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _overrideC_5 = this.xptCodeStyle.overrideC(it);
    _builder.append(_overrideC_5, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public boolean ");
    CharSequence _isSemanticLeafVisualIDMethodName = this.isSemanticLeafVisualIDMethodName(it);
    _builder.append(_isSemanticLeafVisualIDMethodName, "\t");
    _builder.append("(String visualID) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("return ");
    CharSequence _isSemanticLeafVisualIDMethodCall = this.isSemanticLeafVisualIDMethodCall(it);
    _builder.append(_isSemanticLeafVisualIDMethodCall, "\t\t");
    _builder.append("(visualID);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("};");
    _builder.newLine();
    return _builder;
  }

  public CharSequence caseVisualID(final GenCommonBase xptSelf) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("case ");
    CharSequence _visualID = VisualIDRegistry.visualID(xptSelf);
    _builder.append(_visualID);
    _builder.append(":");
    return _builder;
  }

  @XbaseGenerated
  public Iterable<GenCommonBase> getEssentialVisualChildren(final GenCommonBase it) {
    if (it instanceof GenNode) {
      return _getEssentialVisualChildren((GenNode)it);
    } else if (it instanceof GenLink) {
      return _getEssentialVisualChildren((GenLink)it);
    } else if (it instanceof GenContainerBase) {
      return _getEssentialVisualChildren((GenContainerBase)it);
    } else if (it != null) {
      return _getEssentialVisualChildren(it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }

  @XbaseGenerated
  public CharSequence checkSemanticElement(final GenCommonBase it) {
    if (it instanceof GenNode) {
      return _checkSemanticElement((GenNode)it);
    } else if (it instanceof GenDiagram) {
      return _checkSemanticElement((GenDiagram)it);
    } else if (it instanceof GenLink) {
      return _checkSemanticElement((GenLink)it);
    } else if (it != null) {
      return _checkSemanticElement(it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }

  @XbaseGenerated
  public CharSequence checkSemanticElement(final LinkModelFacet it, final GenLink genLink) {
    if (it instanceof TypeLinkModelFacet) {
      return _checkSemanticElement((TypeLinkModelFacet)it, genLink);
    } else if (it != null) {
      return _checkSemanticElement(it, genLink);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, genLink).toString());
    }
  }

  @XbaseGenerated
  public CharSequence constraintMethod(final LinkModelFacet it, final GenLink l) {
    if (it instanceof TypeLinkModelFacet) {
      return _constraintMethod((TypeLinkModelFacet)it, l);
    } else if (it != null) {
      return _constraintMethod(it, l);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, l).toString());
    }
  }

  @XbaseGenerated
  public CharSequence domainElementConstraintMethod(final GenExpressionProviderBase it, final GenCommonBase diagramElement, final ValueExpression expression, final GenClass context) {
    if (it instanceof GenExpressionInterpreter) {
      return _domainElementConstraintMethod((GenExpressionInterpreter)it, diagramElement, expression, context);
    } else if (it instanceof GenJavaExpressionProvider) {
      return _domainElementConstraintMethod((GenJavaExpressionProvider)it, diagramElement, expression, context);
    } else if (it != null) {
      return _domainElementConstraintMethod(it, diagramElement, expression, context);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, diagramElement, expression, context).toString());
    }
  }
}
