/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gef.Request;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.ui.editparts.BorderedBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.util.EditPartUtil;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.snap.BorderNodeSnapHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.snap.NodeSnapHelper;

public class DeferredSnapToGridCommand
extends AbstractTransactionalCommand {
    protected List<?> viewAdapters;
    protected IGraphicalEditPart containerEP;

    public DeferredSnapToGridCommand(TransactionalEditingDomain editingDomain, List<?> viewAdapters, IGraphicalEditPart containerEP) {
        super(editingDomain, "Deferred Snap to grid command", null);
        this.viewAdapters = viewAdapters;
        this.containerEP = containerEP;
    }

    public List getAffectedFiles() {
        View view;
        if (this.containerEP != null && (view = (View)this.containerEP.getModel()) != null) {
            IFile f = WorkspaceSynchronizer.getFile((Resource)view.eResource());
            return f != null ? Collections.singletonList(f) : Collections.EMPTY_LIST;
        }
        return super.getAffectedFiles();
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        RunnableWithResult<List<IGraphicalEditPart>> refreshRunnable = new RunnableWithResult<List<IGraphicalEditPart>>(){
            private IStatus status;
            private List<IGraphicalEditPart> result;

            public List<IGraphicalEditPart> getResult() {
                return this.result;
            }

            public void setStatus(IStatus status) {
                this.status = status;
            }

            public IStatus getStatus() {
                return this.status;
            }

            public void run() {
                DeferredSnapToGridCommand.this.containerEP.refresh();
                DeferredSnapToGridCommand.this.getContainerFigure().invalidate();
                DeferredSnapToGridCommand.this.getContainerFigure().validate();
                ArrayList<IGraphicalEditPart> editParts = new ArrayList<IGraphicalEditPart>(DeferredSnapToGridCommand.this.viewAdapters.size());
                Map epRegistry = DeferredSnapToGridCommand.this.containerEP.getRoot().getViewer().getEditPartRegistry();
                for (IAdaptable ad : DeferredSnapToGridCommand.this.viewAdapters) {
                    View view = (View)ad.getAdapter(View.class);
                    Object ep = epRegistry.get(view);
                    if (!(ep instanceof IGraphicalEditPart)) continue;
                    editParts.add((IGraphicalEditPart)ep);
                }
                if (editParts.isEmpty()) {
                    this.result = editParts;
                    return;
                }
                this.result = editParts;
            }
        };
        EditPartUtil.synchronizeRunnableToMainThread((IGraphicalEditPart)this.containerEP, (Runnable)refreshRunnable);
        List editParts = (List)refreshRunnable.getResult();
        if (editParts == null || editParts.isEmpty()) {
            return CommandResult.newOKCommandResult();
        }
        CompoundCommand cc = new CompoundCommand("Snap Command");
        for (IGraphicalEditPart current : editParts) {
            SnapToHelper snapHelper = (SnapToHelper)current.getAdapter(SnapToHelper.class);
            PrecisionRectangle boundsFigure = new PrecisionRectangle(current.getFigure().getBounds());
            current.getFigure().translateToAbsolute((Translatable)boundsFigure);
            PrecisionRectangle result = new PrecisionRectangle((Rectangle)boundsFigure);
            NodeSnapHelper nodeSnapHelper = current instanceof BorderedBorderItemEditPart ? new BorderNodeSnapHelper(snapHelper, (Rectangle)boundsFigure) : new NodeSnapHelper(snapHelper, (Rectangle)boundsFigure);
            ChangeBoundsRequest request = new ChangeBoundsRequest((Object)"move");
            request.setEditParts(Collections.singletonList(current));
            request.setSnapToEnabled(true);
            request.setLocation(boundsFigure.getLocation());
            nodeSnapHelper.snapPoint(request);
            request.setLocation(result.getLocation());
            cc.add(current.getCommand((Request)request));
        }
        if (!cc.isEmpty() && cc.canExecute()) {
            cc.execute();
        }
        return CommandResult.newOKCommandResult();
    }

    protected void cleanup() {
        this.containerEP = null;
        this.viewAdapters = null;
        super.cleanup();
    }

    protected IFigure getContainerFigure() {
        return this.containerEP.getFigure();
    }

    protected IGraphicalEditPart getContainerEP() {
        return this.containerEP;
    }

    protected List<?> getViewAdapters() {
        return this.viewAdapters;
    }

    public boolean canExecute() {
        return super.canExecute() && this.containerEP != null;
    }
}

