/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.nattable.stereotype.display.configuration;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultBooleanDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultDisplayConverter;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.editor.CheckBoxCellEditor;
import org.eclipse.nebula.widgets.nattable.edit.editor.ComboBoxCellEditor;
import org.eclipse.nebula.widgets.nattable.edit.editor.IComboBoxDataProvider;
import org.eclipse.nebula.widgets.nattable.painter.cell.ComboBoxPainter;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.papyrus.infra.nattable.celleditor.config.ICellAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.painter.CustomCheckBoxPainter;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.nattable.utils.NattableConfigAttributes;
import org.eclipse.uml2.uml.NamedElement;

public class StereotypeDisplayPropertiesCellEditorConfiguration
implements ICellAxisConfiguration {
    private static final String DEPTH_SEPARATOR = "::";

    public String getConfigurationId() {
        return "PapyrusStereotypeDisplayTreeTable";
    }

    public String getConfigurationDescription() {
        return "Cell configuration for Stereotype Tree Table";
    }

    public boolean handles(Table table, Object axisElement) {
        boolean handles = false;
        Object element = AxisUtils.getRepresentedElement((Object)axisElement);
        if (element instanceof String) {
            handles = ((String)element).startsWith("stereotype_display_properties:/");
        }
        return handles;
    }

    public void configureCellEditor(IConfigRegistry configRegistry, Object axis, String configLabel) {
        block16: {
            String suffixe;
            if (!(AxisUtils.getRepresentedElement((Object)axis) instanceof String)) break block16;
            String element = (String)AxisUtils.getRepresentedElement((Object)axis);
            switch (suffixe = element.substring("stereotype_display_properties:/".length(), element.length())) {
                case "isDisplayedInBraces": 
                case "isDisplayedInCompartment": 
                case "isDisplayedInComment": 
                case "isDisplayed": {
                    this.createCheckBox(configRegistry, configLabel);
                    break;
                }
                case "nameDepth": {
                    this.createCombo(configRegistry, configLabel);
                    break;
                }
            }
        }
    }

    protected void createCheckBox(IConfigRegistry configRegistry, String configLabel) {
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)new CustomCheckBoxPainter(), DisplayMode.NORMAL, configLabel);
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)new CheckBoxCellEditor(), DisplayMode.NORMAL, configLabel);
        configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new DefaultBooleanDisplayConverter(), DisplayMode.NORMAL, configLabel);
    }

    protected void createCombo(final IConfigRegistry configRegistry, String configLabel) {
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)new ComboBoxPainter(), DisplayMode.EDIT, configLabel);
        IComboBoxDataProvider p = new IComboBoxDataProvider(){

            public List<?> getValues(int columnIndex, int rowIndex) {
                ArrayList<String> values = new ArrayList<String>(2);
                values.add("none");
                INattableModelManager manager = (INattableModelManager)configRegistry.getConfigAttribute(NattableConfigAttributes.NATTABLE_MODEL_MANAGER_CONFIG_ATTRIBUTE, DisplayMode.NORMAL, new String[]{"nattable_model_manager_id"});
                Object row = manager.getRowElement(rowIndex);
                row = AxisUtils.getRepresentedElement((Object)row);
                if (row instanceof NamedElement) {
                    String qualifiedName = ((NamedElement)row).getQualifiedName();
                    String[] split = qualifiedName.split(StereotypeDisplayPropertiesCellEditorConfiguration.DEPTH_SEPARATOR);
                    int cpt = -1;
                    int i = 0;
                    while (i < split.length - 1) {
                        values.add(Integer.toString(cpt));
                        --cpt;
                        ++i;
                    }
                }
                values.add("full");
                return values;
            }
        };
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)new ComboBoxCellEditor(p), DisplayMode.EDIT, configLabel);
        configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new DefaultDisplayConverter(), DisplayMode.EDIT, configLabel);
    }
}

