/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.decoratormodel.properties.elements;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.ObservableList;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.core.resource.ResourceAdapter;
import org.eclipse.papyrus.infra.ui.util.UIUtil;
import org.eclipse.papyrus.infra.widgets.editors.AbstractEditor;
import org.eclipse.papyrus.infra.widgets.editors.ICommitListener;
import org.eclipse.papyrus.uml.decoratormodel.helper.DecoratorModelUtils;
import org.eclipse.papyrus.uml.decoratormodel.internal.resource.DecoratorModelIndex;
import org.eclipse.papyrus.uml.decoratormodel.internal.resource.DecoratorModelIndexEvent;
import org.eclipse.papyrus.uml.decoratormodel.internal.resource.IDecoratorModelIndexListener;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLPackage;

public class DecoratorModelsObservableList
extends ObservableList
implements ICommitListener,
IObserving {
    private final AtomicBoolean pendingCalculation = new AtomicBoolean();
    private Package package_;
    private TransactionalEditingDomain domain;
    private final List<Command> commands;
    private final ExecutorService realmExecutor;
    private final ResourceSetListener resourceSetListener;
    private final IDecoratorModelIndexListener indexListener;

    public DecoratorModelsObservableList(Package package_, TransactionalEditingDomain domain) {
        this(Realm.getDefault(), package_, domain);
    }

    public DecoratorModelsObservableList(Realm realm, Package package_, TransactionalEditingDomain domain) {
        super(realm, (List)Lists.newArrayList(), Object.class);
        this.package_ = package_;
        this.domain = domain;
        this.commands = Lists.newArrayListWithExpectedSize((int)1);
        this.realmExecutor = UIUtil.createObservableExecutor((Realm)realm);
        this.resourceSetListener = new ResourceAdapter.Transactional(){
            private NotificationFilter packageFilter;

            protected NotificationFilter createFilter() {
                this.packageFilter = NotificationFilter.createFeatureFilter((EStructuralFeature)UMLPackage.Literals.PACKAGE__PROFILE_APPLICATION);
                return super.createFilter().or(this.packageFilter);
            }

            public void notifyChanged(Notification msg) {
                if (this.packageFilter.matches(msg)) {
                    DecoratorModelsObservableList.this.calculate();
                } else {
                    super.notifyChanged(msg);
                }
            }

            protected void handleResourceLoaded(Resource resource) {
                DecoratorModelsObservableList.this.calculate();
            }

            protected void handleResourceUnloaded(Resource resource) {
                DecoratorModelsObservableList.this.calculate();
            }
        };
        domain.addResourceSetListener(this.resourceSetListener);
        this.indexListener = new IDecoratorModelIndexListener(){

            public void indexChanged(DecoratorModelIndexEvent event) {
                DecoratorModelsObservableList.this.calculate();
            }
        };
        DecoratorModelIndex.getInstance().addIndexListener(this.indexListener);
        this.calculate();
    }

    public Package getObserved() {
        return this.package_;
    }

    public synchronized void dispose() {
        try {
            DecoratorModelIndex.getInstance().removeIndexListener(this.indexListener);
            if (this.domain != null) {
                this.domain.removeResourceSetListener(this.resourceSetListener);
            }
            if (!this.realmExecutor.isShutdown()) {
                this.realmExecutor.shutdownNow();
            }
        }
        finally {
            super.dispose();
        }
    }

    public void commit(AbstractEditor editor) {
        if (!this.commands.isEmpty()) {
            if (this.commands.size() == 1) {
                this.domain.getCommandStack().execute(this.commands.get(0));
            } else {
                this.domain.getCommandStack().execute((Command)new CompoundCommand(this.commands));
            }
            this.commands.clear();
        }
    }

    void calculate() {
        if (!this.pendingCalculation.compareAndSet(false, true) || this.isDisposed()) {
            return;
        }
        this.getRealm().exec(new Runnable(){

            @Override
            public void run() {
                DecoratorModelsObservableList.this.setStale(true);
            }
        });
        ListenableFuture decoratorModelURIs = DecoratorModelUtils.getUnloadedDecoratorModelsAsync((Package)this.package_);
        Futures.addCallback((ListenableFuture)decoratorModelURIs, (FutureCallback)new FutureCallback<Set<URI>>(){

            public void onSuccess(Set<URI> result) {
                if (DecoratorModelsObservableList.this.isDisposed() || DecoratorModelsObservableList.this.domain == null || DecoratorModelsObservableList.this.domain.getResourceSet() == null) {
                    return;
                }
                try {
                    HashSet newValue = Sets.newHashSet(result);
                    for (Resource next : DecoratorModelsObservableList.this.domain.getResourceSet().getResources()) {
                        if (!next.isLoaded()) continue;
                        newValue.remove(next.getURI());
                    }
                    for (Resource next : DecoratorModelUtils.getDecoratorModelProfileApplications((Package)DecoratorModelsObservableList.this.package_)) {
                        newValue.add(next.eResource());
                    }
                    ArrayList newList = Lists.newArrayList((Iterable)newValue);
                    DecoratorModelsObservableList.this.sort(newList);
                    DecoratorModelsObservableList.this.setStale(false);
                    DecoratorModelsObservableList.this.updateWrappedList(newList);
                }
                finally {
                    DecoratorModelsObservableList.this.pendingCalculation.set(false);
                }
            }

            public void onFailure(Throwable t) {
            }
        }, (Executor)this.realmExecutor);
    }

    void sort(List<?> list) {
        Collections.sort(list, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                URI uri1 = this.getURI(o1);
                URI uri2 = this.getURI(o2);
                return uri1.toString().compareTo(uri2.toString());
            }

            URI getURI(Object o) {
                return o instanceof Resource ? ((Resource)o).getURI() : (URI)o;
            }
        });
    }
}

