/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.properties.uml.services;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.sirius.properties.uml.services.MultipleSelectionViewpointExplorer;
import org.eclipse.papyrus.sirius.properties.uml.services.PropertiesCrudServices;

public class PropertiesMultipleSelectionServices {
    private static final String BOOLEAN_CLASS_NAME = "Boolean";
    private PropertiesCrudServices propertiesServices = new PropertiesCrudServices();

    public List<EStructuralFeature> getCommonFeatures(List<EObject> selectedObjects) {
        List<EStructuralFeature> commonFeatures = this.getBasicCommonFeatures(selectedObjects);
        Set<EClass> classifiers = selectedObjects.stream().map(object -> object.eClass()).collect(Collectors.toSet());
        commonFeatures = MultipleSelectionViewpointExplorer.getInstance().keepDisplayableFeatures(classifiers, commonFeatures);
        commonFeatures.sort(Comparator.comparing(feature -> feature.getName()));
        commonFeatures.sort(Comparator.comparing(feature -> feature.getEType().eClass().getName()));
        return commonFeatures;
    }

    private List<EStructuralFeature> getBasicCommonFeatures(List<EObject> selectedObjects) {
        ArrayList<EStructuralFeature> commonFeatures = new ArrayList<EStructuralFeature>();
        HashMap<EStructuralFeature, Integer> mapFeatures = new HashMap<EStructuralFeature, Integer>();
        for (EObject eObject : selectedObjects) {
            EList allFeatures = eObject.eClass().getEAllStructuralFeatures();
            for (EStructuralFeature feature : allFeatures) {
                if (!(feature.getEType() instanceof EEnum) && !(feature.getEType() instanceof EDataType)) continue;
                Integer occurences = mapFeatures.get(feature) != null ? (Integer)mapFeatures.get(feature) : Integer.valueOf(0);
                mapFeatures.put(feature, occurences + 1);
            }
        }
        for (Map.Entry entry : mapFeatures.entrySet()) {
            if (((Integer)entry.getValue()).intValue() != selectedObjects.size()) continue;
            commonFeatures.add((EStructuralFeature)entry.getKey());
        }
        return commonFeatures;
    }

    public String formatName(String name) {
        String formattedName = "";
        if (name != null) {
            int i = 0;
            while (i < name.length()) {
                Object currentChar = String.valueOf(name.charAt(i));
                if (i != 0 && currentChar == ((String)currentChar).toUpperCase()) {
                    currentChar = " " + ((String)currentChar).toLowerCase();
                }
                formattedName = formattedName.concat((String)currentChar);
                ++i;
            }
        }
        return formattedName;
    }

    public boolean isBoolean(EStructuralFeature feature) {
        boolean result = false;
        if (feature != null) {
            result = BOOLEAN_CLASS_NAME.equals(feature.getEType().getName());
        }
        return result;
    }

    public boolean isEnum(EStructuralFeature feature) {
        boolean result = false;
        if (feature != null) {
            result = feature.getEType() instanceof EEnum;
        }
        return result;
    }

    public Boolean getCheckboxMultipleValue(List<EObject> selectedObjects, EStructuralFeature feature) {
        HashSet<Boolean> choices = new HashSet<Boolean>();
        if (feature != null && selectedObjects != null) {
            for (EObject eObject : selectedObjects) {
                Object featureValue = eObject.eGet(feature);
                if (!(featureValue instanceof Boolean)) continue;
                choices.add((Boolean)featureValue);
            }
        }
        if (choices.size() == 1) {
            return (Boolean)choices.iterator().next();
        }
        return null;
    }

    public EEnumLiteral getSelectMultipleValue(List<EObject> selectedObjects, EStructuralFeature feature) {
        HashSet<EEnumLiteral> choices = new HashSet<EEnumLiteral>();
        if (feature != null && selectedObjects != null) {
            for (EObject eObject : selectedObjects) {
                Object featureValue = eObject.eGet(feature);
                if (!(featureValue instanceof Enumerator) || !(feature.getEType() instanceof EEnum)) continue;
                EEnum featureEnum = (EEnum)feature.getEType();
                Enumerator enumerator = (Enumerator)featureValue;
                choices.add(featureEnum.getEEnumLiteralByLiteral(enumerator.getLiteral()));
            }
        }
        if (choices.size() == 1) {
            return (EEnumLiteral)choices.iterator().next();
        }
        return null;
    }

    public boolean setAll(List<EObject> selectedObjects, EStructuralFeature feature, Object newValue) {
        boolean result = false;
        if (feature != null && selectedObjects != null) {
            result = true;
            for (EObject eObject : selectedObjects) {
                boolean bl = result = result && this.propertiesServices.set(eObject, feature.getName(), newValue);
            }
        }
        return result;
    }
}

