/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.providers;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.BehaviorExecutionSpecificationEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.util.BehaviorDisplayHelper;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;

public class DisplayBehaviorContributionItem
extends ContributionItem
implements IWorkbenchContribution {
    private IServiceLocator serviceLocator;

    public void initialize(IServiceLocator serviceLocator) {
        this.serviceLocator = serviceLocator;
    }

    public boolean isDynamic() {
        return true;
    }

    private ISelection getSelection() {
        if (this.serviceLocator == null) {
            return null;
        }
        ISelectionService selectionService = (ISelectionService)this.serviceLocator.getService(ISelectionService.class);
        if (selectionService != null) {
            return selectionService.getSelection();
        }
        return null;
    }

    public void fill(Menu menu, int index) {
        Object firstElement;
        super.fill(menu, index);
        ISelection selection = this.getSelection();
        if (selection == null || selection.isEmpty()) {
            return;
        }
        if (selection instanceof IStructuredSelection && (firstElement = ((IStructuredSelection)selection).getFirstElement()) instanceof BehaviorExecutionSpecificationEditPart) {
            final View view = ((BehaviorExecutionSpecificationEditPart)((Object)firstElement)).getNotationView();
            final TransactionalEditingDomain domain = ((BehaviorExecutionSpecificationEditPart)((Object)firstElement)).getEditingDomain();
            boolean displayBehavior = BehaviorDisplayHelper.shouldDisplayBehavior(view);
            if (displayBehavior) {
                MenuItem hide = new MenuItem(menu, 0, 0);
                hide.setText("Hide Behavior Label");
                hide.addListener(13, new Listener(){

                    public void handleEvent(Event event) {
                        Command cmd = BehaviorDisplayHelper.getChangeDisplayBehaviorCommand(domain, view, false);
                        domain.getCommandStack().execute(cmd);
                    }
                });
                new MenuItem(menu, 2, 1);
            } else {
                MenuItem show = new MenuItem(menu, 0, 0);
                show.setText("Display Behavior Label");
                show.addListener(13, new Listener(){

                    public void handleEvent(Event event) {
                        Command cmd = BehaviorDisplayHelper.getChangeDisplayBehaviorCommand(domain, view, true);
                        domain.getCommandStack().execute(cmd);
                    }
                });
                new MenuItem(menu, 2, 1);
            }
        }
    }
}

