/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.properties.services.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.papyrus.views.properties.services.Activator;
import org.eclipse.papyrus.views.properties.services.IPropertySheetPageProvider;
import org.eclipse.papyrus.views.properties.services.IPropertySheetPageProviderService;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.IPropertySheetPage;

public class PropertySheetPageProviderService
implements IPropertySheetPageProviderService {
    private String selectedRenderedID = null;
    private Map<String, Collection<IPropertySheetPageProvider>> map = new HashMap<String, Collection<IPropertySheetPageProvider>>();
    private static final String PROPERTY_SHEET_ID = "org.eclipse.ui.views.PropertySheet";
    private static final String PAPYRUS_EDITOR_ID = "org.eclipse.papyrus.infra.core.papyrusEditor";
    private Collection<String> renderersRequiringReload = new ArrayList<String>();
    private Map<IPropertySheetPage, IPropertySheetPageProvider> mapOfProvidedSheetPage = new HashMap<IPropertySheetPage, IPropertySheetPageProvider>();

    @Override
    public IPropertySheetPage createPropertySheetPage(Object realContributor, String viewID) {
        String selectedRender = this.getSelectedRenderer();
        IPropertySheetPage returnedPage = null;
        if (selectedRender != null) {
            returnedPage = this.createPropertySheetPage(realContributor, viewID, selectedRender);
        }
        if (returnedPage == null) {
            this.renderersRequiringReload.add(selectedRender);
        }
        if (returnedPage == null) {
            Iterator<String> iter = this.getAvailableRenderers().iterator();
            while (returnedPage == null && iter.hasNext()) {
                returnedPage = this.createPropertySheetPage(realContributor, viewID, iter.next());
            }
        }
        return returnedPage;
    }

    private IPropertySheetPage createPropertySheetPage(Object realContributor, String viewID, String rendererID) {
        IPropertySheetPage returnedPage = null;
        Collection<IPropertySheetPageProvider> values = this.map.get(rendererID);
        if (values != null) {
            Iterator<IPropertySheetPageProvider> iter = values.iterator();
            while (iter.hasNext() && returnedPage == null) {
                IPropertySheetPageProvider current = iter.next();
                if (!current.provides(realContributor, viewID)) continue;
                returnedPage = current.createPropertyPage(realContributor, viewID);
                this.mapOfProvidedSheetPage.put(returnedPage, current);
            }
        }
        return returnedPage;
    }

    @Override
    public void registerPropertySheetPageProvider(IPropertySheetPageProvider provider) {
        String renderer = provider.getRendererID();
        Collection<IPropertySheetPageProvider> coll = this.map.get(renderer);
        if (coll == null) {
            coll = new ArrayList<IPropertySheetPageProvider>();
            this.map.put(renderer, coll);
        }
        coll.add(provider);
        if (this.renderersRequiringReload.contains(renderer)) {
            this.reloadPropertyView();
        }
    }

    private void reloadPropertyView() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage wp = PropertySheetPageProviderService.this.getActivePage();
                IViewReference properties = PropertySheetPageProviderService.this.getPropertyView(wp);
                if (properties != null) {
                    for (IEditorReference ref : PropertySheetPageProviderService.this.getAllPapyrusEditors(wp)) {
                        IEditorPart p = ref.getEditor(false);
                        if (p == null || !p.isDirty()) continue;
                        p.doSave((IProgressMonitor)new NullProgressMonitor());
                    }
                    wp.hideView(properties);
                    try {
                        wp.showView(PropertySheetPageProviderService.PROPERTY_SHEET_ID);
                    }
                    catch (PartInitException e) {
                        Activator.log.error(e.getLocalizedMessage(), (Throwable)e);
                    }
                }
            }
        });
    }

    private IWorkbenchPage getActivePage() {
        IWorkbenchWindow activeWorkbench;
        IWorkbench wb = PlatformUI.getWorkbench();
        if (wb != null && (activeWorkbench = wb.getActiveWorkbenchWindow()) != null) {
            return activeWorkbench.getActivePage();
        }
        return null;
    }

    private IViewReference getPropertyView(IWorkbenchPage wp) {
        IViewReference[] iViewReferenceArray = wp.getViewReferences();
        int n = iViewReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference current = iViewReferenceArray[n2];
            if (PROPERTY_SHEET_ID.equals(current.getId())) {
                return current;
            }
            ++n2;
        }
        return null;
    }

    private Collection<IEditorReference> getAllPapyrusEditors(IWorkbenchPage wp) {
        ArrayList<IEditorReference> papyrus = new ArrayList<IEditorReference>();
        IEditorReference[] iEditorReferenceArray = wp.getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference current = iEditorReferenceArray[n2];
            if (PAPYRUS_EDITOR_ID.equals(current.getId())) {
                papyrus.add(current);
            }
            ++n2;
        }
        return papyrus;
    }

    @Override
    public String getSelectedRenderer() {
        String prefered = Activator.getDefault().getPreferenceStore().getString("PREFERRED_RENDERER");
        if (prefered != null && !prefered.isEmpty()) {
            return prefered;
        }
        if (this.selectedRenderedID == null && this.map.keySet().size() > 0) {
            ArrayList<String> keys = new ArrayList<String>(this.map.keySet());
            Collections.sort(keys);
            this.selectedRenderedID = (String)keys.get(0);
            Activator.getDefault().getPreferenceStore().setDefault("PREFERRED_RENDERER", this.selectedRenderedID);
        }
        return this.selectedRenderedID;
    }

    @Override
    public List<String> getAvailableRenderers() {
        ArrayList<String> keys = new ArrayList<String>(this.map.keySet());
        Collections.sort(keys);
        return keys;
    }

    @Override
    public void dispose(IPropertySheetPage page) {
        IPropertySheetPageProvider current = this.mapOfProvidedSheetPage.remove(page);
        if (current != null) {
            current.dispose(page);
        }
    }
}

