/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.product;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.wizards.product.ProductDefinitionOperation;
import org.eclipse.pde.internal.ui.wizards.product.ProductDefinitonWizardPage;
import org.eclipse.swt.widgets.Shell;

public class ProductDefinitionWizard
extends Wizard {
    private ProductDefinitonWizardPage fMainPage;
    private String fProductId;
    private String fPluginId;
    private String fApplication;
    private final IProduct fProduct;

    public ProductDefinitionWizard(IProduct product) {
        this.fProduct = product;
        this.setDefaultPageImageDescriptor(PDEPluginImages.DESC_DEFCON_WIZ);
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(PDEUIMessages.ProductDefinitionWizard_title);
    }

    public void addPages() {
        this.fMainPage = new ProductDefinitonWizardPage("product", this.fProduct);
        this.addPage((IWizardPage)this.fMainPage);
    }

    public boolean performFinish() {
        try {
            this.fProductId = this.fMainPage.getProductId();
            this.fPluginId = this.fMainPage.getDefiningPlugin();
            this.fApplication = this.fMainPage.getApplication();
            String newProductName = this.fMainPage.getProductName();
            if (newProductName != null) {
                this.fProduct.setName(newProductName);
            }
            this.getContainer().run(false, true, (IRunnableWithProgress)new ProductDefinitionOperation(this.fProduct, this.fPluginId, this.fProductId, this.fApplication, this.getContainer().getShell()));
        }
        catch (InvocationTargetException e) {
            MessageDialog.openError((Shell)this.getContainer().getShell(), (String)PDEUIMessages.ProductDefinitionWizard_error, (String)e.getTargetException().getMessage());
            return false;
        }
        catch (InterruptedException e) {
            return false;
        }
        return true;
    }

    public String getProductId() {
        return this.fPluginId + "." + this.fProductId;
    }

    public String getApplication() {
        return this.fApplication;
    }
}

