/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.policies;

import com.google.common.collect.HashMultiset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javafx.scene.Node;
import org.eclipse.gef.mvc.fx.models.FocusModel;
import org.eclipse.gef.mvc.fx.operations.AbstractCompositeOperation;
import org.eclipse.gef.mvc.fx.operations.ChangeContentsOperation;
import org.eclipse.gef.mvc.fx.operations.ChangeFocusOperation;
import org.eclipse.gef.mvc.fx.operations.DeselectOperation;
import org.eclipse.gef.mvc.fx.operations.ITransactionalOperation;
import org.eclipse.gef.mvc.fx.operations.ReverseUndoCompositeOperation;
import org.eclipse.gef.mvc.fx.parts.IContentPart;
import org.eclipse.gef.mvc.fx.parts.IRootPart;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.mvc.fx.policies.AbstractPolicy;
import org.eclipse.gef.mvc.fx.policies.ContentPolicy;
import org.eclipse.gef.mvc.fx.viewer.IViewer;

public class DeletionPolicy
extends AbstractPolicy {
    @Override
    protected ITransactionalOperation createOperation() {
        ReverseUndoCompositeOperation commit = new ReverseUndoCompositeOperation("Delete Content");
        IViewer viewer = this.getHost().getRoot().getViewer();
        IContentPart<? extends Node> currentlyFocusedPart = ((FocusModel)((Object)viewer.getAdapter(FocusModel.class))).getFocus();
        commit.add(new ChangeFocusOperation(viewer, currentlyFocusedPart));
        commit.add(new DeselectOperation(viewer, Collections.emptyList()));
        commit.add(new ReverseUndoCompositeOperation("Detach anchorages"));
        commit.add(new ReverseUndoCompositeOperation("Remove children"));
        return commit;
    }

    public void delete(IContentPart<? extends Node> contentPartToDelete) {
        this.checkInitialized();
        IViewer viewer = this.getHost().getRoot().getViewer();
        this.getDeselectOperation().getToBeDeselected().add(contentPartToDelete);
        FocusModel focusModel = (FocusModel)((Object)viewer.getAdapter(FocusModel.class));
        if (focusModel != null && focusModel.getFocus() == contentPartToDelete) {
            this.getUnfocusOperation().setNewFocused(null);
        }
        this.locallyExecuteOperation();
        for (IVisualPart anchored : HashMultiset.create(contentPartToDelete.getAnchoredsUnmodifiable())) {
            ContentPolicy anchoredContentPolicy;
            if (!(anchored instanceof IContentPart) || (anchoredContentPolicy = (ContentPolicy)anchored.getAdapter(ContentPolicy.class)) == null) continue;
            anchoredContentPolicy.init();
            for (String role : new ArrayList(anchored.getAnchoragesUnmodifiable().get(contentPartToDelete))) {
                anchoredContentPolicy.detachFromContentAnchorage(contentPartToDelete.getContent(), role);
            }
            ITransactionalOperation detachFromContentAnchoredOperation = anchoredContentPolicy.commit();
            if (detachFromContentAnchoredOperation == null || detachFromContentAnchoredOperation.isNoOp()) continue;
            this.getDetachContentAnchoragesOperation().add(detachFromContentAnchoredOperation);
        }
        if (contentPartToDelete.getParent() instanceof IRootPart) {
            ChangeContentsOperation changeContentsOperation = new ChangeContentsOperation(viewer);
            ArrayList<Object> newContents = new ArrayList<Object>((Collection<Object>)viewer.getContents());
            newContents.remove(contentPartToDelete.getContent());
            changeContentsOperation.setNewContents(newContents);
            this.getRemoveContentChildrenOperation().add(changeContentsOperation);
        } else {
            ContentPolicy parentContentPolicy = (ContentPolicy)contentPartToDelete.getParent().getAdapter(ContentPolicy.class);
            if (parentContentPolicy != null) {
                parentContentPolicy.init();
                parentContentPolicy.removeContentChild(contentPartToDelete.getContent());
                ITransactionalOperation removeFromParentOperation = parentContentPolicy.commit();
                if (removeFromParentOperation != null && !removeFromParentOperation.isNoOp()) {
                    this.getRemoveContentChildrenOperation().add(removeFromParentOperation);
                }
            }
        }
        this.locallyExecuteOperation();
        if (!contentPartToDelete.getAnchoredsUnmodifiable().isEmpty()) {
            throw new IllegalStateException("After deletion of <" + contentPartToDelete + "> there are still anchoreds remaining.");
        }
    }

    protected AbstractCompositeOperation getCompositeOperation() {
        return (AbstractCompositeOperation)this.getOperation();
    }

    protected DeselectOperation getDeselectOperation() {
        return (DeselectOperation)this.getCompositeOperation().getOperations().get(1);
    }

    private AbstractCompositeOperation getDetachContentAnchoragesOperation() {
        return (AbstractCompositeOperation)this.getCompositeOperation().getOperations().get(2);
    }

    private AbstractCompositeOperation getRemoveContentChildrenOperation() {
        return (AbstractCompositeOperation)this.getCompositeOperation().getOperations().get(3);
    }

    protected ChangeFocusOperation getUnfocusOperation() {
        return (ChangeFocusOperation)this.getCompositeOperation().getOperations().get(0);
    }
}

