/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.resize;

import java.util.ArrayList;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayerListener;
import org.eclipse.nebula.widgets.nattable.print.command.PrintEntireGridCommand;
import org.eclipse.nebula.widgets.nattable.print.command.TurnViewportOffCommand;
import org.eclipse.nebula.widgets.nattable.print.command.TurnViewportOnCommand;
import org.eclipse.nebula.widgets.nattable.resize.MaxCellBoundsHelper;
import org.eclipse.nebula.widgets.nattable.resize.command.MultiRowResizeCommand;
import org.eclipse.nebula.widgets.nattable.resize.event.ColumnResizeEvent;
import org.eclipse.nebula.widgets.nattable.resize.event.RowResizeEvent;
import org.eclipse.nebula.widgets.nattable.util.GCFactory;
import org.eclipse.nebula.widgets.nattable.util.IClientAreaProvider;
import org.eclipse.nebula.widgets.nattable.util.ObjectUtils;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class AutoResizeHelper {
    protected final ILayer layer;
    protected final IConfigRegistry configRegistry;
    protected Rectangle totalArea;
    protected Rectangle prevArea = null;
    protected IClientAreaProvider originalClientAreaProvider;
    protected volatile boolean resizedOnPrinting = true;
    protected ILayerListener resizeListener = event -> {
        if (!this.resizedOnPrinting && (event instanceof RowResizeEvent || event instanceof ColumnResizeEvent)) {
            this.resizedOnPrinting = true;
        }
    };
    protected IClientAreaProvider clientAreaProvider = () -> this.totalArea;
    private static AutoResizeRowRunnable activeRunnable;

    private AutoResizeHelper(ILayer layer, IConfigRegistry configRegistry) {
        this.layer = layer;
        this.configRegistry = configRegistry;
        this.originalClientAreaProvider = layer.getClientAreaProvider();
        this.calculateTotalArea();
    }

    public static void autoResize(ILayer layer, IConfigRegistry configRegistry) {
        AutoResizeHelper helper = new AutoResizeHelper(layer, configRegistry);
        helper.init();
        try {
            while (helper.resizedOnPrinting) {
                helper.resizedOnPrinting = false;
                helper.calculateTotalArea();
                helper.paintInMemory();
                helper.prevArea = helper.totalArea;
            }
        }
        finally {
            helper.restore();
        }
    }

    protected void paintInMemory() {
        Image tmpImage = new Image((Device)Display.getDefault(), 100, 100);
        GC tempGC = new GC((Drawable)tmpImage);
        try {
            if (this.prevArea != null) {
                Rectangle bottom = new Rectangle(0, this.prevArea.height, this.totalArea.width, this.totalArea.height - this.prevArea.height);
                if (bottom.height > 0) {
                    this.paintLayer(tempGC, bottom);
                }
                Rectangle right = new Rectangle(this.prevArea.width, 0, this.totalArea.width - this.prevArea.width, this.totalArea.height);
                if (right.width > 0) {
                    this.paintLayer(tempGC, right);
                }
            } else {
                this.paintLayer(tempGC, this.totalArea);
            }
        }
        finally {
            tempGC.dispose();
            tmpImage.dispose();
        }
    }

    protected void paintLayer(GC gc, Rectangle printBounds) {
        this.layer.getLayerPainter().paintLayer(this.layer, gc, 0, 0, printBounds, this.configRegistry);
    }

    protected void calculateTotalArea() {
        this.totalArea = new Rectangle(0, 0, this.layer.getWidth(), this.layer.getHeight());
    }

    protected void init() {
        this.layer.addLayerListener(this.resizeListener);
        this.layer.setClientAreaProvider(this.clientAreaProvider);
        this.layer.doCommand(new TurnViewportOffCommand());
        this.layer.doCommand(new PrintEntireGridCommand());
    }

    protected void restore() {
        this.layer.removeLayerListener(this.resizeListener);
        this.layer.setClientAreaProvider(this.originalClientAreaProvider);
        this.layer.doCommand(new TurnViewportOnCommand());
    }

    public static void autoResizeRows(NatTable natTable, ILayer rowLayer, ILayer bodyDataLayer) {
        AutoResizeHelper.cancelActiveRunnable();
        AutoResizeHelper.setActiveRunnable(new AutoResizeRowRunnable(natTable, rowLayer, bodyDataLayer), natTable.getDisplay());
    }

    private static synchronized void cancelActiveRunnable() {
        if (activeRunnable != null) {
            activeRunnable.cancelled = true;
        }
    }

    private static synchronized void setActiveRunnable(AutoResizeRowRunnable runnable, Display display) {
        activeRunnable = runnable;
        if (activeRunnable != null) {
            display.asyncExec((Runnable)activeRunnable);
        }
    }

    private static class AutoResizeRowRunnable
    implements Runnable {
        private final NatTable natTable;
        private final ILayer rowLayer;
        private final ILayer bodyDataLayer;
        private volatile boolean cancelled = false;

        public AutoResizeRowRunnable(NatTable natTable, ILayer rowLayer, ILayer bodyDataLayer) {
            this.natTable = natTable;
            this.rowLayer = rowLayer;
            this.bodyDataLayer = bodyDataLayer;
        }

        @Override
        public void run() {
            int rowCount = this.rowLayer.getRowCount();
            if (rowCount > 0) {
                int[] rowPos = new int[rowCount];
                int[] rowHeights = new int[rowCount];
                int i = 0;
                while (i < rowCount) {
                    rowPos[i] = this.rowLayer.getRowIndexByPosition(i);
                    rowHeights[i] = this.rowLayer.getRowHeightByPosition(i);
                    ++i;
                }
                if (this.cancelled) {
                    AutoResizeHelper.setActiveRunnable(null, null);
                    return;
                }
                int[] calculatedRowHeights = MaxCellBoundsHelper.getPreferredRowHeights(this.natTable.getConfigRegistry(), new GCFactory((Drawable)this.natTable), this.bodyDataLayer, rowPos);
                if (calculatedRowHeights != null && calculatedRowHeights.length > 0) {
                    ArrayList<Integer> positions = new ArrayList<Integer>(rowPos.length);
                    ArrayList<Integer> heights = new ArrayList<Integer>(rowPos.length);
                    int i2 = 0;
                    while (i2 < rowPos.length) {
                        int diff;
                        if (this.cancelled) {
                            AutoResizeHelper.setActiveRunnable(null, null);
                            return;
                        }
                        if (calculatedRowHeights[i2] >= 0 && ((diff = rowHeights[i2] - calculatedRowHeights[i2]) < -1 || diff > 1)) {
                            positions.add(rowPos[i2]);
                            heights.add(calculatedRowHeights[i2]);
                        }
                        ++i2;
                    }
                    if (!positions.isEmpty() && !this.cancelled) {
                        this.bodyDataLayer.doCommand(new MultiRowResizeCommand(this.bodyDataLayer, ObjectUtils.asIntArray(positions), ObjectUtils.asIntArray(heights), true));
                    }
                }
            }
            AutoResizeHelper.setActiveRunnable(null, null);
        }
    }
}

