/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaModelStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jdt.launching.environments.IExecutionEnvironmentsManager;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.JavadocLocationManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.eclipse.team.core.RepositoryProvider;

public class ClasspathComputer {
    private static Map<String, Integer> fSeverityTable = null;
    private static final int SEVERITY_ERROR = 3;
    private static final int SEVERITY_WARNING = 2;
    private static final int SEVERITY_IGNORE = 1;

    public static void setClasspath(IProject project, IPluginModelBase model) throws CoreException {
        IClasspathEntry[] entries = ClasspathComputer.getClasspath(project, model, null, false, true);
        JavaCore.create((IProject)project).setRawClasspath(entries, null);
    }

    public static IClasspathEntry[] getClasspath(IProject project, IPluginModelBase model, Map<String, IPath> sourceLibraryMap, boolean clear, boolean overrideCompliance) throws CoreException {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        List<IClasspathEntry> originalClasspath = clear ? List.of() : Arrays.asList(javaProject.getRawClasspath());
        ClasspathConfiguration context = new ClasspathConfiguration(model, javaProject, ClasspathComputer.getClasspathAttributes(project, model), ClasspathComputer.mapFirstSeenByPath(originalClasspath.stream()), new ArrayList<IClasspathEntry>());
        String ee = ClasspathComputer.getExecutionEnvironment(model.getBundleDescription());
        ClasspathComputer.addContainerEntry(ClasspathComputer.getEEPath(ee), context);
        ClasspathComputer.setComplianceOptions(javaProject, ee, overrideCompliance);
        ClasspathComputer.addContainerEntry(PDECore.REQUIRED_PLUGINS_CONTAINER_PATH, context);
        ClasspathComputer.addSourceAndLibraries(sourceLibraryMap != null ? sourceLibraryMap : Collections.emptyMap(), context);
        boolean isTestPlugin = ClasspathComputer.hasTestPluginName(project);
        IClasspathEntry[] entries = ClasspathComputer.collectInOriginalOrder(originalClasspath, context.reloaded, isTestPlugin);
        IJavaModelStatus validation = JavaConventions.validateClasspath((IJavaProject)javaProject, (IClasspathEntry[])entries, (IPath)javaProject.getOutputLocation());
        if (!validation.isOK()) {
            PDECore.logErrorMessage(validation.getMessage());
            throw new CoreException((IStatus)validation);
        }
        return entries;
    }

    private static IClasspathEntry[] collectInOriginalOrder(List<IClasspathEntry> originalClasspath, List<IClasspathEntry> reloaded, boolean isTestPlugin) {
        Map<IPath, IClasspathEntry> resultingReloadedByPath = ClasspathComputer.mapFirstSeenByPath(reloaded.stream());
        ArrayList<IClasspathEntry> result = new ArrayList<IClasspathEntry>(originalClasspath);
        result.replaceAll(e -> {
            IClasspathEntry replacement = (IClasspathEntry)resultingReloadedByPath.remove(ClasspathComputer.pathWithoutEE(e.getPath()));
            return replacement != null ? replacement : e;
        });
        result.addAll(resultingReloadedByPath.values());
        if (isTestPlugin) {
            result.replaceAll(e -> ClasspathComputer.updateTestAttribute(true, e));
        }
        return (IClasspathEntry[])result.toArray(IClasspathEntry[]::new);
    }

    private static Map<IPath, IClasspathEntry> mapFirstSeenByPath(Stream<IClasspathEntry> entryStream) {
        return entryStream.collect(Collectors.toMap(e -> ClasspathComputer.pathWithoutEE(e.getPath()), e -> e, (first, dupe) -> first, LinkedHashMap::new));
    }

    private static IPath pathWithoutEE(IPath path) {
        return PDECore.JRE_CONTAINER_PATH.isPrefixOf(path) ? PDECore.JRE_CONTAINER_PATH : path;
    }

    private static void addContainerEntry(IPath path, ClasspathConfiguration context) {
        IClasspathEntry original = context.originalByPath.get(ClasspathComputer.pathWithoutEE(path));
        context.reloaded.add(JavaCore.newContainerEntry((IPath)path, (IAccessRule[])(original != null ? original.getAccessRules() : null), (IClasspathAttribute[])(original != null ? original.getExtraAttributes() : context.defaultAttrs), (boolean)(original != null ? original.isExported() : false)));
    }

    private static void addSourceAndLibraries(Map<String, IPath> sourceLibraryMap, ClasspathConfiguration context) throws CoreException {
        IPluginLibrary[] libraries = context.model.getPluginBase().getLibraries();
        IBuild build = ClasspathComputer.getBuild(context.javaProject.getProject());
        IPluginLibrary[] iPluginLibraryArray = libraries;
        int n = libraries.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildEntry buildEntry;
            IPluginLibrary library = iPluginLibraryArray[n2];
            IBuildEntry iBuildEntry = buildEntry = build == null ? null : build.getEntry("source." + library.getName());
            if (buildEntry != null) {
                ClasspathComputer.addSourceFolders(buildEntry, context);
            } else if (library.getName().equals(".")) {
                ClasspathComputer.addJARdPlugin(".", sourceLibraryMap, context);
            } else {
                ClasspathComputer.addLibraryEntry(library, sourceLibraryMap, context);
            }
            ++n2;
        }
        if (libraries.length == 0) {
            if (build != null) {
                IBuildEntry buildEntry = build.getEntry("source..");
                if (buildEntry != null) {
                    ClasspathComputer.addSourceFolders(buildEntry, context);
                }
            } else if (ClasspathUtilCore.hasBundleStructure(context.model)) {
                ClasspathComputer.addJARdPlugin(".", sourceLibraryMap, context);
            }
        }
    }

    public static boolean hasTestPluginName(IProject project) {
        String pattern = PDECore.getDefault().getPreferencesManager().getString("test_plugin_pattern");
        return pattern != null && !pattern.isEmpty() && Pattern.compile(pattern).matcher(project.getName()).find();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasTestOnlyClasspath(IProject project) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject == null) {
            return false;
        }
        try {
            boolean hasSources = false;
            IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return hasSources;
                }
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 3) {
                    hasSources = true;
                    if (!entry.isTest()) {
                        return false;
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    public static IClasspathEntry updateTestAttribute(boolean isTestPlugin, IClasspathEntry entry) {
        if (isTestPlugin == entry.isTest() || entry.getEntryKind() != 3) {
            return entry;
        }
        Stream<IClasspathAttribute> cpAttributes = Arrays.stream(entry.getExtraAttributes()).filter(e -> !e.getName().equals("test"));
        if (isTestPlugin) {
            IClasspathAttribute testAttribute = JavaCore.newClasspathAttribute((String)"test", (String)"true");
            cpAttributes = Stream.concat(cpAttributes, Stream.of(testAttribute));
        }
        return JavaCore.newSourceEntry((IPath)entry.getPath(), (IPath[])entry.getInclusionPatterns(), (IPath[])entry.getExclusionPatterns(), (IPath)entry.getOutputLocation(), (IClasspathAttribute[])((IClasspathAttribute[])cpAttributes.toArray(IClasspathAttribute[]::new)));
    }

    private static IClasspathAttribute[] getClasspathAttributes(IProject project, IPluginModelBase model) {
        JavadocLocationManager manager;
        String javadoc;
        IClasspathAttribute[] attributes = new IClasspathAttribute[]{};
        if (!RepositoryProvider.isShared((IProject)project) && (javadoc = (manager = PDECore.getDefault().getJavadocLocationManager()).getJavadocLocation(model)) != null) {
            attributes = new IClasspathAttribute[]{JavaCore.newClasspathAttribute((String)"javadoc_location", (String)javadoc)};
        }
        return attributes;
    }

    /*
     * Unable to fully structure code
     */
    private static void addSourceFolders(IBuildEntry buildEntry, ClasspathConfiguration context) throws CoreException {
        folders = buildEntry.getTokens();
        project = context.javaProject.getProject();
        var7_4 = folders;
        var6_5 = folders.length;
        var5_6 = 0;
        while (var5_6 < var6_5) {
            block4: {
                block5: {
                    block3: {
                        folder = var7_4[var5_6];
                        path = project.getFullPath().append(folder);
                        orig = context.originalByPath.get(ClasspathComputer.pathWithoutEE(path));
                        if (orig == null) break block3;
                        context.reloaded.add(orig);
                        break block4;
                    }
                    if (project.findMember(folder) != null) break block5;
                    CoreUtility.createFolder(project.getFolder(folder));
                    ** GOTO lbl-1000
                }
                root = context.javaProject.getPackageFragmentRoot(path.toString());
                if (root.exists() && root.getKind() == 2) {
                    context.reloaded.add(root.getRawClasspathEntry());
                } else lbl-1000:
                // 2 sources

                {
                    context.reloaded.add(JavaCore.newSourceEntry((IPath)path));
                }
            }
            ++var5_6;
        }
    }

    protected static IBuild getBuild(IProject project) throws CoreException {
        IFile buildFile = PDEProject.getBuildProperties(project);
        IBuildModel buildModel = null;
        if (buildFile.exists()) {
            buildModel = new WorkspaceBuildModel(buildFile);
            buildModel.load();
        }
        return buildModel != null ? buildModel.getBuild() : null;
    }

    private static void addLibraryEntry(IPluginLibrary library, Map<String, IPath> sourceLibraryMap, ClasspathConfiguration context) {
        String name = ClasspathUtilCore.expandLibraryName(library.getName());
        IResource jarFile = context.javaProject.getProject().findMember(name);
        if (jarFile == null) {
            return;
        }
        IPath sourceAttachment = sourceLibraryMap.get(library.getName());
        boolean isExported = library.isExported();
        IPackageFragmentRoot root = context.javaProject.getPackageFragmentRoot(jarFile);
        try {
            if (root.exists() && root.getKind() == 2) {
                IClasspathEntry oldEntry = root.getRawClasspathEntry();
                if (sourceAttachment == null && oldEntry.getSourceAttachmentPath() != null || sourceAttachment != null && sourceAttachment.equals((Object)oldEntry.getSourceAttachmentPath())) {
                    context.reloaded.add(oldEntry);
                    return;
                }
                isExported = oldEntry.isExported();
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        ClasspathComputer.reloadClasspathEntry(jarFile, name, sourceAttachment, isExported, context);
    }

    private static void addJARdPlugin(String libraryName, Map<String, IPath> sourceLibraryMap, ClasspathConfiguration context) {
        String filename = ClasspathUtilCore.getFilename(context.model);
        String name = ClasspathUtilCore.expandLibraryName(filename);
        IResource jarFile = context.javaProject.getProject().findMember(name);
        if (jarFile != null) {
            IPath sourceAttachment = sourceLibraryMap.get(libraryName);
            ClasspathComputer.reloadClasspathEntry(jarFile, filename, sourceAttachment, true, context);
        }
    }

    private static void reloadClasspathEntry(IResource library, String fileName, IPath sourceAttachment, boolean isExported, ClasspathConfiguration context) {
        IClasspathEntry orig = context.originalByPath.get(ClasspathComputer.pathWithoutEE(library.getFullPath()));
        if (orig != null && sourceAttachment == null) {
            sourceAttachment = orig.getSourceAttachmentPath();
        }
        IProject project = context.javaProject.getProject();
        IResource source = sourceAttachment != null ? project.findMember(sourceAttachment) : project.findMember(ClasspathUtilCore.getSourceZipName(fileName));
        sourceAttachment = source == null ? null : source.getFullPath();
        context.reloaded.add(JavaCore.newLibraryEntry((IPath)library.getFullPath(), (IPath)sourceAttachment, null, (IAccessRule[])(orig != null ? orig.getAccessRules() : null), (IClasspathAttribute[])(orig != null ? orig.getExtraAttributes() : context.defaultAttrs), (boolean)(orig != null ? orig.isExported() : isExported)));
    }

    private static String getExecutionEnvironment(BundleDescription bundleDescription) {
        String[] envs;
        if (bundleDescription != null && (envs = bundleDescription.getExecutionEnvironments()).length > 0) {
            return envs[0];
        }
        return null;
    }

    public static void setComplianceOptions(IJavaProject project, String eeId) {
        ClasspathComputer.setComplianceOptions(project, eeId, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setComplianceOptions(IJavaProject project, String eeId, boolean overrideExisting) {
        Map projectMap = project.getOptions(false);
        IExecutionEnvironment ee = null;
        Map options = null;
        if (eeId != null && (ee = JavaRuntime.getExecutionEnvironmentsManager().getEnvironment(eeId)) != null) {
            options = ee.getComplianceOptions();
        }
        if (options == null) {
            if (!overrideExisting || projectMap.isEmpty()) return;
            projectMap.remove("org.eclipse.jdt.core.compiler.compliance");
            projectMap.remove("org.eclipse.jdt.core.compiler.source");
            projectMap.remove("org.eclipse.jdt.core.compiler.codegen.targetPlatform");
            projectMap.remove("org.eclipse.jdt.core.compiler.problem.assertIdentifier");
            projectMap.remove("org.eclipse.jdt.core.compiler.problem.enumIdentifier");
        } else {
            String compliance = (String)options.get("org.eclipse.jdt.core.compiler.compliance");
            for (Map.Entry entry : options.entrySet()) {
                String option = (String)entry.getKey();
                String value = (String)entry.getValue();
                if ("1.3".equals(compliance) || "1.4".equals(compliance)) {
                    if ("org.eclipse.jdt.core.compiler.problem.assertIdentifier".equals(option) || "org.eclipse.jdt.core.compiler.problem.enumIdentifier".equals(option)) {
                        ClasspathComputer.setMinimumCompliance(projectMap, option, value, overrideExisting);
                        continue;
                    }
                    ClasspathComputer.setCompliance(projectMap, option, value, overrideExisting);
                    continue;
                }
                ClasspathComputer.setCompliance(projectMap, option, value, overrideExisting);
            }
        }
        project.setOptions(projectMap);
    }

    private static void setCompliance(Map<String, String> map, String key, String value, boolean override) {
        if (value != null && (override || !map.containsKey(key))) {
            map.put(key, value);
        }
    }

    private static void setMinimumCompliance(Map<String, String> map, String key, String minimumValue, boolean override) {
        if (minimumValue != null && (override || !map.containsKey(key))) {
            int minimum;
            String currentValue;
            if (fSeverityTable == null) {
                fSeverityTable = new HashMap<String, Integer>(3);
                fSeverityTable.put("ignore", 1);
                fSeverityTable.put("warning", 2);
                fSeverityTable.put("error", 3);
            }
            int current = (currentValue = map.get(key)) != null && fSeverityTable.containsKey(currentValue) ? fSeverityTable.get(currentValue) : 0;
            int n = minimum = fSeverityTable.containsKey(minimumValue) ? fSeverityTable.get(minimumValue) : 0;
            if (current < minimum) {
                map.put(key, minimumValue);
            }
        }
    }

    public static IClasspathEntry createJREEntry(String ee) {
        return JavaCore.newContainerEntry((IPath)ClasspathComputer.getEEPath(ee));
    }

    private static IPath getEEPath(String ee) {
        IExecutionEnvironmentsManager manager;
        IExecutionEnvironment env;
        IPath path = null;
        if (ee != null && (env = (manager = JavaRuntime.getExecutionEnvironmentsManager()).getEnvironment(ee)) != null) {
            path = JavaRuntime.newJREContainerPath((IExecutionEnvironment)env);
        }
        if (path == null) {
            path = JavaRuntime.newDefaultJREContainerPath();
        }
        return path;
    }

    public static IClasspathEntry createContainerEntry() {
        return JavaCore.newContainerEntry((IPath)PDECore.REQUIRED_PLUGINS_CONTAINER_PATH);
    }

    private record ClasspathConfiguration(IPluginModelBase model, IJavaProject javaProject, IClasspathAttribute[] defaultAttrs, Map<IPath, IClasspathEntry> originalByPath, List<IClasspathEntry> reloaded) {
    }
}

