/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.example.databinding.project.ui.rcp.dialogs;

import java.util.Comparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.example.databinding.project.ui.rcp.Activator;
import org.eclipse.emf.examples.databinding.project.core.IModelResource;
import org.eclipse.emf.examples.databinding.project.core.model.project.Person;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersonFilterDialog
extends FilteredItemsSelectionDialog {
    private final IModelResource resource;

    public PersonFilterDialog(Shell shell, IModelResource resource) {
        super(shell);
        this.resource = resource;
        this.setListLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element == null) {
                    return "";
                }
                return PersonFilterDialog.this.getText((Person)element);
            }
        });
        this.setDetailsLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element == null) {
                    return "";
                }
                return PersonFilterDialog.this.getText((Person)element);
            }
        });
    }

    private String getText(Person p) {
        return String.valueOf(p.getLastname()) + " " + p.getFirstname();
    }

    protected IStatus validateItem(Object item) {
        return Status.OK_STATUS;
    }

    protected Comparator<?> getItemsComparator() {
        return new Comparator<Person>(){

            @Override
            public int compare(Person o1, Person o2) {
                return PersonFilterDialog.this.getText(o1).compareTo(PersonFilterDialog.this.getText(o2));
            }
        };
    }

    public String getElementName(Object item) {
        Person p = (Person)item;
        return this.getText(p);
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings().getSection("committerdialog");
        if (settings == null) {
            settings = Activator.getDefault().getDialogSettings().addNewSection("committerdialog");
        }
        return settings;
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        for (Person p : this.resource.getFoundation().getPersons()) {
            if (progressMonitor.isCanceled()) {
                return;
            }
            contentProvider.add((Object)p, itemsFilter);
        }
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new FilteredItemsSelectionDialog.ItemsFilter(this){

            public boolean isConsistentItem(Object item) {
                return true;
            }

            public boolean matchItem(Object item) {
                Person p = (Person)item;
                return this.matches(String.valueOf(p.getLastname()) + " " + p.getFirstname());
            }
        };
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }
}

