/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.common.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.ui.CommonUIPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceDialog
extends Dialog {
    protected static final int CONTROL_OFFSET = 10;
    protected String title;
    protected int style;
    protected Text uriField;
    protected String uriText;

    public ResourceDialog(Shell parent, String title, int style) {
        super(parent);
        this.title = title != null ? title : CommonUIPlugin.INSTANCE.getString("_UI_ResourceDialog_title");
        this.style = style;
        this.normalizeStyle();
        this.setShellStyle(this.getShellStyle() | 0x400 | 0x10);
    }

    protected void normalizeStyle() {
        if ((this.style & 0xFFFFCFF9) != 0) {
            throw new IllegalArgumentException("extraneous style bits specified (only SWT.MULTI, SWT.SINGLE, SWT.OPEN, SWT.SAVE allowed");
        }
        if ((this.style & 2) == 0 && (this.style & 4) == 0) {
            this.style |= 4;
        } else if ((this.style & 2) != 0 && (this.style & 4) != 0) {
            throw new IllegalArgumentException("conflicting style bits specified (sWT.MUTLI and SWT.SINGLE)");
        }
        if ((this.style & 0x1000) == 0 && (this.style & 0x2000) == 0) {
            this.style |= 0x1000;
        } else if ((this.style & 0x1000) != 0 && (this.style & 0x2000) != 0) {
            throw new IllegalArgumentException("conflicting style bits specified (sWT.OPEN and SWT.SAVE)");
        }
        if (this.isMulti() && this.isSave()) {
            throw new IllegalArgumentException("conflicting style bits specified (sWT.MULTI and SWT.SAVE)");
        }
    }

    protected boolean isSave() {
        return (this.style & 0x2000) != 0;
    }

    protected boolean isMulti() {
        return (this.style & 2) != 0;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        FormLayout layout = new FormLayout();
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        if (!EMFPlugin.IS_RESOURCES_BUNDLE_AVAILABLE) {
            data.widthHint = 330;
        }
        composite.setLayoutData((Object)data);
        Composite buttonComposite = new Composite(composite, 0);
        Label resourceURILabel = new Label(composite, 16384);
        resourceURILabel.setText(CommonUIPlugin.INSTANCE.getString(this.isMulti() ? "_UI_ResourceURIs_label" : "_UI_ResourceURI_label"));
        FormData data2 = new FormData();
        data2.left = new FormAttachment(0, 10);
        data2.top = new FormAttachment(0, 10);
        resourceURILabel.setLayoutData((Object)data2);
        data2 = new FormData();
        data2.top = new FormAttachment((Control)resourceURILabel, 10, 0x1000000);
        data2.left = new FormAttachment((Control)resourceURILabel, 10);
        data2.right = new FormAttachment(100, -10);
        buttonComposite.setLayoutData((Object)data2);
        buttonComposite.setLayout((Layout)new FormLayout());
        this.uriField = new Text(composite, 2048);
        data2 = new FormData();
        data2.top = new FormAttachment((Control)buttonComposite, 10);
        data2.left = new FormAttachment(0, 10);
        data2.right = new FormAttachment(100, -10);
        this.uriField.setLayoutData((Object)data2);
        Label separatorLabel = new Label(composite, 258);
        FormData data3 = new FormData();
        data3.top = new FormAttachment((Control)this.uriField, 15);
        data3.left = new FormAttachment(0, -10);
        data3.right = new FormAttachment(100, 10);
        separatorLabel.setLayoutData((Object)data3);
        composite.setTabList(new Control[]{this.uriField, buttonComposite});
        return composite;
    }

    protected void okPressed() {
        this.uriText = this.getURIText();
        if (this.processResources()) {
            super.okPressed();
        } else {
            this.uriField.selectAll();
            this.uriField.setFocus();
        }
    }

    public String getURIText() {
        return this.uriField != null && !this.uriField.isDisposed() ? this.uriField.getText() : this.uriText;
    }

    public List<URI> getURIs() {
        ArrayList<URI> uris = new ArrayList<URI>();
        StringTokenizer stringTokenizer = new StringTokenizer(this.getURIText());
        while (stringTokenizer.hasMoreTokens()) {
            String uri = stringTokenizer.nextToken();
            uris.add(URI.createURI((String)uri));
        }
        return uris;
    }

    protected boolean processResources() {
        return true;
    }
}

