/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.pivot.qvtimperative.utilities;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.GraphBuilder;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.XMLStringBuilder;

public class GraphMLBuilder
implements GraphBuilder {
    @NonNull
    protected static String NULL_PLACEHOLDER = "\"<null>\"";
    @NonNull
    protected final XMLStringBuilder s = new XMLStringBuilder();
    private int edgeCount = 0;

    public void appendArrows(@NonNull String source, @NonNull String target) {
        this.s.pushTag("y:Arrows");
        this.s.appendElement("source", source);
        this.s.appendElement("target", target);
        this.s.popTag();
    }

    public void appendBorder(BorderStyle ls) {
        this.s.pushTag("y:BorderStyle");
        this.s.appendElement("color", ls.getColor().toString());
        this.s.appendElement("type", ls.getType().toString());
        this.s.appendElement("width", ls.getWidth().toString());
        this.s.popTag();
    }

    public void appendData(@NonNull String key) {
        this.s.pushTag("data");
        this.s.appendElement("key", key);
        this.s.popTag();
    }

    @Override
    public void appendEdge(@NonNull String sourceId, @NonNull String targetId, @NonNull String lineColor, @NonNull String lineType, @NonNull String sourceArrowType, @NonNull String targetArrowType) {
        this.s.pushTag("edge");
        this.s.appendElement("id", "e" + this.edgeCount++);
        this.s.appendElement("source", "n" + sourceId);
        this.s.appendElement("target", "n" + targetId);
        this.s.pushTag("data");
        this.s.appendElement("key", "d9");
        this.s.pushTag("y:PolyLineEdge");
        this.appendLineStyle(new LineStyle(lineColor, LineType.valueOf(lineType)));
        this.appendArrows(sourceArrowType, targetArrowType);
        this.s.popTag();
        this.s.popTag();
        this.s.popTag();
    }

    @Override
    public void appendEdge(@NonNull String sourceId, @NonNull String targetId, @NonNull String lineColor, @NonNull String lineType, @NonNull String sourceArrowType, @NonNull String targetArrowType, @NonNull String label) {
        this.s.pushTag("edge");
        this.s.appendElement("id", "e" + this.edgeCount++);
        this.s.appendElement("source", "n" + sourceId);
        this.s.appendElement("target", "n" + targetId);
        this.s.pushTag("data");
        this.s.appendElement("key", "d9");
        this.s.pushTag("y:PolyLineEdge");
        this.appendLineStyle(new LineStyle(lineColor, LineType.valueOf(lineType)));
        this.appendArrows(sourceArrowType, targetArrowType);
        this.appendEdgeLabel(label, lineColor);
        this.s.popTag();
        this.s.popTag();
        this.s.popTag();
    }

    public void appendFill(@NonNull String fillColor) {
        this.s.pushTag("y:Fill");
        this.s.appendElement("color", fillColor);
        this.s.appendElement("transparent", "false");
        this.s.popTag();
    }

    public void appendGeometry(Geometry g) {
        this.s.pushTag("y:Geometry");
        this.s.appendElement("height", String.valueOf(g.height));
        this.s.appendElement("width", String.valueOf(g.width));
        this.s.appendElement("x", String.valueOf(g.x_pos));
        this.s.appendElement("y", String.valueOf(g.y_pos));
        this.s.popTag();
    }

    protected void appendEdgeLabel(String label, String labelColor) {
        this.s.pushTag("y:EdgeLabel");
        this.s.appendElement("textColor", labelColor);
        this.s.appendValueAndPopTag(label);
    }

    protected void appendNodeLabel(String label, String labelColor) {
        this.s.pushTag("y:NodeLabel");
        this.s.appendElement("textColor", labelColor);
        this.s.appendValueAndPopTag(label);
    }

    public void appendLineStyle(@NonNull LineStyle ls) {
        this.s.pushTag("y:LineStyle");
        this.s.appendElement("color", ls.getColor().toString());
        this.s.appendElement("type", ls.getType().toString());
        this.s.appendElement("width", ls.getWidth().toString());
        this.s.popTag();
    }

    @Override
    public void appendNode(@NonNull String id, @NonNull String shapeName, @NonNull String fillColor, String label, @NonNull String labelColor) {
        this.s.pushTag("node");
        this.s.appendElement("id", "n" + id);
        this.appendData("d5");
        this.s.pushTag("data");
        this.s.appendElement("key", "d6");
        this.s.pushTag("y:ShapeNode");
        Geometry g = new Geometry();
        g.adjustToText(label, 12, shapeName);
        this.appendGeometry(g);
        this.appendFill(fillColor);
        this.appendBorder(new BorderStyle(labelColor, LineType.line));
        this.appendNodeLabel(label, labelColor);
        this.appendShape(shapeName);
        this.s.popTag();
        this.s.popTag();
        this.s.popTag();
    }

    public void appendShape(@NonNull String shapeName) {
        this.s.pushTag("y:Shape");
        this.s.appendElement("type", shapeName);
        this.s.popTag();
    }

    @Override
    public void close() {
        this.s.popTag();
        this.s.popTag();
    }

    @Override
    public void open() {
        this.s.pushTag("graphml");
        this.s.appendElement("xmlns", "http://graphml.graphdrawing.org/xmlns");
        this.s.appendNewLineElement("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.s.appendNewLineElement("xmlns:y", "http://www.yworks.com/xml/graphml");
        this.s.appendNewLineElement("xmlns:yed", "http://www.yworks.com/xml/yed/3");
        this.s.appendNewLineElement("xsi:schemaLocation", "http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.1/graphml.xsd");
        this.s.pushTag("key");
        this.s.appendElement("attr.name", "description");
        this.s.appendElement("attr.type", "string");
        this.s.appendElement("for", "node");
        this.s.appendElement("id", "d5");
        this.s.popTag();
        this.s.pushTag("key");
        this.s.appendElement("for", "node");
        this.s.appendElement("id", "d6");
        this.s.appendElement("yfiles.type", "nodegraphics");
        this.s.popTag();
        this.s.pushTag("key");
        this.s.appendElement("attr.name", "description");
        this.s.appendElement("attr.type", "string");
        this.s.appendElement("for", "edge");
        this.s.appendElement("id", "d8");
        this.s.popTag();
        this.s.pushTag("key");
        this.s.appendElement("for", "edge");
        this.s.appendElement("id", "d9");
        this.s.appendElement("yfiles.type", "edgegraphics");
        this.s.popTag();
        this.s.pushTag("graph");
        this.s.appendElement("edgedefault", "directed");
        this.s.appendElement("id", "G");
    }

    public String toString() {
        return this.s.toString();
    }

    public static enum ArrowType {
        standard,
        delta,
        diamond,
        white_diamond,
        white_delta,
        none,
        plain,
        concave,
        convex,
        circle,
        dash,
        transparent_circle,
        skewed_dash,
        t_shape;

    }

    public class BorderStyle
    extends LineStyle {
        @NonNull
        public static final String TAG = "y:BorderStyle";

        public BorderStyle(String color, LineType type) {
            super(color, type);
        }
    }

    public class Geometry {
        @NonNull
        public static final String TAG = "y:Geometry";
        @NonNull
        public static final String HEIGHT_KEY = "height";
        @NonNull
        public static final String WIDTH_KEY = "width";
        @NonNull
        public static final String X_KEY = "x";
        @NonNull
        public static final String Y_KEY = "y";
        public final int MIN_HEIGHT = 30;
        public final int MIN_WIDTH = 30;
        public final double PADDING_FACTOR = 1.065;
        private double height;
        private double width;
        private double x_pos;
        private double y_pos;

        public Geometry() {
            this.MIN_HEIGHT = 30;
            this.MIN_WIDTH = 30;
            this.PADDING_FACTOR = 1.065;
            this.height = 30.0;
            this.width = 30.0;
            this.x_pos = 0.0;
            this.y_pos = 0.0;
        }

        public Geometry(double height, double width, double x_pos, double y_pos) {
            this.MIN_HEIGHT = 30;
            this.MIN_WIDTH = 30;
            this.PADDING_FACTOR = 1.065;
            this.height = height;
            this.width = width;
            this.x_pos = x_pos;
            this.y_pos = y_pos;
        }

        public void adjustToText(String text, int fontSize, String shapeName) {
            Font font = new Font("Dialog", 0, fontSize);
            BufferedImage image = new BufferedImage(30, 30, 2);
            Graphics2D g2 = (Graphics2D)image.getGraphics();
            FontMetrics metrics = g2.getFontMetrics(font);
            int hgt = metrics.getHeight();
            int maxW = 0;
            String[] split = text.split("\r\n|\r|\n");
            int numLines = split.length;
            String[] stringArray = split;
            int n = split.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                int w = metrics.stringWidth(s);
                maxW = w > maxW ? w : maxW;
                ++n2;
            }
            int adv = maxW;
            switch (ShapeType.valueOf(shapeName)) {
                case hexagon: {
                    this.width = (double)adv * 1.065 + 0.1 * (double)adv;
                    break;
                }
                default: {
                    this.width = (double)adv * 1.065;
                }
            }
            this.height = (double)(hgt * numLines) * 1.065;
        }
    }

    public class LineStyle {
        @NonNull
        public static final String TAG = "y:LineStyle";
        @NonNull
        public static final String COLOR_KEY = "color";
        @NonNull
        public static final String TYPE_KEY = "type";
        @NonNull
        public static final String WIDTH_KEY = "width";
        private String color;
        private LineType type;
        private Double width = 1.0;

        public LineStyle(String color, LineType type) {
            this.color = color;
            this.type = type;
        }

        public String getColor() {
            return this.color;
        }

        public LineType getType() {
            return this.type;
        }

        public Double getWidth() {
            return this.width;
        }

        public void setColor(String color) {
            this.color = color;
        }

        public void setType(LineType type) {
            this.type = type;
        }

        public void setWidth(Double width) {
            this.width = width;
        }
    }

    public static enum LineType {
        line,
        dashed,
        dotted;

    }

    public static enum ShapeType {
        rectangle,
        roundrectangle,
        ellipse,
        parallelogram,
        hexagon,
        octagon,
        diamond,
        triangle,
        trapezoid,
        trapezoid2,
        rectangle3d;

    }
}

