/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.runtime.internal.evaluation;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.qvtd.runtime.evaluation.AbstractInvocationManager;
import org.eclipse.qvtd.runtime.evaluation.AbstractTransformer;
import org.eclipse.qvtd.runtime.evaluation.Invocation;
import org.eclipse.qvtd.runtime.evaluation.InvocationFailedException;
import org.eclipse.qvtd.runtime.evaluation.SlotState;
import org.eclipse.qvtd.runtime.internal.evaluation.AbstractInvocationInternal;

public class IncrementalInvocationManager
extends AbstractInvocationManager {
    private @Nullable AbstractInvocationInternal blockedInvocations = null;
    private @Nullable AbstractInvocationInternal waitingInvocations = null;
    protected final boolean debugTracing = AbstractTransformer.INVOCATIONS.isActive();

    private synchronized void block(@NonNull Invocation invocation, @NonNull SlotState slotState) {
        AbstractInvocationInternal castInvocation = (AbstractInvocationInternal)invocation;
        assert (castInvocation.debug_blockedBy == null);
        castInvocation.debug_blockedBy = slotState;
        AbstractInvocationInternal blockedInvocations2 = this.blockedInvocations;
        if (blockedInvocations2 == null) {
            this.blockedInvocations = castInvocation;
        } else {
            castInvocation.insertAfter(blockedInvocations2.prev);
        }
        slotState.block(invocation);
        if (this.debugTracing) {
            AbstractTransformer.INVOCATIONS.println("block " + invocation + " for " + slotState);
        }
    }

    @Override
    public boolean flush() throws ReflectiveOperationException {
        this.flushInternal();
        AbstractInvocationInternal blockedInvocation = this.blockedInvocations;
        if (blockedInvocation == null) {
            return true;
        }
        do {
            if (!this.debugTracing) continue;
            AbstractTransformer.INVOCATIONS.println("still blocked " + blockedInvocation + " by " + blockedInvocation.debug_blockedBy);
        } while ((blockedInvocation = blockedInvocation.next) != this.blockedInvocations);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushInternal() throws ReflectiveOperationException {
        while (this.waitingInvocations != null) {
            AbstractInvocationInternal invocation = null;
            IncrementalInvocationManager incrementalInvocationManager = this;
            synchronized (incrementalInvocationManager) {
                AbstractInvocationInternal waitingInvocations2 = this.waitingInvocations;
                if (waitingInvocations2 != null) {
                    invocation = waitingInvocations2;
                    this.waitingInvocations = waitingInvocations2.next;
                    if (this.waitingInvocations == invocation) {
                        this.waitingInvocations = null;
                    }
                    invocation.remove();
                }
            }
            if (invocation == null) continue;
            if (this.debugTracing) {
                AbstractTransformer.INVOCATIONS.println("re-invoke " + invocation);
            }
            this.invoke(invocation, false);
        }
    }

    @Override
    public void invoke(@NonNull Invocation invocation, boolean doFlush) throws ReflectiveOperationException {
        try {
            invocation.execute();
            if (this.debugTracing) {
                AbstractTransformer.INVOCATIONS.println("done " + invocation);
            }
            if (doFlush) {
                this.flushInternal();
            }
        }
        catch (InvocationFailedException e) {
            this.block(invocation, e.slotState);
        }
    }

    @Override
    public synchronized void unblock(@NonNull Invocation invocation) {
        if (this.debugTracing) {
            AbstractTransformer.INVOCATIONS.println("unblock " + invocation);
        }
        AbstractInvocationInternal castInvocation = (AbstractInvocationInternal)invocation;
        assert (castInvocation.debug_blockedBy != null);
        castInvocation.debug_blockedBy = null;
        if (this.blockedInvocations == castInvocation) {
            this.blockedInvocations = castInvocation.next;
            if (this.blockedInvocations == castInvocation) {
                this.blockedInvocations = null;
            }
        }
        castInvocation.remove();
        AbstractInvocationInternal waitingInvocations2 = this.waitingInvocations;
        if (waitingInvocations2 == null) {
            this.waitingInvocations = castInvocation;
        } else {
            castInvocation.insertAfter(waitingInvocations2.prev);
        }
    }
}

