/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.DataType;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.utilities.Nameable;
import org.eclipse.qvtd.compiler.ProblemHandler;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.LoadingRegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.OriginalContentsAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.Concurrency;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.RegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitionAnalysis;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.Connection;
import org.eclipse.qvtd.pivot.qvtschedule.ConnectionEnd;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.EdgeConnection;
import org.eclipse.qvtd.pivot.qvtschedule.LoadingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.NavigationEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.NodeConnection;
import org.eclipse.qvtd.pivot.qvtschedule.Partition;
import org.eclipse.qvtd.pivot.qvtschedule.QVTscheduleFactory;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.Role;
import org.eclipse.qvtd.pivot.qvtschedule.RootRegion;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.DomainUsage;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleConstants;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.SymbolNameBuilder;

public class ConnectionManager {
    private static final @NonNull String JOIN_ATTRIBUTE_PREFIX = "ja";
    private static final @NonNull String JOIN_EDGE_PREFIX = "je_";
    private static final @NonNull String JOIN_INPUT_PREFIX = "ji";
    private static final @NonNull String JOIN_MIDDLE_PREFIX = "jm";
    private static final @NonNull String JOIN_OUTPUT_PREFIX = "jo";
    public static final @NonNull List<@NonNull Partition> EMPTY_PARTITION_LIST = Collections.emptyList();
    protected final @NonNull ScheduleManager scheduleManager;
    protected final @NonNull LoadingRegionAnalysis loadingRegionAnalysis;
    public final @NonNull Map<@NonNull ClassDatum, @NonNull Map<@NonNull Set<@NonNull Node>, @NonNull NodeConnection>> classDatum2nodes2nodeConnections = new HashMap<ClassDatum, Map<Set<Node>, NodeConnection>>();
    public final @NonNull Map<@NonNull Set<@NonNull NavigableEdge>, @NonNull EdgeConnection> edges2edgeConnection = new HashMap<Set<NavigableEdge>, EdgeConnection>();
    private final @NonNull OriginalContentsAnalysis originalContentsAnalysis;
    private final @NonNull Map<@NonNull Partition, @NonNull List<@NonNull Partition>> partition2parents = new HashMap<Partition, List<Partition>>();
    private final @NonNull Map<@NonNull Partition, @NonNull List<@NonNull Partition>> partition2children = new HashMap<Partition, List<Partition>>();

    public ConnectionManager(@NonNull ProblemHandler problemHandler, @NonNull ScheduleManager scheduleManager, @NonNull LoadingRegionAnalysis loadingRegionAnalysis) {
        this.scheduleManager = scheduleManager;
        this.loadingRegionAnalysis = loadingRegionAnalysis;
        this.originalContentsAnalysis = scheduleManager.getOriginalContentsAnalysis();
    }

    public void addCallToChild(@NonNull Partition parentPartition, @NonNull Partition childPartition) {
        this.getCallableChildren(parentPartition).add(childPartition);
        this.getCallableParents(childPartition).add(parentPartition);
    }

    public void createConnections(@NonNull RootRegion rootRegion, @NonNull Iterable<@NonNull Concurrency> partitionSchedule) {
        HashSet<@NonNull Region> regions = new HashSet<Region>();
        for (Concurrency concurrency : partitionSchedule) {
            for (PartitionAnalysis partitionAnalysis : concurrency) {
                regions.add(QVTscheduleUtil.getRegion((Partition)partitionAnalysis.getPartition()));
            }
        }
    }

    private void createAttributeEdgeConnection(@NonNull RootRegion rootRegion, @NonNull Region region, @NonNull Node castTargetNode, @NonNull Iterable<@NonNull NavigableEdge> predicatedEdges) {
        RootRegion invokingRegion2 = rootRegion;
        assert (invokingRegion2 != null);
        Node castTarget = castTargetNode;
        ClassDatum classDatum = QVTscheduleUtil.getClassDatum((Node)castTarget);
        for (NavigableEdge predicatedEdge : predicatedEdges) {
            ArrayList<NavigableEdge> attributeConnectionSourceEdges = null;
            ArrayList<@NonNull String> partialNames = new ArrayList<String>();
            assert (predicatedEdge.isNavigation());
            assert (predicatedEdge.getIncomingConnection() == null);
            assert (!predicatedEdge.isCast());
            Property predicatedProperty = predicatedEdge.getProperty();
            assert (!predicatedProperty.isIsImplicit());
            boolean isDataType = classDatum.getCompleteClass().getPrimaryClass() instanceof DataType;
            assert (isDataType);
            Iterable<@NonNull NavigableEdge> realizedEdges = this.getNewEdges(predicatedEdge, classDatum);
            if (realizedEdges != null) {
                for (NavigableEdge realizedEdge : realizedEdges) {
                    if (!this.scheduleManager.isElementallyConformantSource(realizedEdge, predicatedEdge) || !QVTscheduleUtil.isConformantTarget((NavigableEdge)realizedEdge, (NavigableEdge)predicatedEdge)) continue;
                    if (attributeConnectionSourceEdges == null) {
                        attributeConnectionSourceEdges = new ArrayList<NavigableEdge>();
                    }
                    attributeConnectionSourceEdges.add(realizedEdge);
                }
                partialNames.add(QVTscheduleUtil.getName((Nameable)predicatedEdge.getEdgeSource().getCompleteClass()));
                partialNames.add(QVTscheduleUtil.getName((Nameable)predicatedProperty));
            }
            if (attributeConnectionSourceEdges == null) continue;
            EdgeConnection edgeConnection = this.getAttributeConnection(invokingRegion2, attributeConnectionSourceEdges, partialNames, predicatedProperty);
            edgeConnection.addUsedTargetEdge(predicatedEdge, false);
            if (!QVTscheduleConstants.CONNECTION_CREATION.isActive()) continue;
            QVTscheduleConstants.CONNECTION_CREATION.println("  Attribute EdgeConnection \"" + edgeConnection + "\" to " + castTarget);
        }
    }

    private void createClassEdgeConnection(@NonNull RootRegion rootRegion, @NonNull Region region, @NonNull Node castTargetNode, @NonNull Iterable<@NonNull NavigableEdge> predicatedEdges) {
        RootRegion invokingRegion2 = rootRegion;
        assert (invokingRegion2 != null);
        Node castTarget = castTargetNode;
        ClassDatum classDatum = QVTscheduleUtil.getClassDatum((Node)castTarget);
        for (NavigableEdge predicatedEdge : predicatedEdges) {
            assert (predicatedEdge.isNavigation());
            assert (predicatedEdge.getIncomingConnection() == null);
            assert (!predicatedEdge.isCast());
            Property predicatedProperty = predicatedEdge.getProperty();
            assert (!predicatedProperty.isIsImplicit());
            NavigableEdge castEdge = QVTscheduleUtil.getCastTarget((NavigableEdge)predicatedEdge);
            boolean isDataType = classDatum.getCompleteClass().getPrimaryClass() instanceof DataType;
            assert (!isDataType);
            Iterable<@NonNull Node> sourceNodes = this.getNewNodes(classDatum);
            Iterable<@NonNull NavigableEdge> realizedEdges = this.getNewEdges(predicatedEdge, classDatum);
            if (realizedEdges == null) continue;
            HashSet<@NonNull Region> edgeSourceRegions = new HashSet<Region>();
            HashSet<@NonNull Region> nodeSourceRegions = new HashSet<Region>();
            for (NavigableEdge realizedEdge : realizedEdges) {
                edgeSourceRegions.add(QVTscheduleUtil.getOwningRegion((ConnectionEnd)realizedEdge));
            }
            if (sourceNodes != null) {
                for (Node sourceNode : sourceNodes) {
                    nodeSourceRegions.add(QVTscheduleUtil.getOwningRegion((Node)sourceNode));
                }
            }
            if (!nodeSourceRegions.containsAll(edgeSourceRegions)) {
                HashSet<Region> conformantEdgeSourceRegions = null;
                ArrayList<NavigableEdge> thoseEdges = null;
                for (NavigableEdge realizedEdge : realizedEdges) {
                    if (!this.scheduleManager.isElementallyConformantSource(realizedEdge, predicatedEdge) || !QVTscheduleUtil.isConformantTarget((NavigableEdge)realizedEdge, (NavigableEdge)predicatedEdge)) continue;
                    if (thoseEdges == null) {
                        thoseEdges = new ArrayList<NavigableEdge>();
                        conformantEdgeSourceRegions = new HashSet<Region>();
                    }
                    if (thoseEdges.contains(realizedEdge)) continue;
                    thoseEdges.add(realizedEdge);
                    assert (conformantEdgeSourceRegions != null);
                    conformantEdgeSourceRegions.add(QVTscheduleUtil.getOwningRegion((ConnectionEnd)realizedEdge));
                }
                if (thoseEdges != null && !nodeSourceRegions.containsAll(conformantEdgeSourceRegions)) {
                    EdgeConnection edgeConnection = this.getEdgeConnection(invokingRegion2, thoseEdges, predicatedProperty);
                    if (QVTscheduleConstants.CONNECTION_CREATION.isActive()) {
                        QVTscheduleConstants.CONNECTION_CREATION.println("  EdgeConnection \"" + edgeConnection + "\" to " + predicatedEdge);
                    }
                    if (!Iterables.contains((Iterable)edgeConnection.getTargetEdges(), (Object)castEdge)) {
                        edgeConnection.addUsedTargetEdge(castEdge, false);
                        if (QVTscheduleConstants.CONNECTION_CREATION.isActive()) {
                            for (NavigableEdge thatEdge : thoseEdges) {
                                QVTscheduleConstants.CONNECTION_CREATION.println("    from " + thatEdge.getOwningRegion() + "  : " + thatEdge);
                            }
                        }
                    }
                }
            }
            if (sourceNodes == null || castTarget.isLoaded() || castTarget.isConstant() || castTarget.isHead() || castTarget.isOperation() || castTarget.getIncomingConnection() != null) continue;
            NodeConnection predicatedConnection = this.getNodeConnection(invokingRegion2, sourceNodes, classDatum, this.scheduleManager.getDomainUsage((Element)classDatum));
            predicatedConnection.addUsedTargetNode(castTarget, false);
            if (!QVTscheduleConstants.CONNECTION_CREATION.isActive()) continue;
            QVTscheduleConstants.CONNECTION_CREATION.println("  NodeConnection \"" + predicatedConnection + "\" to " + castTarget);
            for (Node sourceNode : sourceNodes) {
                QVTscheduleConstants.CONNECTION_CREATION.println("    from " + sourceNode.getOwningRegion() + " : " + sourceNode);
            }
        }
    }

    private @NonNull EdgeConnection createEdgeConnection(@NonNull RootRegion rootRegion, @NonNull Set<@NonNull NavigableEdge> sourceSet, @NonNull Property property, @NonNull SymbolNameBuilder s) {
        assert (!property.isIsImplicit());
        EdgeConnection edgeConnection = QVTscheduleFactory.eINSTANCE.createEdgeConnection();
        edgeConnection.setOwningRootRegion(rootRegion);
        edgeConnection.setName(this.scheduleManager.getScheduleModel().reserveSymbolName(s, (Object)edgeConnection));
        QVTscheduleUtil.getSourceEnds((EdgeConnection)edgeConnection).addAll(sourceSet);
        edgeConnection.setReferredProperty(property);
        for (NavigableEdge sourceEdge : sourceSet) {
            assert (Iterables.contains((Iterable)QVTscheduleUtil.getSourceEnds((EdgeConnection)edgeConnection), (Object)sourceEdge));
            List outgoingConnections2 = sourceEdge.getOutgoingConnections();
            assert (!outgoingConnections2.contains(edgeConnection));
            outgoingConnections2.add(edgeConnection);
        }
        return edgeConnection;
    }

    private @Nullable NodeConnection createHeadConnection(@NonNull RootRegion rootRegion, @NonNull Region region, @NonNull Node headNode) {
        RootRegion invokingRegion2 = rootRegion;
        ArrayList<Node> headSources = null;
        boolean isSpeculation = false;
        Iterable<@NonNull Node> sourceNodes = this.getIntroducingOrNewNodes(headNode);
        if (!this.scheduleManager.useActivators() && sourceNodes != null) {
            for (Node sourceNode : sourceNodes) {
                if (!sourceNode.isSpeculation()) continue;
                isSpeculation = true;
            }
        }
        ClassDatum classDatum = QVTscheduleUtil.getClassDatum((Node)headNode);
        if (isSpeculation && !headNode.isSpeculated()) {
            sourceNodes = this.originalContentsAnalysis.getOldNodes(classDatum);
            assert (sourceNodes != null);
        }
        if (sourceNodes != null) {
            for (Node sourceNode : sourceNodes) {
                HashMap<Node, Node> called2calling;
                boolean isSource = true;
                if (!(!isSpeculation || headNode.isSpeculated() || sourceNode.isSpeculated() && sourceNode.isHead())) {
                    isSource = false;
                }
                if (!isSource || !this.isCompatiblePattern(region, headNode, sourceNode, called2calling = new HashMap<Node, Node>())) continue;
                if (headSources == null) {
                    headSources = new ArrayList<Node>();
                }
                headSources.add(sourceNode);
            }
        }
        if (headSources == null) {
            return null;
        }
        NodeConnection headConnection = this.getNodeConnection(invokingRegion2, headSources, classDatum, this.scheduleManager.getDomainUsage((Element)classDatum));
        if (headNode.isDependency()) {
            headConnection.addUsedTargetNode(headNode, false);
        } else {
            headConnection.addPassedTargetNode(headNode);
        }
        if (QVTscheduleConstants.CONNECTION_CREATION.isActive()) {
            QVTscheduleConstants.CONNECTION_CREATION.println(String.valueOf(headNode.isDependency() ? "  Extra NodeConnection " : "  Head NodeConnection \"") + headConnection + "\" to " + headNode);
            for (Node sourceNode : headSources) {
                QVTscheduleConstants.CONNECTION_CREATION.println("    from " + sourceNode.getOwningRegion() + " : " + sourceNode);
            }
        }
        return headConnection;
    }

    private @Nullable Iterable<@NonNull NodeConnection> createHeadConnections(@NonNull RootRegion rootRegion, @NonNull Region region) {
        ArrayList<@NonNull NodeConnection> headConnections = null;
        for (Node headNode : QVTscheduleUtil.getHeadNodes((Region)region)) {
            if (headNode.isDependency()) {
                this.createHeadConnection(rootRegion, region, headNode);
                continue;
            }
            NodeConnection headConnection = this.createHeadConnection(rootRegion, region, headNode);
            if (headConnection == null) {
                this.scheduleManager.addRegionWarning(region, "No incoming connections for " + headNode.getName(), new Object[0]);
                headConnection = this.createHeadConnection(rootRegion, region, headNode);
                return null;
            }
            if (headConnections == null) {
                headConnections = new ArrayList<NodeConnection>();
            }
            headConnections.add(headConnection);
        }
        return headConnections;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void createIncomingConnections(@NonNull RootRegion rootRegion, @NonNull Region region) {
        if (QVTscheduleConstants.CONNECTION_CREATION.isActive()) {
            QVTscheduleConstants.CONNECTION_CREATION.println("connecting " + region);
        }
        assert (!(region instanceof LoadingRegion));
        Iterable<@NonNull NodeConnection> headConnections = this.createHeadConnections(rootRegion, region);
        assert (headConnections != null);
        HashMap<@NonNull Node, @NonNull ArrayList<@NonNull NavigationEdge>> castTargetNode2predicatedEdges = new HashMap<Node, ArrayList<NavigationEdge>>();
        for (NavigationEdge predicatedEdge : region.getPredicatedNavigationEdges()) {
            assert (!predicatedEdge.isCast());
            assert (predicatedEdge.isNavigation());
            assert (predicatedEdge.getIncomingConnection() == null);
            Property predicatedProperty = predicatedEdge.getReferredProperty();
            if (predicatedProperty.isIsImplicit()) continue;
            NavigableEdge castEdge = QVTscheduleUtil.getCastTarget((NavigableEdge)predicatedEdge);
            Node castTargetNode = QVTscheduleUtil.getCastTarget((Node)castEdge.getEdgeTarget());
            ArrayList<@NonNull NavigationEdge> predicatedEdges = (ArrayList<NavigationEdge>)castTargetNode2predicatedEdges.get(castTargetNode);
            if (predicatedEdges == null) {
                predicatedEdges = new ArrayList<NavigationEdge>();
                castTargetNode2predicatedEdges.put(castTargetNode, predicatedEdges);
            }
            predicatedEdges.add(predicatedEdge);
        }
        for (Node castTargetNode : castTargetNode2predicatedEdges.keySet()) {
            @NonNull List predicatedEdges = (List)castTargetNode2predicatedEdges.get(castTargetNode);
            assert (predicatedEdges != null);
            if (castTargetNode.isClass()) {
                this.createClassEdgeConnection(rootRegion, region, castTargetNode, predicatedEdges);
                continue;
            }
            this.createAttributeEdgeConnection(rootRegion, region, castTargetNode, predicatedEdges);
        }
    }

    private @NonNull NodeConnection createNodeConnection(@NonNull RootRegion rootRegion, @NonNull Set<@NonNull Node> sourceSet, @NonNull ClassDatum classDatum, @NonNull SymbolNameBuilder s) {
        NodeConnection connection = QVTscheduleFactory.eINSTANCE.createNodeConnection();
        connection.setOwningRootRegion(rootRegion);
        QVTscheduleUtil.getSourceEnds((NodeConnection)connection).addAll(sourceSet);
        connection.setName(this.scheduleManager.getScheduleModel().reserveSymbolName(s, (Object)connection));
        connection.setClassDatum(classDatum);
        for (Node sourceNode : sourceSet) {
            assert (Iterables.contains((Iterable)QVTscheduleUtil.getSourceEnds((NodeConnection)connection), (Object)sourceNode));
            List outgoingConnections2 = sourceNode.getOutgoingConnections();
            assert (!outgoingConnections2.contains(connection));
            outgoingConnections2.add(connection);
        }
        return connection;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void createPartitionConnections(@NonNull RootRegion rootRegion, @NonNull Region region) {
        NodeConnection connection;
        @NonNull Iterable partitions = QVTscheduleUtil.getRegionPartitions((Region)region);
        RegionAnalysis regionAnalysis = this.scheduleManager.getRegionAnalysis(region);
        if (Iterables.size((Iterable)partitions) <= 1) {
            return;
        }
        List<@NonNull Node> traceNodes = regionAnalysis.getTraceNodes();
        for (Node traceNode : traceNodes) {
            HashSet<@NonNull Node> sourceNodes = new HashSet<Node>();
            for (Partition partition : partitions) {
                Role nodeRole = QVTscheduleUtil.getRole((Partition)partition, (ConnectionEnd)traceNode);
                if (nodeRole == null || !nodeRole.isNew()) continue;
                sourceNodes.add(traceNode);
            }
            if (sourceNodes.isEmpty()) continue;
            ClassDatum classDatum = QVTscheduleUtil.getClassDatum((Node)traceNode);
            connection = this.getNodeConnection(rootRegion, sourceNodes, classDatum, this.scheduleManager.getDomainUsage((Element)classDatum));
            HashSet<@NonNull Node> targetNodes = new HashSet<Node>();
            for (Partition partition : partitions) {
                Role nodeRole = QVTscheduleUtil.getRole((Partition)partition, (ConnectionEnd)traceNode);
                if (nodeRole == null || !nodeRole.isOld() || !targetNodes.add(traceNode)) continue;
                connection.addPassedTargetNode(traceNode);
            }
        }
        for (NavigableEdge edge : region.getRealizedNavigationEdges()) {
            if (edge.isSecondary()) continue;
            boolean isAwaited = false;
            for (PartitionAnalysis partitionAnalysis : regionAnalysis.getPartitionAnalyses()) {
                Role role = partitionAnalysis.getPartition().getRole((Edge)edge);
                if (role == null || !role.isChecked()) continue;
                isAwaited = true;
                break;
            }
            if (!isAwaited) continue;
            Property property = QVTscheduleUtil.getProperty((NavigableEdge)edge);
            connection = this.getEdgeConnection(rootRegion, Collections.singleton(edge), property);
            connection.addUsedTargetEdge(edge, true);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private @NonNull EdgeConnection getAttributeConnection(@NonNull RootRegion rootRegion, @NonNull Iterable<@NonNull NavigableEdge> sourceEdges, @NonNull List<@NonNull String> partialNames, @NonNull Property property) {
        @NonNull HashSet sourceSet = Sets.newHashSet(sourceEdges);
        EdgeConnection connection = this.edges2edgeConnection.get(sourceSet);
        if (connection == null) {
            SymbolNameBuilder s = new SymbolNameBuilder();
            s.appendString(JOIN_ATTRIBUTE_PREFIX);
            for (String partialName : partialNames) {
                s.appendString("_");
                s.appendName(partialName);
            }
            connection = this.createEdgeConnection(rootRegion, sourceSet, property, s);
            this.edges2edgeConnection.put(sourceSet, connection);
        }
        return connection;
    }

    public @NonNull List<@NonNull Partition> getCallableChildren(@NonNull Partition partition) {
        List<@NonNull Partition> children = this.partition2children.get(partition);
        if (children == null) {
            children = new ArrayList<Partition>();
            this.partition2children.put(partition, children);
        }
        return children;
    }

    public @NonNull List<@NonNull Partition> getCallableParents(@NonNull Partition partition) {
        List<@NonNull Partition> parents = this.partition2parents.get(partition);
        if (parents == null) {
            parents = new ArrayList<Partition>();
            this.partition2parents.put(partition, parents);
        }
        return parents;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private @NonNull EdgeConnection getEdgeConnection(@NonNull RootRegion rootRegion, @NonNull Iterable<@NonNull NavigableEdge> sourceEdges, @NonNull Property property) {
        @NonNull HashSet sourceSet = Sets.newHashSet(sourceEdges);
        EdgeConnection connection = this.edges2edgeConnection.get(sourceSet);
        if (connection == null) {
            SymbolNameBuilder s = new SymbolNameBuilder();
            s.appendString(JOIN_EDGE_PREFIX);
            s.appendName(property.getOwningClass().getName());
            s.appendString("_");
            s.appendName(property.getName());
            connection = this.createEdgeConnection(rootRegion, sourceSet, property, s);
            this.edges2edgeConnection.put(sourceSet, connection);
        }
        return connection;
    }

    public @NonNull Iterable<@NonNull Connection> getIncomingConnections(@NonNull PartitionAnalysis partitionAnalysis) {
        NodeConnection connection;
        Partition partition = partitionAnalysis.getPartition();
        ArrayList<@NonNull Connection> connections = new ArrayList<Connection>();
        for (Node headNode : QVTscheduleUtil.getHeadNodes((Partition)partition)) {
            connection = headNode.getIncomingPassedConnection();
            if (connection == null || connections.contains(connection)) continue;
            connections.add((Connection)connection);
        }
        for (Node node : partition.getPartialNodes()) {
            if (node.isHead() && !node.isDependency() || (connection = this.getIncomingUsedConnection(node)) == null || connections.contains(connection)) continue;
            connections.add((Connection)connection);
        }
        for (Edge edge : partition.getPartialEdges()) {
            NavigationEdge navigationEdge;
            EdgeConnection connection2;
            if (!partitionAnalysis.isChecked(edge) || !edge.isNavigation() || (connection2 = (navigationEdge = (NavigationEdge)edge).getIncomingConnection()) == null || connections.contains(connection2)) continue;
            connections.add((Connection)connection2);
        }
        return connections;
    }

    public @Nullable NodeConnection getIncomingUsedConnection(@NonNull Node node) {
        NodeConnection incomingConnection = node.getIncomingConnection();
        if (incomingConnection != null && incomingConnection.isUsed(node)) {
            return incomingConnection;
        }
        return null;
    }

    private @Nullable Iterable<@NonNull Node> getIntroducingOrNewNodes(@NonNull Node headNode) {
        ClassDatum classDatum = QVTscheduleUtil.getClassDatum((Node)headNode);
        if (!this.scheduleManager.getDomainUsage((Element)classDatum).isInput()) {
            return this.originalContentsAnalysis.getNewNodes(classDatum);
        }
        ArrayList<@NonNull Node> nodes = new ArrayList<Node>();
        nodes.add(this.loadingRegionAnalysis.getIntroducerNode(headNode));
        for (TypedModel dependsOn : QVTbaseUtil.getDependsOns((TypedModel)QVTscheduleUtil.getTypedModel((ClassDatum)classDatum))) {
            ClassDatum classDatum2 = this.scheduleManager.getClassDatum(dependsOn, headNode.getCompleteClass().getPrimaryClass());
            Iterable<@NonNull Node> newNodes = this.originalContentsAnalysis.getNewNodes(classDatum2);
            if (newNodes == null) continue;
            for (Node newNode : newNodes) {
                if (nodes.contains(newNode)) continue;
                nodes.add(newNode);
            }
        }
        return nodes;
    }

    public @NonNull List<@NonNull Connection> getLoopingConnections(@NonNull Partition partition) {
        ArrayList<@NonNull Connection> loopingConnections = new ArrayList<Connection>();
        for (Connection connection : this.getOutgoingConnections(partition)) {
            for (Partition sourcePartition : connection.getSourcePartitions()) {
                if (partition != sourcePartition) continue;
                for (Partition targetPartition : connection.getTargetPartitions()) {
                    if (partition != targetPartition || loopingConnections.contains(connection)) continue;
                    loopingConnections.add(connection);
                }
            }
        }
        return loopingConnections;
    }

    private @Nullable Iterable<@NonNull NavigableEdge> getNewEdges(@NonNull NavigableEdge edge, @NonNull ClassDatum requiredClassDatum) {
        return this.originalContentsAnalysis.getNewEdges(edge, requiredClassDatum);
    }

    private @Nullable Iterable<@NonNull Node> getNewNodes(@NonNull ClassDatum classDatum) {
        return this.originalContentsAnalysis.getNewNodes(classDatum);
    }

    public @NonNull Iterable<@NonNull Connection> getNextConnections(@NonNull Partition partition) {
        return this.getOutgoingConnections(partition);
    }

    private @NonNull NodeConnection getNodeConnection(@NonNull RootRegion rootRegion, @NonNull Iterable<@NonNull Node> sourceNodes, @NonNull ClassDatum classDatum, @NonNull DomainUsage domainUsage) {
        HashSet sourceSet;
        NodeConnection connection;
        Map<@NonNull Set<@NonNull Node>, @NonNull NodeConnection> nodes2connection = this.classDatum2nodes2nodeConnections.get(classDatum);
        if (nodes2connection == null) {
            nodes2connection = new HashMap<Set<Node>, NodeConnection>();
            this.classDatum2nodes2nodeConnections.put(classDatum, nodes2connection);
        }
        if ((connection = nodes2connection.get(sourceSet = Sets.newHashSet(sourceNodes))) == null) {
            SymbolNameBuilder s = new SymbolNameBuilder();
            s.appendString(domainUsage.isInput() ? JOIN_INPUT_PREFIX : (domainUsage.isOutput() ? JOIN_OUTPUT_PREFIX : JOIN_MIDDLE_PREFIX));
            s.appendString("_");
            s.appendName(classDatum.getCompleteClass().getName());
            connection = this.createNodeConnection(rootRegion, sourceSet, classDatum, s);
            nodes2connection.put(sourceSet, connection);
        }
        return connection;
    }

    public @NonNull List<@NonNull Connection> getOutgoingConnections(@NonNull Partition partition) {
        Role role;
        ArrayList<@NonNull Connection> connections = new ArrayList<Connection>();
        for (Node node : partition.getPartialNodes()) {
            role = partition.getRole(node);
            if (role == null || role.isChecked()) continue;
            for (NodeConnection connection : node.getOutgoingPassedConnections()) {
                connections.add((Connection)connection);
            }
            for (NodeConnection connection : node.getOutgoingUsedBindingEdges()) {
                connections.add((Connection)connection);
            }
        }
        for (Edge edge : partition.getPartialEdges()) {
            if (!edge.isNavigation() || (role = partition.getRole(edge)) == null || role.isChecked()) continue;
            for (NodeConnection connection : QVTscheduleUtil.getOutgoingConnections((NavigableEdge)((NavigableEdge)edge))) {
                connections.add((Connection)connection);
            }
        }
        return connections;
    }

    public @NonNull ScheduleManager getScheduleManager() {
        return this.scheduleManager;
    }

    public @NonNull Iterable<@NonNull Node> getPassedBindingSources(@NonNull Node node) {
        ArrayList<@NonNull Node> sources = new ArrayList<Node>();
        NodeConnection connection = node.getIncomingPassedConnection();
        if (connection != null) {
            for (Node source : QVTscheduleUtil.getSourceEnds((NodeConnection)connection)) {
                if (sources.contains(source)) continue;
                sources.add(source);
            }
        }
        return sources;
    }

    public @NonNull Iterable<@NonNull Node> getUsedBindingSources(@NonNull Node node) {
        ArrayList<@NonNull Node> sources = new ArrayList<Node>();
        NodeConnection connection = this.getIncomingUsedConnection(node);
        if (connection != null) {
            for (Node source : QVTscheduleUtil.getSourceEnds((NodeConnection)connection)) {
                if (sources.contains(source)) continue;
                sources.add(source);
            }
        }
        return sources;
    }

    private boolean isCompatiblePattern(@NonNull Region region, @NonNull Node calledNode, @NonNull Node callingNode, @NonNull Map<@NonNull Node, @NonNull Node> called2calling) {
        Node oldPrevNode = called2calling.put(calledNode, callingNode);
        if (oldPrevNode != null) {
            return oldPrevNode == callingNode;
        }
        for (NavigableEdge calledEdge : calledNode.getNavigableEdges()) {
            NavigableEdge nextCallingEdge;
            Node nextCalledNode = calledEdge.getEdgeTarget();
            if (nextCalledNode.isRealized() || nextCalledNode.isDataType() || (nextCallingEdge = callingNode.getNavigableEdge(QVTscheduleUtil.getProperty((NavigableEdge)calledEdge))) == null) continue;
            Node nextCallingNode = nextCallingEdge.getEdgeTarget();
            if (nextCallingNode.isNullLiteral() != nextCalledNode.isNullLiteral()) {
                return false;
            }
            if (this.isCompatiblePattern(region, nextCalledNode, nextCallingNode, called2calling)) continue;
            return false;
        }
        return true;
    }

    public void removeCallToChild(@NonNull Partition parentPartition, @NonNull Partition childPartition) {
        this.getCallableChildren(parentPartition).remove(childPartition);
        this.getCallableParents(childPartition).remove(parentPartition);
    }

    public void replaceCallToChild(@NonNull Partition parentPartition, @NonNull Partition oldPartition, @NonNull Partition newPartition) {
        List<@NonNull Partition> parentPartitionCallableChildren = this.getCallableChildren(parentPartition);
        int index = parentPartitionCallableChildren.indexOf(oldPartition);
        parentPartitionCallableChildren.remove(oldPartition);
        parentPartitionCallableChildren.add(index, newPartition);
        List<@NonNull Partition> oldPartitionCallableParents = this.getCallableParents(oldPartition);
        oldPartitionCallableParents.remove(parentPartition);
        oldPartitionCallableParents.add(parentPartition);
    }
}

